/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.kubernetes;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.pulsar.common.configuration.FieldContext;
import org.apache.pulsar.common.nar.NarClassLoader;

public class KubernetesRuntimeFactoryConfig {
    @FieldContext(doc="Uri to kubernetes cluster, leave it to empty and it will use the kubernetes settings in function worker machine")
    protected String k8Uri;
    @FieldContext(doc="The Kubernetes namespace to run the function instances. It is `default`, if this setting is left to be empty")
    protected String jobNamespace;
    @FieldContext(doc="The Kubernetes pod name to run the function instances. It is set to`pf-<tenant>-<namespace>-<function_name>-<random_uuid(8)>` if this setting is left to be empty")
    protected String jobName;
    @FieldContext(doc="The docker image used to run function instance. By default it is `apachepulsar/pulsar`")
    protected String pulsarDockerImageName;
    @FieldContext(doc="The function docker images used to run function instance according to different configurations provided by users. By default it is `apachepulsar/pulsar`")
    protected Map<String, String> functionDockerImages;
    @FieldContext(doc="The image pull policy for image used to run function instance. By default it is `IfNotPresent`")
    protected String imagePullPolicy;
    @FieldContext(doc="The root directory of pulsar home directory in the pulsar docker image specified `pulsarDockerImageName`. By default it is under `/pulsar`. If you are using your own customized image in `pulsarDockerImageName`, you need to set this setting accordingly")
    protected String pulsarRootDir;
    @FieldContext(doc="The config admin CLI allows users to customize the configuration of the admin cli tool, such as: `/bin/pulsar-admin and /bin/pulsarctl`. By default it is `/bin/pulsar-admin`. If you want to use `pulsarctl`  you need to set this setting accordingly")
    protected String configAdminCLI;
    @FieldContext(doc="This setting only takes effects if `k8Uri` is set to null. If your function worker is also running as a k8s pod, set this to `true` is let function worker to submit functions to the same k8s cluster as function worker is running. Set this to `false` if your function worker is not running as a k8s pod")
    protected Boolean submittingInsidePod;
    @FieldContext(doc="The pulsar service url that pulsar functions should use to connect to pulsar. If it is not set, it will use the pulsar service url configured in function worker.")
    protected String pulsarServiceUrl;
    @FieldContext(doc="The pulsar admin url that pulsar functions should use to connect to pulsar. If it is not set, it will use the pulsar admin url configured in function worker.")
    protected String pulsarAdminUrl;
    @FieldContext(doc="The flag indicates to install user code dependencies. (applied to python package)")
    protected Boolean installUserCodeDependencies;
    @FieldContext(doc="The repository that pulsar functions use to download python dependencies")
    protected String pythonDependencyRepository;
    @FieldContext(doc="The repository that pulsar functions use to download extra python dependencies")
    protected String pythonExtraDependencyRepository;
    @FieldContext(doc="the directory for dropping extra function dependencies. If it is not absolute path, it is relative to `pulsarRootDir`")
    protected String extraFunctionDependenciesDir;
    @FieldContext(doc="The custom labels that function worker uses to select the nodes for pods")
    protected Map<String, String> customLabels;
    @FieldContext(doc="The expected metrics collection interval, in seconds")
    protected Integer expectedMetricsCollectionInterval = 30;
    @FieldContext(doc="Kubernetes Runtime will periodically checkback on this configMap if defined and if there are any changes to the kubernetes specific stuff, we apply those changes")
    protected String changeConfigMap;
    @FieldContext(doc="The namespace for storing change config map")
    protected String changeConfigMapNamespace;
    @FieldContext(doc="Additional memory padding added on top of the memory requested by the function per on a per instance basis")
    protected int percentMemoryPadding;
    @FieldContext(doc="The ratio cpu request and cpu limit to be set for a function/source/sink.  The formula for cpu request is cpuRequest = userRequestCpu / cpuOverCommitRatio")
    protected double cpuOverCommitRatio = 1.0;
    @FieldContext(doc="The ratio memory request and memory limit to be set for a function/source/sink.  The formula for memory request is memoryRequest = userRequestMemory / memoryOverCommitRatio")
    protected double memoryOverCommitRatio = 1.0;
    @FieldContext(doc="The port inside the function pod which is used by the worker to communicate with the pod")
    private Integer grpcPort = 9093;
    @FieldContext(doc="The port inside the function pod on which prometheus metrics are exposed")
    private Integer metricsPort = 9094;
    @FieldContext(doc="The directory inside the function pod where nar packages will be extracted")
    private String narExtractionDirectory = NarClassLoader.DEFAULT_NAR_EXTRACTION_DIR;
    @FieldContext(doc="The classpath where function instance files stored")
    private String functionInstanceClassPath = "";
    @FieldContext(doc="The duration in seconds before the StatefulSet deleted on function stop/restart. Value must be non-negative integer. The value zero indicates delete immediately. Default is 5 seconds.")
    protected int gracePeriodSeconds = 5;
    @FieldContext(doc="A map of custom configurations passed to implementations of the KubernetesFunctionAuthProvider interface.")
    private Map<String, Object> kubernetesFunctionAuthProviderConfig = new HashMap<String, Object>();

    @Generated
    public KubernetesRuntimeFactoryConfig() {
    }

    @Generated
    public String getK8Uri() {
        return this.k8Uri;
    }

    @Generated
    public String getJobNamespace() {
        return this.jobNamespace;
    }

    @Generated
    public String getJobName() {
        return this.jobName;
    }

    @Generated
    public String getPulsarDockerImageName() {
        return this.pulsarDockerImageName;
    }

    @Generated
    public Map<String, String> getFunctionDockerImages() {
        return this.functionDockerImages;
    }

    @Generated
    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    @Generated
    public String getPulsarRootDir() {
        return this.pulsarRootDir;
    }

    @Generated
    public String getConfigAdminCLI() {
        return this.configAdminCLI;
    }

    @Generated
    public Boolean getSubmittingInsidePod() {
        return this.submittingInsidePod;
    }

    @Generated
    public String getPulsarServiceUrl() {
        return this.pulsarServiceUrl;
    }

    @Generated
    public String getPulsarAdminUrl() {
        return this.pulsarAdminUrl;
    }

    @Generated
    public Boolean getInstallUserCodeDependencies() {
        return this.installUserCodeDependencies;
    }

    @Generated
    public String getPythonDependencyRepository() {
        return this.pythonDependencyRepository;
    }

    @Generated
    public String getPythonExtraDependencyRepository() {
        return this.pythonExtraDependencyRepository;
    }

    @Generated
    public String getExtraFunctionDependenciesDir() {
        return this.extraFunctionDependenciesDir;
    }

    @Generated
    public Map<String, String> getCustomLabels() {
        return this.customLabels;
    }

    @Generated
    public Integer getExpectedMetricsCollectionInterval() {
        return this.expectedMetricsCollectionInterval;
    }

    @Generated
    public String getChangeConfigMap() {
        return this.changeConfigMap;
    }

    @Generated
    public String getChangeConfigMapNamespace() {
        return this.changeConfigMapNamespace;
    }

    @Generated
    public int getPercentMemoryPadding() {
        return this.percentMemoryPadding;
    }

    @Generated
    public double getCpuOverCommitRatio() {
        return this.cpuOverCommitRatio;
    }

    @Generated
    public double getMemoryOverCommitRatio() {
        return this.memoryOverCommitRatio;
    }

    @Generated
    public Integer getGrpcPort() {
        return this.grpcPort;
    }

    @Generated
    public Integer getMetricsPort() {
        return this.metricsPort;
    }

    @Generated
    public String getNarExtractionDirectory() {
        return this.narExtractionDirectory;
    }

    @Generated
    public String getFunctionInstanceClassPath() {
        return this.functionInstanceClassPath;
    }

    @Generated
    public int getGracePeriodSeconds() {
        return this.gracePeriodSeconds;
    }

    @Generated
    public Map<String, Object> getKubernetesFunctionAuthProviderConfig() {
        return this.kubernetesFunctionAuthProviderConfig;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setK8Uri(String k8Uri) {
        this.k8Uri = k8Uri;
        return this;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setJobNamespace(String jobNamespace) {
        this.jobNamespace = jobNamespace;
        return this;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setJobName(String jobName) {
        this.jobName = jobName;
        return this;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setPulsarDockerImageName(String pulsarDockerImageName) {
        this.pulsarDockerImageName = pulsarDockerImageName;
        return this;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setFunctionDockerImages(Map<String, String> functionDockerImages) {
        this.functionDockerImages = functionDockerImages;
        return this;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return this;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setPulsarRootDir(String pulsarRootDir) {
        this.pulsarRootDir = pulsarRootDir;
        return this;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setConfigAdminCLI(String configAdminCLI) {
        this.configAdminCLI = configAdminCLI;
        return this;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setSubmittingInsidePod(Boolean submittingInsidePod) {
        this.submittingInsidePod = submittingInsidePod;
        return this;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setPulsarServiceUrl(String pulsarServiceUrl) {
        this.pulsarServiceUrl = pulsarServiceUrl;
        return this;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setPulsarAdminUrl(String pulsarAdminUrl) {
        this.pulsarAdminUrl = pulsarAdminUrl;
        return this;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setInstallUserCodeDependencies(Boolean installUserCodeDependencies) {
        this.installUserCodeDependencies = installUserCodeDependencies;
        return this;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setPythonDependencyRepository(String pythonDependencyRepository) {
        this.pythonDependencyRepository = pythonDependencyRepository;
        return this;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setPythonExtraDependencyRepository(String pythonExtraDependencyRepository) {
        this.pythonExtraDependencyRepository = pythonExtraDependencyRepository;
        return this;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setExtraFunctionDependenciesDir(String extraFunctionDependenciesDir) {
        this.extraFunctionDependenciesDir = extraFunctionDependenciesDir;
        return this;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setCustomLabels(Map<String, String> customLabels) {
        this.customLabels = customLabels;
        return this;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setExpectedMetricsCollectionInterval(Integer expectedMetricsCollectionInterval) {
        this.expectedMetricsCollectionInterval = expectedMetricsCollectionInterval;
        return this;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setChangeConfigMap(String changeConfigMap) {
        this.changeConfigMap = changeConfigMap;
        return this;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setChangeConfigMapNamespace(String changeConfigMapNamespace) {
        this.changeConfigMapNamespace = changeConfigMapNamespace;
        return this;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setPercentMemoryPadding(int percentMemoryPadding) {
        this.percentMemoryPadding = percentMemoryPadding;
        return this;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setCpuOverCommitRatio(double cpuOverCommitRatio) {
        this.cpuOverCommitRatio = cpuOverCommitRatio;
        return this;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setMemoryOverCommitRatio(double memoryOverCommitRatio) {
        this.memoryOverCommitRatio = memoryOverCommitRatio;
        return this;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setGrpcPort(Integer grpcPort) {
        this.grpcPort = grpcPort;
        return this;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setMetricsPort(Integer metricsPort) {
        this.metricsPort = metricsPort;
        return this;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setNarExtractionDirectory(String narExtractionDirectory) {
        this.narExtractionDirectory = narExtractionDirectory;
        return this;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setFunctionInstanceClassPath(String functionInstanceClassPath) {
        this.functionInstanceClassPath = functionInstanceClassPath;
        return this;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setGracePeriodSeconds(int gracePeriodSeconds) {
        this.gracePeriodSeconds = gracePeriodSeconds;
        return this;
    }

    @Generated
    public KubernetesRuntimeFactoryConfig setKubernetesFunctionAuthProviderConfig(Map<String, Object> kubernetesFunctionAuthProviderConfig) {
        this.kubernetesFunctionAuthProviderConfig = kubernetesFunctionAuthProviderConfig;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesRuntimeFactoryConfig)) {
            return false;
        }
        KubernetesRuntimeFactoryConfig other = (KubernetesRuntimeFactoryConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPercentMemoryPadding() != other.getPercentMemoryPadding()) {
            return false;
        }
        if (Double.compare(this.getCpuOverCommitRatio(), other.getCpuOverCommitRatio()) != 0) {
            return false;
        }
        if (Double.compare(this.getMemoryOverCommitRatio(), other.getMemoryOverCommitRatio()) != 0) {
            return false;
        }
        if (this.getGracePeriodSeconds() != other.getGracePeriodSeconds()) {
            return false;
        }
        Boolean this$submittingInsidePod = this.getSubmittingInsidePod();
        Boolean other$submittingInsidePod = other.getSubmittingInsidePod();
        if (this$submittingInsidePod == null ? other$submittingInsidePod != null : !((Object)this$submittingInsidePod).equals(other$submittingInsidePod)) {
            return false;
        }
        Boolean this$installUserCodeDependencies = this.getInstallUserCodeDependencies();
        Boolean other$installUserCodeDependencies = other.getInstallUserCodeDependencies();
        if (this$installUserCodeDependencies == null ? other$installUserCodeDependencies != null : !((Object)this$installUserCodeDependencies).equals(other$installUserCodeDependencies)) {
            return false;
        }
        Integer this$expectedMetricsCollectionInterval = this.getExpectedMetricsCollectionInterval();
        Integer other$expectedMetricsCollectionInterval = other.getExpectedMetricsCollectionInterval();
        if (this$expectedMetricsCollectionInterval == null ? other$expectedMetricsCollectionInterval != null : !((Object)this$expectedMetricsCollectionInterval).equals(other$expectedMetricsCollectionInterval)) {
            return false;
        }
        Integer this$grpcPort = this.getGrpcPort();
        Integer other$grpcPort = other.getGrpcPort();
        if (this$grpcPort == null ? other$grpcPort != null : !((Object)this$grpcPort).equals(other$grpcPort)) {
            return false;
        }
        Integer this$metricsPort = this.getMetricsPort();
        Integer other$metricsPort = other.getMetricsPort();
        if (this$metricsPort == null ? other$metricsPort != null : !((Object)this$metricsPort).equals(other$metricsPort)) {
            return false;
        }
        String this$k8Uri = this.getK8Uri();
        String other$k8Uri = other.getK8Uri();
        if (this$k8Uri == null ? other$k8Uri != null : !this$k8Uri.equals(other$k8Uri)) {
            return false;
        }
        String this$jobNamespace = this.getJobNamespace();
        String other$jobNamespace = other.getJobNamespace();
        if (this$jobNamespace == null ? other$jobNamespace != null : !this$jobNamespace.equals(other$jobNamespace)) {
            return false;
        }
        String this$jobName = this.getJobName();
        String other$jobName = other.getJobName();
        if (this$jobName == null ? other$jobName != null : !this$jobName.equals(other$jobName)) {
            return false;
        }
        String this$pulsarDockerImageName = this.getPulsarDockerImageName();
        String other$pulsarDockerImageName = other.getPulsarDockerImageName();
        if (this$pulsarDockerImageName == null ? other$pulsarDockerImageName != null : !this$pulsarDockerImageName.equals(other$pulsarDockerImageName)) {
            return false;
        }
        Map<String, String> this$functionDockerImages = this.getFunctionDockerImages();
        Map<String, String> other$functionDockerImages = other.getFunctionDockerImages();
        if (this$functionDockerImages == null ? other$functionDockerImages != null : !((Object)this$functionDockerImages).equals(other$functionDockerImages)) {
            return false;
        }
        String this$imagePullPolicy = this.getImagePullPolicy();
        String other$imagePullPolicy = other.getImagePullPolicy();
        if (this$imagePullPolicy == null ? other$imagePullPolicy != null : !this$imagePullPolicy.equals(other$imagePullPolicy)) {
            return false;
        }
        String this$pulsarRootDir = this.getPulsarRootDir();
        String other$pulsarRootDir = other.getPulsarRootDir();
        if (this$pulsarRootDir == null ? other$pulsarRootDir != null : !this$pulsarRootDir.equals(other$pulsarRootDir)) {
            return false;
        }
        String this$configAdminCLI = this.getConfigAdminCLI();
        String other$configAdminCLI = other.getConfigAdminCLI();
        if (this$configAdminCLI == null ? other$configAdminCLI != null : !this$configAdminCLI.equals(other$configAdminCLI)) {
            return false;
        }
        String this$pulsarServiceUrl = this.getPulsarServiceUrl();
        String other$pulsarServiceUrl = other.getPulsarServiceUrl();
        if (this$pulsarServiceUrl == null ? other$pulsarServiceUrl != null : !this$pulsarServiceUrl.equals(other$pulsarServiceUrl)) {
            return false;
        }
        String this$pulsarAdminUrl = this.getPulsarAdminUrl();
        String other$pulsarAdminUrl = other.getPulsarAdminUrl();
        if (this$pulsarAdminUrl == null ? other$pulsarAdminUrl != null : !this$pulsarAdminUrl.equals(other$pulsarAdminUrl)) {
            return false;
        }
        String this$pythonDependencyRepository = this.getPythonDependencyRepository();
        String other$pythonDependencyRepository = other.getPythonDependencyRepository();
        if (this$pythonDependencyRepository == null ? other$pythonDependencyRepository != null : !this$pythonDependencyRepository.equals(other$pythonDependencyRepository)) {
            return false;
        }
        String this$pythonExtraDependencyRepository = this.getPythonExtraDependencyRepository();
        String other$pythonExtraDependencyRepository = other.getPythonExtraDependencyRepository();
        if (this$pythonExtraDependencyRepository == null ? other$pythonExtraDependencyRepository != null : !this$pythonExtraDependencyRepository.equals(other$pythonExtraDependencyRepository)) {
            return false;
        }
        String this$extraFunctionDependenciesDir = this.getExtraFunctionDependenciesDir();
        String other$extraFunctionDependenciesDir = other.getExtraFunctionDependenciesDir();
        if (this$extraFunctionDependenciesDir == null ? other$extraFunctionDependenciesDir != null : !this$extraFunctionDependenciesDir.equals(other$extraFunctionDependenciesDir)) {
            return false;
        }
        Map<String, String> this$customLabels = this.getCustomLabels();
        Map<String, String> other$customLabels = other.getCustomLabels();
        if (this$customLabels == null ? other$customLabels != null : !((Object)this$customLabels).equals(other$customLabels)) {
            return false;
        }
        String this$changeConfigMap = this.getChangeConfigMap();
        String other$changeConfigMap = other.getChangeConfigMap();
        if (this$changeConfigMap == null ? other$changeConfigMap != null : !this$changeConfigMap.equals(other$changeConfigMap)) {
            return false;
        }
        String this$changeConfigMapNamespace = this.getChangeConfigMapNamespace();
        String other$changeConfigMapNamespace = other.getChangeConfigMapNamespace();
        if (this$changeConfigMapNamespace == null ? other$changeConfigMapNamespace != null : !this$changeConfigMapNamespace.equals(other$changeConfigMapNamespace)) {
            return false;
        }
        String this$narExtractionDirectory = this.getNarExtractionDirectory();
        String other$narExtractionDirectory = other.getNarExtractionDirectory();
        if (this$narExtractionDirectory == null ? other$narExtractionDirectory != null : !this$narExtractionDirectory.equals(other$narExtractionDirectory)) {
            return false;
        }
        String this$functionInstanceClassPath = this.getFunctionInstanceClassPath();
        String other$functionInstanceClassPath = other.getFunctionInstanceClassPath();
        if (this$functionInstanceClassPath == null ? other$functionInstanceClassPath != null : !this$functionInstanceClassPath.equals(other$functionInstanceClassPath)) {
            return false;
        }
        Map<String, Object> this$kubernetesFunctionAuthProviderConfig = this.getKubernetesFunctionAuthProviderConfig();
        Map<String, Object> other$kubernetesFunctionAuthProviderConfig = other.getKubernetesFunctionAuthProviderConfig();
        return !(this$kubernetesFunctionAuthProviderConfig == null ? other$kubernetesFunctionAuthProviderConfig != null : !((Object)this$kubernetesFunctionAuthProviderConfig).equals(other$kubernetesFunctionAuthProviderConfig));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KubernetesRuntimeFactoryConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPercentMemoryPadding();
        long $cpuOverCommitRatio = Double.doubleToLongBits(this.getCpuOverCommitRatio());
        result = result * 59 + (int)($cpuOverCommitRatio >>> 32 ^ $cpuOverCommitRatio);
        long $memoryOverCommitRatio = Double.doubleToLongBits(this.getMemoryOverCommitRatio());
        result = result * 59 + (int)($memoryOverCommitRatio >>> 32 ^ $memoryOverCommitRatio);
        result = result * 59 + this.getGracePeriodSeconds();
        Boolean $submittingInsidePod = this.getSubmittingInsidePod();
        result = result * 59 + ($submittingInsidePod == null ? 43 : ((Object)$submittingInsidePod).hashCode());
        Boolean $installUserCodeDependencies = this.getInstallUserCodeDependencies();
        result = result * 59 + ($installUserCodeDependencies == null ? 43 : ((Object)$installUserCodeDependencies).hashCode());
        Integer $expectedMetricsCollectionInterval = this.getExpectedMetricsCollectionInterval();
        result = result * 59 + ($expectedMetricsCollectionInterval == null ? 43 : ((Object)$expectedMetricsCollectionInterval).hashCode());
        Integer $grpcPort = this.getGrpcPort();
        result = result * 59 + ($grpcPort == null ? 43 : ((Object)$grpcPort).hashCode());
        Integer $metricsPort = this.getMetricsPort();
        result = result * 59 + ($metricsPort == null ? 43 : ((Object)$metricsPort).hashCode());
        String $k8Uri = this.getK8Uri();
        result = result * 59 + ($k8Uri == null ? 43 : $k8Uri.hashCode());
        String $jobNamespace = this.getJobNamespace();
        result = result * 59 + ($jobNamespace == null ? 43 : $jobNamespace.hashCode());
        String $jobName = this.getJobName();
        result = result * 59 + ($jobName == null ? 43 : $jobName.hashCode());
        String $pulsarDockerImageName = this.getPulsarDockerImageName();
        result = result * 59 + ($pulsarDockerImageName == null ? 43 : $pulsarDockerImageName.hashCode());
        Map<String, String> $functionDockerImages = this.getFunctionDockerImages();
        result = result * 59 + ($functionDockerImages == null ? 43 : ((Object)$functionDockerImages).hashCode());
        String $imagePullPolicy = this.getImagePullPolicy();
        result = result * 59 + ($imagePullPolicy == null ? 43 : $imagePullPolicy.hashCode());
        String $pulsarRootDir = this.getPulsarRootDir();
        result = result * 59 + ($pulsarRootDir == null ? 43 : $pulsarRootDir.hashCode());
        String $configAdminCLI = this.getConfigAdminCLI();
        result = result * 59 + ($configAdminCLI == null ? 43 : $configAdminCLI.hashCode());
        String $pulsarServiceUrl = this.getPulsarServiceUrl();
        result = result * 59 + ($pulsarServiceUrl == null ? 43 : $pulsarServiceUrl.hashCode());
        String $pulsarAdminUrl = this.getPulsarAdminUrl();
        result = result * 59 + ($pulsarAdminUrl == null ? 43 : $pulsarAdminUrl.hashCode());
        String $pythonDependencyRepository = this.getPythonDependencyRepository();
        result = result * 59 + ($pythonDependencyRepository == null ? 43 : $pythonDependencyRepository.hashCode());
        String $pythonExtraDependencyRepository = this.getPythonExtraDependencyRepository();
        result = result * 59 + ($pythonExtraDependencyRepository == null ? 43 : $pythonExtraDependencyRepository.hashCode());
        String $extraFunctionDependenciesDir = this.getExtraFunctionDependenciesDir();
        result = result * 59 + ($extraFunctionDependenciesDir == null ? 43 : $extraFunctionDependenciesDir.hashCode());
        Map<String, String> $customLabels = this.getCustomLabels();
        result = result * 59 + ($customLabels == null ? 43 : ((Object)$customLabels).hashCode());
        String $changeConfigMap = this.getChangeConfigMap();
        result = result * 59 + ($changeConfigMap == null ? 43 : $changeConfigMap.hashCode());
        String $changeConfigMapNamespace = this.getChangeConfigMapNamespace();
        result = result * 59 + ($changeConfigMapNamespace == null ? 43 : $changeConfigMapNamespace.hashCode());
        String $narExtractionDirectory = this.getNarExtractionDirectory();
        result = result * 59 + ($narExtractionDirectory == null ? 43 : $narExtractionDirectory.hashCode());
        String $functionInstanceClassPath = this.getFunctionInstanceClassPath();
        result = result * 59 + ($functionInstanceClassPath == null ? 43 : $functionInstanceClassPath.hashCode());
        Map<String, Object> $kubernetesFunctionAuthProviderConfig = this.getKubernetesFunctionAuthProviderConfig();
        result = result * 59 + ($kubernetesFunctionAuthProviderConfig == null ? 43 : ((Object)$kubernetesFunctionAuthProviderConfig).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "KubernetesRuntimeFactoryConfig(k8Uri=" + this.getK8Uri() + ", jobNamespace=" + this.getJobNamespace() + ", jobName=" + this.getJobName() + ", pulsarDockerImageName=" + this.getPulsarDockerImageName() + ", functionDockerImages=" + String.valueOf(this.getFunctionDockerImages()) + ", imagePullPolicy=" + this.getImagePullPolicy() + ", pulsarRootDir=" + this.getPulsarRootDir() + ", configAdminCLI=" + this.getConfigAdminCLI() + ", submittingInsidePod=" + this.getSubmittingInsidePod() + ", pulsarServiceUrl=" + this.getPulsarServiceUrl() + ", pulsarAdminUrl=" + this.getPulsarAdminUrl() + ", installUserCodeDependencies=" + this.getInstallUserCodeDependencies() + ", pythonDependencyRepository=" + this.getPythonDependencyRepository() + ", pythonExtraDependencyRepository=" + this.getPythonExtraDependencyRepository() + ", extraFunctionDependenciesDir=" + this.getExtraFunctionDependenciesDir() + ", customLabels=" + String.valueOf(this.getCustomLabels()) + ", expectedMetricsCollectionInterval=" + this.getExpectedMetricsCollectionInterval() + ", changeConfigMap=" + this.getChangeConfigMap() + ", changeConfigMapNamespace=" + this.getChangeConfigMapNamespace() + ", percentMemoryPadding=" + this.getPercentMemoryPadding() + ", cpuOverCommitRatio=" + this.getCpuOverCommitRatio() + ", memoryOverCommitRatio=" + this.getMemoryOverCommitRatio() + ", grpcPort=" + this.getGrpcPort() + ", metricsPort=" + this.getMetricsPort() + ", narExtractionDirectory=" + this.getNarExtractionDirectory() + ", functionInstanceClassPath=" + this.getFunctionInstanceClassPath() + ", gracePeriodSeconds=" + this.getGracePeriodSeconds() + ", kubernetesFunctionAuthProviderConfig=" + String.valueOf(this.getKubernetesFunctionAuthProviderConfig()) + ")";
    }
}

