/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.impl.metadata;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.bookkeeper.versioning.LongVersion;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.exceptions.UnexpectedException;
import org.apache.distributedlog.impl.metadata.ZKLogStreamMetadataStore;
import org.apache.distributedlog.metadata.LogMetadataForWriter;
import org.apache.distributedlog.util.DLUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestZKLogStreamMetadataStoreUtils {
    @Test(timeout=60000L, expected=UnexpectedException.class)
    public void testProcessLogMetadatasMissingMaxTxnId() throws Exception {
        String rootPath = "/test-missing-max-txn-id";
        URI uri = DLMTestUtil.createDLMURI(2181, rootPath);
        String logName = "test-log";
        String logIdentifier = "<default>";
        ArrayList metadatas = Lists.newArrayList((Object[])new Versioned[]{new Versioned(null, null), new Versioned(null, null), new Versioned(null, null)});
        ZKLogStreamMetadataStore.processLogMetadatas((URI)uri, (String)logName, (String)logIdentifier, (List)metadatas, (boolean)false);
    }

    @Test(timeout=60000L, expected=UnexpectedException.class)
    public void testProcessLogMetadatasMissingVersion() throws Exception {
        String rootPath = "/test-missing-version";
        URI uri = DLMTestUtil.createDLMURI(2181, rootPath);
        String logName = "test-log";
        String logIdentifier = "<default>";
        ArrayList metadatas = Lists.newArrayList((Object[])new Versioned[]{new Versioned(null, null), new Versioned(null, null), new Versioned((Object)DLUtils.serializeTransactionId((long)1L), (Version)new LongVersion(1L)), new Versioned(null, null)});
        ZKLogStreamMetadataStore.processLogMetadatas((URI)uri, (String)logName, (String)logIdentifier, (List)metadatas, (boolean)false);
    }

    @Test(timeout=60000L, expected=UnexpectedException.class)
    public void testProcessLogMetadatasWrongVersion() throws Exception {
        String rootPath = "/test-missing-version";
        URI uri = DLMTestUtil.createDLMURI(2181, rootPath);
        String logName = "test-log";
        String logIdentifier = "<default>";
        ArrayList metadatas = Lists.newArrayList((Object[])new Versioned[]{new Versioned(null, null), new Versioned(null, null), new Versioned((Object)DLUtils.serializeTransactionId((long)1L), (Version)new LongVersion(1L)), new Versioned((Object)ZKLogStreamMetadataStore.intToBytes((int)9999), null)});
        ZKLogStreamMetadataStore.processLogMetadatas((URI)uri, (String)logName, (String)logIdentifier, (List)metadatas, (boolean)false);
    }

    @Test(timeout=60000L, expected=UnexpectedException.class)
    public void testProcessLogMetadatasMissingLockPath() throws Exception {
        String rootPath = "/test-missing-version";
        URI uri = DLMTestUtil.createDLMURI(2181, rootPath);
        String logName = "test-log";
        String logIdentifier = "<default>";
        ArrayList metadatas = Lists.newArrayList((Object[])new Versioned[]{new Versioned(null, null), new Versioned(null, null), new Versioned((Object)DLUtils.serializeTransactionId((long)1L), (Version)new LongVersion(1L)), new Versioned((Object)ZKLogStreamMetadataStore.intToBytes((int)-1), null), new Versioned(null, null)});
        ZKLogStreamMetadataStore.processLogMetadatas((URI)uri, (String)logName, (String)logIdentifier, (List)metadatas, (boolean)false);
    }

    @Test(timeout=60000L, expected=UnexpectedException.class)
    public void testProcessLogMetadatasMissingReadLockPath() throws Exception {
        String rootPath = "/test-missing-version";
        URI uri = DLMTestUtil.createDLMURI(2181, rootPath);
        String logName = "test-log";
        String logIdentifier = "<default>";
        ArrayList metadatas = Lists.newArrayList((Object[])new Versioned[]{new Versioned(null, null), new Versioned(null, null), new Versioned((Object)DLUtils.serializeTransactionId((long)1L), (Version)new LongVersion(1L)), new Versioned((Object)ZKLogStreamMetadataStore.intToBytes((int)-1), null), new Versioned((Object)new byte[0], (Version)new LongVersion(1L)), new Versioned(null, null)});
        ZKLogStreamMetadataStore.processLogMetadatas((URI)uri, (String)logName, (String)logIdentifier, (List)metadatas, (boolean)false);
    }

    @Test(timeout=60000L, expected=UnexpectedException.class)
    public void testProcessLogMetadatasMissingLogSegmentsPath() throws Exception {
        String rootPath = "/test-missing-version";
        URI uri = DLMTestUtil.createDLMURI(2181, rootPath);
        String logName = "test-log";
        String logIdentifier = "<default>";
        ArrayList metadatas = Lists.newArrayList((Object[])new Versioned[]{new Versioned(null, null), new Versioned(null, null), new Versioned((Object)DLUtils.serializeTransactionId((long)1L), (Version)new LongVersion(1L)), new Versioned((Object)ZKLogStreamMetadataStore.intToBytes((int)-1), null), new Versioned((Object)new byte[0], (Version)new LongVersion(1L)), new Versioned((Object)new byte[0], (Version)new LongVersion(1L)), new Versioned(null, null)});
        ZKLogStreamMetadataStore.processLogMetadatas((URI)uri, (String)logName, (String)logIdentifier, (List)metadatas, (boolean)false);
    }

    @Test(timeout=60000L, expected=UnexpectedException.class)
    public void testProcessLogMetadatasMissingAllocatorPath() throws Exception {
        String rootPath = "/test-missing-version";
        URI uri = DLMTestUtil.createDLMURI(2181, rootPath);
        String logName = "test-log";
        String logIdentifier = "<default>";
        ArrayList metadatas = Lists.newArrayList((Object[])new Versioned[]{new Versioned(null, null), new Versioned(null, null), new Versioned((Object)DLUtils.serializeTransactionId((long)1L), (Version)new LongVersion(1L)), new Versioned((Object)ZKLogStreamMetadataStore.intToBytes((int)-1), null), new Versioned((Object)new byte[0], (Version)new LongVersion(1L)), new Versioned((Object)new byte[0], (Version)new LongVersion(1L)), new Versioned((Object)DLUtils.serializeLogSegmentSequenceNumber((long)1L), (Version)new LongVersion(1L)), new Versioned(null, null)});
        ZKLogStreamMetadataStore.processLogMetadatas((URI)uri, (String)logName, (String)logIdentifier, (List)metadatas, (boolean)true);
    }

    @Test(timeout=60000L)
    public void testProcessLogMetadatasNoAllocatorPath() throws Exception {
        String rootPath = "/test-missing-version";
        URI uri = DLMTestUtil.createDLMURI(2181, rootPath);
        String logName = "test-log";
        String logIdentifier = "<default>";
        Versioned maxTxnIdData = new Versioned((Object)DLUtils.serializeTransactionId((long)1L), (Version)new LongVersion(1L));
        Versioned logSegmentsData = new Versioned((Object)DLUtils.serializeLogSegmentSequenceNumber((long)1L), (Version)new LongVersion(1L));
        ArrayList metadatas = Lists.newArrayList((Object[])new Versioned[]{new Versioned(null, null), new Versioned(null, null), maxTxnIdData, new Versioned((Object)ZKLogStreamMetadataStore.intToBytes((int)-1), null), new Versioned((Object)new byte[0], (Version)new LongVersion(1L)), new Versioned((Object)new byte[0], (Version)new LongVersion(1L)), logSegmentsData});
        LogMetadataForWriter metadata = ZKLogStreamMetadataStore.processLogMetadatas((URI)uri, (String)logName, (String)logIdentifier, (List)metadatas, (boolean)false);
        Assert.assertTrue((maxTxnIdData == metadata.getMaxTxIdData() ? 1 : 0) != 0);
        Assert.assertTrue((logSegmentsData == metadata.getMaxLSSNData() ? 1 : 0) != 0);
        Assert.assertNull((Object)metadata.getAllocationData().getValue());
        Assert.assertNull((Object)metadata.getAllocationData().getVersion());
    }

    @Test(timeout=60000L)
    public void testProcessLogMetadatasAllocatorPath() throws Exception {
        String rootPath = "/test-missing-version";
        URI uri = DLMTestUtil.createDLMURI(2181, rootPath);
        String logName = "test-log";
        String logIdentifier = "<default>";
        Versioned maxTxnIdData = new Versioned((Object)DLUtils.serializeTransactionId((long)1L), (Version)new LongVersion(1L));
        Versioned logSegmentsData = new Versioned((Object)DLUtils.serializeLogSegmentSequenceNumber((long)1L), (Version)new LongVersion(1L));
        Versioned allocationData = new Versioned((Object)DLUtils.logSegmentId2Bytes((long)1L), (Version)new LongVersion(1L));
        ArrayList metadatas = Lists.newArrayList((Object[])new Versioned[]{new Versioned(null, null), new Versioned(null, null), maxTxnIdData, new Versioned((Object)ZKLogStreamMetadataStore.intToBytes((int)-1), null), new Versioned((Object)new byte[0], (Version)new LongVersion(1L)), new Versioned((Object)new byte[0], (Version)new LongVersion(1L)), logSegmentsData, allocationData});
        LogMetadataForWriter metadata = ZKLogStreamMetadataStore.processLogMetadatas((URI)uri, (String)logName, (String)logIdentifier, (List)metadatas, (boolean)true);
        Assert.assertTrue((maxTxnIdData == metadata.getMaxTxIdData() ? 1 : 0) != 0);
        Assert.assertTrue((logSegmentsData == metadata.getMaxLSSNData() ? 1 : 0) != 0);
        Assert.assertTrue((allocationData == metadata.getAllocationData() ? 1 : 0) != 0);
    }
}

