/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import io.trino.sql.tree.Cast;
import io.trino.sql.tree.DefaultExpressionTraversalVisitor;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.IfExpression;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NullIfExpression;
import io.trino.sql.tree.SearchedCaseExpression;
import io.trino.sql.tree.SimpleCaseExpression;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.TryExpression;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public final class NullabilityAnalyzer {
    private NullabilityAnalyzer() {
    }

    public static boolean mayReturnNullOnNonNullInput(Expression expression) {
        Objects.requireNonNull(expression, "expression is null");
        AtomicBoolean result = new AtomicBoolean(false);
        new Visitor().process((Node)expression, result);
        return result.get();
    }

    private static class Visitor
    extends DefaultExpressionTraversalVisitor<AtomicBoolean> {
        private Visitor() {
        }

        protected Void visitCast(Cast node, AtomicBoolean result) {
            result.set(node.isSafe() || !node.isTypeOnly());
            return null;
        }

        protected Void visitNullIfExpression(NullIfExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitDereferenceExpression(DereferenceExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitInPredicate(InPredicate node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitSearchedCaseExpression(SearchedCaseExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitSimpleCaseExpression(SimpleCaseExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitSubscriptExpression(SubscriptExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitTryExpression(TryExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitIfExpression(IfExpression node, AtomicBoolean result) {
            result.set(true);
            return null;
        }

        protected Void visitFunctionCall(FunctionCall node, AtomicBoolean result) {
            result.set(true);
            return null;
        }
    }
}

