/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import com.google.common.collect.ImmutableList;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.operator.window.FrameInfo;
import io.trino.operator.window.Partitioner;
import io.trino.operator.window.PartitionerSupplier;
import io.trino.operator.window.PatternRecognitionPartitioner;
import io.trino.operator.window.matcher.Matcher;
import io.trino.operator.window.pattern.ArgumentComputation;
import io.trino.operator.window.pattern.LabelEvaluator;
import io.trino.operator.window.pattern.LogicalIndexNavigation;
import io.trino.operator.window.pattern.MatchAggregation;
import io.trino.operator.window.pattern.MeasureComputation;
import io.trino.sql.tree.PatternRecognitionRelation;
import io.trino.sql.tree.SkipTo;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class PatternRecognitionPartitionerSupplier
implements PartitionerSupplier {
    private final List<MeasureComputation.MeasureComputationSupplier> measures;
    private final List<MatchAggregation.MatchAggregationInstantiator> measureAggregations;
    private final List<ArgumentComputation.ArgumentComputationSupplier> measureComputationsAggregationArguments;
    private final Optional<FrameInfo> commonBaseFrame;
    private final PatternRecognitionRelation.RowsPerMatch rowsPerMatch;
    private final Optional<LogicalIndexNavigation> skipToNavigation;
    private final SkipTo.Position skipToPosition;
    private final boolean initial;
    private final Matcher matcher;
    private final List<LabelEvaluator.EvaluationSupplier> labelEvaluations;
    private final List<ArgumentComputation.ArgumentComputationSupplier> labelEvaluationsAggregationArguments;
    private final List<String> labelNames;

    public PatternRecognitionPartitionerSupplier(List<MeasureComputation.MeasureComputationSupplier> measures, List<MatchAggregation.MatchAggregationInstantiator> measureAggregations, List<ArgumentComputation.ArgumentComputationSupplier> measureComputationsAggregationArguments, Optional<FrameInfo> commonBaseFrame, PatternRecognitionRelation.RowsPerMatch rowsPerMatch, Optional<LogicalIndexNavigation> skipToNavigation, SkipTo.Position skipToPosition, boolean initial, Matcher matcher, List<LabelEvaluator.EvaluationSupplier> labelEvaluations, List<ArgumentComputation.ArgumentComputationSupplier> labelEvaluationsAggregationArguments, List<String> labelNames) {
        Objects.requireNonNull(measures, "measures is null");
        Objects.requireNonNull(measureAggregations, "measureAggregations is null");
        Objects.requireNonNull(measureComputationsAggregationArguments, "measureComputationsAggregationArguments is null");
        Objects.requireNonNull(commonBaseFrame, "commonBaseFrame is null");
        Objects.requireNonNull(rowsPerMatch, "rowsPerMatch is null");
        Objects.requireNonNull(skipToNavigation, "skipToNavigation is null");
        Objects.requireNonNull(skipToPosition, "skipToPosition is null");
        Objects.requireNonNull(matcher, "matcher is null");
        Objects.requireNonNull(labelEvaluations, "labelEvaluations is null");
        Objects.requireNonNull(labelEvaluationsAggregationArguments, "labelEvaluationsAggregationArguments is null");
        Objects.requireNonNull(labelNames, "labelNames is null");
        this.measures = measures;
        this.measureAggregations = measureAggregations;
        this.measureComputationsAggregationArguments = measureComputationsAggregationArguments;
        this.commonBaseFrame = commonBaseFrame;
        this.rowsPerMatch = rowsPerMatch;
        this.skipToNavigation = skipToNavigation;
        this.skipToPosition = skipToPosition;
        this.initial = initial;
        this.matcher = matcher;
        this.labelEvaluations = labelEvaluations;
        this.labelEvaluationsAggregationArguments = labelEvaluationsAggregationArguments;
        this.labelNames = labelNames;
    }

    @Override
    public Partitioner get(AggregatedMemoryContext memoryContext) {
        List aggregationsInMeasures = (List)this.measureAggregations.stream().map(aggregationSupplier -> aggregationSupplier.get(memoryContext)).collect(ImmutableList.toImmutableList());
        return new PatternRecognitionPartitioner((List)this.measures.stream().map(supplier -> supplier.get(aggregationsInMeasures)).collect(ImmutableList.toImmutableList()), aggregationsInMeasures, (List)this.measureComputationsAggregationArguments.stream().map(ArgumentComputation.ArgumentComputationSupplier::get).collect(ImmutableList.toImmutableList()), this.commonBaseFrame, this.rowsPerMatch, this.skipToNavigation, this.skipToPosition, this.initial, this.matcher, (List)this.labelEvaluations.stream().map(LabelEvaluator.EvaluationSupplier::get).collect(ImmutableList.toImmutableList()), (List)this.labelEvaluationsAggregationArguments.stream().map(ArgumentComputation.ArgumentComputationSupplier::get).collect(ImmutableList.toImmutableList()), this.labelNames);
    }
}

