/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.project;

import com.google.common.base.Preconditions;
import java.util.Objects;

public class SelectedPositions {
    private final boolean isList;
    private final int[] positions;
    private final int offset;
    private final int size;

    public static SelectedPositions positionsList(int[] positions, int offset, int size) {
        return new SelectedPositions(true, positions, offset, size);
    }

    public static SelectedPositions positionsRange(int offset, int size) {
        return new SelectedPositions(false, new int[0], offset, size);
    }

    private SelectedPositions(boolean isList, int[] positions, int offset, int size) {
        this.isList = isList;
        this.positions = Objects.requireNonNull(positions, "positions is null");
        this.offset = offset;
        this.size = size;
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"offset is negative");
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0, (Object)"size is negative");
        if (isList) {
            Preconditions.checkPositionIndexes((int)offset, (int)(offset + size), (int)positions.length);
        }
    }

    public boolean isList() {
        return this.isList;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int[] getPositions() {
        Preconditions.checkState((boolean)this.isList, (Object)"SelectedPositions is a range");
        return this.positions;
    }

    public int getOffset() {
        return this.offset;
    }

    public int size() {
        return this.size;
    }

    public SelectedPositions subRange(int start, int end) {
        Preconditions.checkPositionIndexes((int)start, (int)end, (int)this.size);
        int newOffset = this.offset + start;
        int newLength = end - start;
        return new SelectedPositions(this.isList, this.positions, newOffset, newLength);
    }
}

