/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.trino.operator.aggregation.state.GenericBooleanState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.Type;
import java.util.Objects;

public class GenericBooleanStateSerializer
implements AccumulatorStateSerializer<GenericBooleanState> {
    private final Type serializedType;

    public GenericBooleanStateSerializer(Type serializedType) {
        this.serializedType = Objects.requireNonNull(serializedType, "serializedType is null");
    }

    public Type getSerializedType() {
        return this.serializedType;
    }

    public void serialize(GenericBooleanState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            this.serializedType.writeBoolean(out, state.getValue());
        }
    }

    public void deserialize(Block block, int index, GenericBooleanState state) {
        state.setNull(false);
        state.setValue(this.serializedType.getBoolean(block, index));
    }
}

