/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.minmaxby;

import io.trino.operator.aggregation.TypedKeyValueHeap;
import io.trino.operator.aggregation.minmaxby.MinMaxByNState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;

public class MinMaxByNStateSerializer
implements AccumulatorStateSerializer<MinMaxByNState> {
    private final MethodHandle keyComparisonMethod;
    private final Type keyType;
    private final Type valueType;
    private final Type serializedType;

    public MinMaxByNStateSerializer(MethodHandle keyComparisonMethod, Type keyType, Type valueType) {
        this.keyComparisonMethod = keyComparisonMethod;
        this.keyType = keyType;
        this.valueType = valueType;
        this.serializedType = TypedKeyValueHeap.getSerializedType(keyType, valueType);
    }

    public Type getSerializedType() {
        return this.serializedType;
    }

    public void serialize(MinMaxByNState state, BlockBuilder out) {
        TypedKeyValueHeap heap = state.getTypedKeyValueHeap();
        if (heap == null) {
            out.appendNull();
            return;
        }
        heap.serialize(out);
    }

    public void deserialize(Block block, int index, MinMaxByNState state) {
        Block currentBlock = (Block)this.serializedType.getObject(block, index);
        state.setTypedKeyValueHeap(TypedKeyValueHeap.deserialize(currentBlock, this.keyType, this.valueType, this.keyComparisonMethod));
    }
}

