/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import io.netty.util.Recycler;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.service.AbstractReplicator;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Replicator;
import org.apache.pulsar.broker.service.persistent.DispatchRateLimiter;
import org.apache.pulsar.broker.service.persistent.PersistentMessageExpiryMonitor;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.schema.SchemaInfoProvider;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.ProducerImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.SendCallback;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.stats.ReplicatorStatsImpl;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.stats.Rate;
import org.apache.pulsar.common.util.Backoff;
import org.apache.pulsar.common.util.Codec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PersistentReplicator
extends AbstractReplicator
implements Replicator,
AsyncCallbacks.ReadEntriesCallback,
AsyncCallbacks.DeleteCallback {
    protected final PersistentTopic topic;
    protected final ManagedCursor cursor;
    protected final String localSchemaTopicName;
    protected Optional<DispatchRateLimiter> dispatchRateLimiter = Optional.empty();
    private final Object dispatchRateLimiterLock = new Object();
    private int readBatchSize;
    private final int readMaxSizeBytes;
    private final int producerQueueThreshold;
    protected final Rate msgOut = new Rate();
    protected final Rate msgExpired = new Rate();
    protected int messageTTLInSeconds = 0;
    private final Backoff readFailureBackoff = new Backoff(1L, TimeUnit.SECONDS, 1L, TimeUnit.MINUTES, 0L, TimeUnit.MILLISECONDS);
    private final PersistentMessageExpiryMonitor expiryMonitor;
    private static final int MINIMUM_BACKLOG_FOR_EXPIRY_CHECK = 1000;
    private final ReplicatorStatsImpl stats = new ReplicatorStatsImpl();
    protected volatile int waitForCursorRewindingRefCnf = 0;
    protected ReasonOfWaitForCursorRewinding reasonOfWaitForCursorRewinding = null;
    protected final LinkedList<InFlightTask> inFlightTasks = new LinkedList();
    private static final Logger log = LoggerFactory.getLogger(PersistentReplicator.class);

    public PersistentReplicator(String localCluster, PersistentTopic localTopic, ManagedCursor cursor, String remoteCluster, String remoteTopic, BrokerService brokerService, PulsarClientImpl replicationClient) throws PulsarServerException {
        super(localCluster, localTopic, remoteCluster, remoteTopic, localTopic.getReplicatorPrefix(), brokerService, replicationClient);
        this.topic = localTopic;
        this.localSchemaTopicName = TopicName.getPartitionedTopicName((String)this.localTopicName).toString();
        this.cursor = Objects.requireNonNull(cursor);
        this.expiryMonitor = new PersistentMessageExpiryMonitor(this.localTopicName, Codec.decode((String)cursor.getName()), cursor, null);
        this.readBatchSize = Math.min(this.producerQueueSize, localTopic.getBrokerService().pulsar().getConfiguration().getDispatcherMaxReadBatchSize());
        this.readMaxSizeBytes = localTopic.getBrokerService().pulsar().getConfiguration().getDispatcherMaxReadSizeBytes();
        this.producerQueueThreshold = (int)((double)this.producerQueueSize * 0.9);
        this.initializeDispatchRateLimiterIfNeeded();
        this.startProducer();
    }

    @Override
    protected void setProducerAndTriggerReadEntries(Producer<byte[]> producer) {
        if (STATE_UPDATER.get(this) == AbstractReplicator.State.Starting && this.hasPendingRead() && !this.cursor.cancelPendingReadRequest()) {
            this.brokerService.getPulsar().getExecutor().schedule(() -> this.setProducerAndTriggerReadEntries(producer), 10L, TimeUnit.MILLISECONDS);
            return;
        }
        ImmutablePair<Boolean, AbstractReplicator.State> changeStateRes = this.compareSetAndGetState(AbstractReplicator.State.Starting, AbstractReplicator.State.Started);
        if (((Boolean)changeStateRes.getLeft()).booleanValue()) {
            if (!(producer instanceof ProducerImpl)) {
                log.error("[{}] The partitions count between two clusters is not the same, the replicator can not be created successfully: {}", (Object)this.replicatorId, (Object)this.state);
                this.doCloseProducerAsync(producer, () -> {});
                throw new ClassCastException(producer.getClass().getName() + " can not be cast to ProducerImpl");
            }
            this.producer = (ProducerImpl)producer;
            log.info("[{}] Created replicator producer, Replicator state: {}", (Object)this.replicatorId, (Object)this.state);
            this.backOff.reset();
            this.cursor.setActive();
            this.cursor.rewind();
            this.readMoreEntries();
        } else {
            if (changeStateRes.getRight() == AbstractReplicator.State.Started) {
                log.warn("[{}] Replicator was already started by another thread while creating the producer. Closing the producer newly created. Replicator state: {}", (Object)this.replicatorId, (Object)this.state);
            } else if (changeStateRes.getRight() == AbstractReplicator.State.Terminating || changeStateRes.getRight() == AbstractReplicator.State.Terminated) {
                log.info("[{}] Replicator was terminated, so close the producer. Replicator state: {}", (Object)this.replicatorId, (Object)this.state);
            } else {
                log.error("[{}] Replicator state is not expected, so close the producer. Replicator state: {}", (Object)this.replicatorId, changeStateRes.getRight());
            }
            this.doCloseProducerAsync(producer, () -> {});
        }
    }

    @Override
    protected Position getReplicatorReadPosition() {
        return this.cursor.getMarkDeletedPosition();
    }

    @Override
    public long getNumberOfEntriesInBacklog() {
        return this.cursor.getNumberOfEntriesInBacklog(true);
    }

    @Override
    protected void disableReplicatorRead() {
        if (this.cursor != null) {
            this.cursor.setInactive();
        }
    }

    private AvailablePermits getRateLimiterAvailablePermits(int availablePermits) {
        if (availablePermits <= 0) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Producer queue is full, availablePermits: {}, pause reading", (Object)this.replicatorId, (Object)availablePermits);
            }
            return new AvailablePermits(0, 0L);
        }
        long availablePermitsOnMsg = -1L;
        long availablePermitsOnByte = -1L;
        if (this.dispatchRateLimiter.isPresent() && this.dispatchRateLimiter.get().isDispatchRateLimitingEnabled()) {
            DispatchRateLimiter rateLimiter = this.dispatchRateLimiter.get();
            availablePermitsOnMsg = rateLimiter.getAvailableDispatchRateLimitOnMsg();
            availablePermitsOnByte = rateLimiter.getAvailableDispatchRateLimitOnByte();
            if (availablePermitsOnByte == 0L || availablePermitsOnMsg == 0L) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] message-read exceeded topic replicator message-rate {}/{}, schedule after a {}", new Object[]{this.replicatorId, rateLimiter.getDispatchRateOnMsg(), rateLimiter.getDispatchRateOnByte(), 1000});
                }
                return new AvailablePermits(-1, -1L);
            }
        }
        availablePermitsOnMsg = availablePermitsOnMsg == -1L ? (long)availablePermits : Math.min((long)availablePermits, availablePermitsOnMsg);
        availablePermitsOnMsg = Math.min(availablePermitsOnMsg, (long)this.readBatchSize);
        availablePermitsOnByte = availablePermitsOnByte == -1L ? (long)this.readMaxSizeBytes : Math.min((long)this.readMaxSizeBytes, availablePermitsOnByte);
        return new AvailablePermits((int)availablePermitsOnMsg, availablePermitsOnByte);
    }

    protected void readMoreEntries() {
        if (this.state.equals((Object)AbstractReplicator.State.Terminated) || this.state.equals((Object)AbstractReplicator.State.Terminating)) {
            return;
        }
        InFlightTask newInFlightTask = this.acquirePermitsIfNotFetchingSchema();
        if (newInFlightTask == null) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Not scheduling read due to pending read or no permits.", (Object)this.replicatorId);
            }
            if (!this.hasPendingRead()) {
                this.topic.getBrokerService().executor().schedule(() -> this.readMoreEntries(), 1000L, TimeUnit.MILLISECONDS);
                return;
            }
            return;
        }
        if (!this.dispatchRateLimiter.isPresent() || !this.dispatchRateLimiter.get().isDispatchRateLimitingEnabled()) {
            this.cursor.asyncReadEntriesOrWait(newInFlightTask.readingEntries, -1L, (AsyncCallbacks.ReadEntriesCallback)this, (Object)newInFlightTask, this.topic.getMaxReadPosition());
            return;
        }
        AvailablePermits availablePermits = this.getRateLimiterAvailablePermits(newInFlightTask.readingEntries);
        if (!availablePermits.isReadable()) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Throttling replication traffic. Messages To Read {}, Bytes To Read {}", new Object[]{this.replicatorId, availablePermits.getMessages(), availablePermits.getBytes()});
            }
            this.topic.getBrokerService().executor().schedule(() -> this.readMoreEntries(), 1000L, TimeUnit.MILLISECONDS);
            return;
        }
        int messagesToRead = availablePermits.getMessages();
        long bytesToRead = availablePermits.getBytes();
        if (!this.isWritable()) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Throttling replication traffic because producer is not writable", (Object)this.replicatorId);
            }
            messagesToRead = 1;
        }
        if (messagesToRead < newInFlightTask.readingEntries) {
            newInFlightTask.setReadingEntries(messagesToRead);
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] Schedule read of {} messages or {} bytes", new Object[]{this.replicatorId, newInFlightTask.readingEntries, bytesToRead});
        }
        this.cursor.asyncReadEntriesOrWait(newInFlightTask.readingEntries, bytesToRead, (AsyncCallbacks.ReadEntriesCallback)this, (Object)newInFlightTask, this.topic.getMaxReadPosition());
    }

    public void readEntriesComplete(List<Entry> entries, Object ctx) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] Read entries complete of {} messages", (Object)this.replicatorId, (Object)entries.size());
        }
        InFlightTask inFlightTask = (InFlightTask)ctx;
        inFlightTask.setEntries(entries);
        int maxReadBatchSize = this.topic.getBrokerService().pulsar().getConfiguration().getDispatcherMaxReadBatchSize();
        if (this.readBatchSize < maxReadBatchSize) {
            int newReadBatchSize = Math.min(this.readBatchSize * 2, maxReadBatchSize);
            if (log.isDebugEnabled()) {
                log.debug("[{}] Increasing read batch size from {} to {}", new Object[]{this.replicatorId, this.readBatchSize, newReadBatchSize});
            }
            this.readBatchSize = newReadBatchSize;
        }
        this.readFailureBackoff.reduceToHalf();
        boolean atLeastOneMessageSentForReplication = this.replicateEntries(entries, inFlightTask);
        if (atLeastOneMessageSentForReplication && !this.isWritable()) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Pausing replication traffic. at-least-one: {} is-writable: {}", new Object[]{this.replicatorId, atLeastOneMessageSentForReplication, this.isWritable()});
            }
        } else {
            this.readMoreEntries();
        }
    }

    protected abstract boolean replicateEntries(List<Entry> var1, InFlightTask var2);

    protected CompletableFuture<SchemaInfo> getSchemaInfo(MessageImpl msg) throws ExecutionException {
        if (msg.getSchemaVersion() == null || msg.getSchemaVersion().length == 0) {
            return CompletableFuture.completedFuture(null);
        }
        return ((SchemaInfoProvider)this.client.getSchemaProviderLoadingCache().get((Object)this.localSchemaTopicName)).getSchemaByVersion(msg.getSchemaVersion());
    }

    public void updateCursorState() {
        if (this.cursor != null) {
            if (this.producer != null && this.producer.isConnected()) {
                this.cursor.setActive();
            } else {
                this.cursor.setInactive();
            }
        }
    }

    public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
        if (this.state != AbstractReplicator.State.Started) {
            log.info("[{}] Replicator was disconnected while reading entries. Stop reading. Replicator state: {}", (Object)this.replicatorId, STATE_UPDATER.get(this));
            return;
        }
        this.readBatchSize = this.topic.getBrokerService().pulsar().getConfiguration().getDispatcherMinReadBatchSize();
        long waitTimeMillis = this.readFailureBackoff.next();
        if (exception instanceof ManagedLedgerException.CursorAlreadyClosedException) {
            log.warn("[{}] Error reading entries because replicator is already deleted and cursor is already closed {}, ({})", new Object[]{this.replicatorId, ctx, exception.getMessage(), exception});
            this.terminate();
            return;
        }
        if (!(exception instanceof ManagedLedgerException.TooManyRequestsException)) {
            log.error("[{}] Error reading entries at {}. Retrying to read in {}s. ({})", new Object[]{this.replicatorId, ctx, (double)waitTimeMillis / 1000.0, exception.getMessage(), exception});
        } else if (log.isDebugEnabled()) {
            log.debug("[{}] Throttled by bookies while reading at {}. Retrying to read in {}s. ({})", new Object[]{this.replicatorId, ctx, (double)waitTimeMillis / 1000.0, exception.getMessage(), exception});
        }
        this.brokerService.executor().schedule(this::readMoreEntries, waitTimeMillis, TimeUnit.MILLISECONDS);
    }

    public CompletableFuture<Void> clearBacklog() {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (log.isDebugEnabled()) {
            log.debug("[{}] Backlog size before clearing: {}", (Object)this.replicatorId, (Object)this.cursor.getNumberOfEntriesInBacklog(false));
        }
        this.cursor.asyncClearBacklog(new AsyncCallbacks.ClearBacklogCallback(){

            public void clearBacklogComplete(Object ctx) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Backlog size after clearing: {}", (Object)PersistentReplicator.this.replicatorId, (Object)PersistentReplicator.this.cursor.getNumberOfEntriesInBacklog(false));
                }
                future.complete(null);
            }

            public void clearBacklogFailed(ManagedLedgerException exception, Object ctx) {
                log.error("[{}] Failed to clear backlog", (Object)PersistentReplicator.this.replicatorId, (Object)exception);
                future.completeExceptionally(exception);
            }
        }, null);
        return future;
    }

    public CompletableFuture<Void> skipMessages(final int numMessagesToSkip) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (log.isDebugEnabled()) {
            log.debug("[{}] Skipping {} messages, current backlog {}", new Object[]{this.replicatorId, numMessagesToSkip, this.cursor.getNumberOfEntriesInBacklog(false)});
        }
        this.cursor.asyncSkipEntries(numMessagesToSkip, ManagedCursor.IndividualDeletedEntries.Exclude, new AsyncCallbacks.SkipEntriesCallback(){

            public void skipEntriesComplete(Object ctx) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Skipped {} messages, new backlog {}", new Object[]{PersistentReplicator.this.replicatorId, numMessagesToSkip, PersistentReplicator.this.cursor.getNumberOfEntriesInBacklog(false)});
                }
                future.complete(null);
            }

            public void skipEntriesFailed(ManagedLedgerException exception, Object ctx) {
                log.error("[{}] Failed to skip {} messages", new Object[]{PersistentReplicator.this.replicatorId, numMessagesToSkip, exception});
                future.completeExceptionally(exception);
            }
        }, null);
        return future;
    }

    public CompletableFuture<Entry> peekNthMessage(int messagePosition) {
        final CompletableFuture<Entry> future = new CompletableFuture<Entry>();
        if (log.isDebugEnabled()) {
            log.debug("[{}] Getting message at position {}", (Object)this.replicatorId, (Object)messagePosition);
        }
        this.cursor.asyncGetNthEntry(messagePosition, ManagedCursor.IndividualDeletedEntries.Exclude, new AsyncCallbacks.ReadEntryCallback(){

            public void readEntryFailed(ManagedLedgerException exception, Object ctx) {
                future.completeExceptionally(exception);
            }

            public void readEntryComplete(Entry entry, Object ctx) {
                future.complete(entry);
            }

            public String toString() {
                return String.format("Replication [%s] peek Nth message", PersistentReplicator.this.producer.getProducerName());
            }
        }, null);
        return future;
    }

    public void deleteComplete(Object ctx) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] Deleted message at {}", (Object)this.replicatorId, ctx);
        }
    }

    public void deleteFailed(ManagedLedgerException exception, Object ctx) {
        PositionImpl deletedEntry;
        log.error("[{}] Failed to delete message at {}: {}", new Object[]{this.replicatorId, ctx, exception.getMessage(), exception});
        if (exception instanceof ManagedLedgerException.CursorAlreadyClosedException) {
            log.warn("[{}] Asynchronous ack failure because replicator is already deleted and cursor is already closed {}, ({})", new Object[]{this.replicatorId, ctx, exception.getMessage(), exception});
            this.terminate();
            return;
        }
        if (ctx instanceof PositionImpl && (deletedEntry = (PositionImpl)ctx).compareTo((PositionImpl)this.cursor.getMarkDeletedPosition()) > 0) {
            this.brokerService.getPulsar().getExecutor().schedule(() -> this.cursor.asyncDelete((Position)deletedEntry, (AsyncCallbacks.DeleteCallback)this, (Object)deletedEntry), 10L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void updateRates() {
        this.msgOut.calculateRate();
        this.msgExpired.calculateRate();
        this.expiryMonitor.updateRates();
        this.stats.msgRateOut = this.msgOut.getRate();
        this.stats.msgThroughputOut = this.msgOut.getValueRate();
        this.stats.msgRateExpired = this.msgExpired.getRate() + this.expiryMonitor.getMessageExpiryRate();
    }

    @Override
    public ReplicatorStatsImpl getStats() {
        this.stats.replicationBacklog = this.cursor != null ? this.cursor.getNumberOfEntriesInBacklog(false) : 0L;
        this.stats.connected = this.producer != null && this.producer.isConnected();
        this.stats.replicationDelayInSeconds = this.getReplicationDelayInSeconds();
        ProducerImpl producer = this.producer;
        if (producer != null) {
            this.stats.outboundConnection = producer.getConnectionId();
            this.stats.outboundConnectedSince = producer.getConnectedSince();
        } else {
            this.stats.outboundConnection = null;
            this.stats.outboundConnectedSince = null;
        }
        return this.stats;
    }

    public void updateMessageTTL(int messageTTLInSeconds) {
        this.messageTTLInSeconds = messageTTLInSeconds;
    }

    private long getReplicationDelayInSeconds() {
        if (this.producer != null) {
            return TimeUnit.MILLISECONDS.toSeconds(this.producer.getDelayInMillis());
        }
        return 0L;
    }

    public boolean expireMessages(int messageTTLInSeconds) {
        long backlog = this.cursor.getNumberOfEntriesInBacklog(false);
        if (backlog == 0L || backlog < 1000L && !this.topic.isOldestMessageExpired(this.cursor, messageTTLInSeconds)) {
            return false;
        }
        return this.expiryMonitor.expireMessages(messageTTLInSeconds);
    }

    public boolean expireMessages(Position position) {
        return this.expiryMonitor.expireMessages(position);
    }

    @Override
    public Optional<DispatchRateLimiter> getRateLimiter() {
        return this.dispatchRateLimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeDispatchRateLimiterIfNeeded() {
        Object object = this.dispatchRateLimiterLock;
        synchronized (object) {
            if (!this.dispatchRateLimiter.isPresent() && DispatchRateLimiter.isDispatchRateEnabled((DispatchRate)this.topic.getReplicatorDispatchRate())) {
                this.dispatchRateLimiter = Optional.of(new DispatchRateLimiter(this.topic, DispatchRateLimiter.Type.REPLICATOR));
            }
        }
    }

    @Override
    public void updateRateLimiter() {
        this.initializeDispatchRateLimiterIfNeeded();
        this.dispatchRateLimiter.ifPresent(DispatchRateLimiter::updateDispatchRate);
    }

    protected void checkReplicatedSubscriptionMarker(Position position, MessageImpl<?> msg, ByteBuf payload) {
        if (!msg.getMessageBuilder().hasMarkerType()) {
            return;
        }
        int markerType = msg.getMessageBuilder().getMarkerType();
        if (!msg.getMessageBuilder().hasReplicatedFrom() || !this.remoteCluster.equals(msg.getMessageBuilder().getReplicatedFrom())) {
            return;
        }
        switch (markerType) {
            case 10: 
            case 11: 
            case 13: {
                this.topic.receivedReplicatedSubscriptionMarker(position, markerType, payload);
                break;
            }
        }
    }

    @Override
    public boolean isConnected() {
        ProducerImpl producer = this.producer;
        return producer != null && producer.isConnected();
    }

    @Override
    protected void doReleaseResources() {
        this.dispatchRateLimiter.ifPresent(DispatchRateLimiter::close);
    }

    @VisibleForTesting
    public ManagedCursor getCursor() {
        return this.cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    InFlightTask createOrRecycleInFlightTaskIntoQueue(PositionImpl readPos, int readingEntries) {
        LinkedList<InFlightTask> linkedList = this.inFlightTasks;
        synchronized (linkedList) {
            InFlightTask first;
            if (!this.inFlightTasks.isEmpty() && (first = this.inFlightTasks.peek()).isDone()) {
                this.inFlightTasks.poll();
                first.recycle(readPos, readingEntries);
                this.inFlightTasks.add(first);
                return first;
            }
            InFlightTask task = new InFlightTask(readPos, readingEntries, this.replicatorId);
            this.inFlightTasks.add(task);
            return task;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InFlightTask acquirePermitsIfNotFetchingSchema() {
        LinkedList<InFlightTask> linkedList = this.inFlightTasks;
        synchronized (linkedList) {
            if (this.hasPendingRead()) {
                log.info("[{}] Skip the reading because there is a pending read task", (Object)this.replicatorId);
                return null;
            }
            if (this.waitForCursorRewindingRefCnf > 0) {
                log.info("[{}] Skip the reading due to new detected schema", (Object)this.replicatorId);
                return null;
            }
            if (this.state != AbstractReplicator.State.Started) {
                log.info("[{}] Skip the reading because producer has not started [{}]", (Object)this.replicatorId, (Object)this.state);
                return null;
            }
            int permits = this.getPermitsIfNoPendingRead();
            if (permits == 0) {
                return null;
            }
            return this.createOrRecycleInFlightTaskIntoQueue((PositionImpl)this.cursor.getReadPosition(), permits);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getPermitsIfNoPendingRead() {
        LinkedList<InFlightTask> linkedList = this.inFlightTasks;
        synchronized (linkedList) {
            for (InFlightTask task : this.inFlightTasks) {
                boolean hasPendingCursorRead = task.readPos != null && task.entries == null;
                if (!hasPendingCursorRead) continue;
                return 0;
            }
            return this.producerQueueSize - this.getInflightMessagesCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getInflightMessagesCount() {
        int inFlight = 0;
        LinkedList<InFlightTask> linkedList = this.inFlightTasks;
        synchronized (linkedList) {
            for (InFlightTask task : this.inFlightTasks) {
                if (task.isDone()) continue;
                if (task.entries == null) {
                    inFlight += task.readingEntries;
                    continue;
                }
                inFlight += Math.max(task.entries.size() - task.completedEntries, 0);
            }
        }
        return inFlight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompletableFuture<Void> beforeDisconnect() {
        LinkedList<InFlightTask> linkedList = this.inFlightTasks;
        synchronized (linkedList) {
            for (InFlightTask task : this.inFlightTasks) {
                if (task.isDone() || task.readPos.compareTo((PositionImpl)this.cursor.getManagedLedger().getLastConfirmedEntry()) >= 0) continue;
                return CompletableFuture.failedFuture(new BrokerServiceException.TopicBusyException("Cannot close a replicator with backlog"));
            }
            this.beforeTerminateOrCursorRewinding(ReasonOfWaitForCursorRewinding.Disconnecting);
            return CompletableFuture.completedFuture(null);
        }
    }

    @Override
    protected void afterDisconnected() {
        this.doRewindCursor(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beforeTerminateOrCursorRewinding(ReasonOfWaitForCursorRewinding reason) {
        LinkedList<InFlightTask> linkedList = this.inFlightTasks;
        synchronized (linkedList) {
            boolean hasCanceledPendingRead = this.cursor.cancelPendingReadRequest();
            this.reasonOfWaitForCursorRewinding = reason;
            ++this.waitForCursorRewindingRefCnf;
            this.cancelPendingReadTasks(hasCanceledPendingRead);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRewindCursor(boolean triggerReadMoreEntries) {
        LinkedList<InFlightTask> linkedList = this.inFlightTasks;
        synchronized (linkedList) {
            this.cursor.rewind();
            --this.waitForCursorRewindingRefCnf;
            this.reasonOfWaitForCursorRewinding = null;
        }
        if (triggerReadMoreEntries) {
            this.readMoreEntries();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelPendingReadTasks(boolean canceledPendingRead) {
        InFlightTask readingTask = null;
        LinkedList<InFlightTask> linkedList = this.inFlightTasks;
        synchronized (linkedList) {
            for (InFlightTask task : this.inFlightTasks) {
                task.setSkipReadResultDueToCursorRewind(true);
                if (task.entries != null) continue;
                if (readingTask != null) {
                    log.error("Unexpected state because there are more than one tasks' state is pending read. {}", this.inFlightTasks);
                }
                readingTask = task;
            }
            if (canceledPendingRead && readingTask != null) {
                readingTask.setEntries(Collections.emptyList());
            }
        }
    }

    @Override
    public void beforeTerminate() {
        this.beforeTerminateOrCursorRewinding(ReasonOfWaitForCursorRewinding.Terminating);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasPendingRead() {
        LinkedList<InFlightTask> linkedList = this.inFlightTasks;
        synchronized (linkedList) {
            for (InFlightTask task : this.inFlightTasks) {
                if (task.getReadPos() == null || task.entries != null) continue;
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    String getReplicatorId() {
        return this.replicatorId;
    }

    protected static enum ReasonOfWaitForCursorRewinding {
        Failed_Publishing,
        Fetching_Schema,
        Disconnecting,
        Terminating;

    }

    private static class AvailablePermits {
        private int messages;
        private long bytes;

        public boolean isExceeded() {
            return this.messages == -1 && this.bytes == -1L;
        }

        public boolean isReadable() {
            return this.messages > 0 && this.bytes > 0L;
        }

        @Generated
        public int getMessages() {
            return this.messages;
        }

        @Generated
        public long getBytes() {
            return this.bytes;
        }

        @Generated
        public void setMessages(int messages) {
            this.messages = messages;
        }

        @Generated
        public void setBytes(long bytes) {
            this.bytes = bytes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AvailablePermits)) {
                return false;
            }
            AvailablePermits other = (AvailablePermits)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMessages() != other.getMessages()) {
                return false;
            }
            return this.getBytes() == other.getBytes();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AvailablePermits;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMessages();
            long $bytes = this.getBytes();
            result = result * 59 + (int)($bytes >>> 32 ^ $bytes);
            return result;
        }

        @Generated
        public String toString() {
            return "PersistentReplicator.AvailablePermits(messages=" + this.getMessages() + ", bytes=" + this.getBytes() + ")";
        }

        @Generated
        public AvailablePermits(int messages, long bytes) {
            this.messages = messages;
            this.bytes = bytes;
        }
    }

    protected static class InFlightTask {
        PositionImpl readPos;
        int readingEntries;
        volatile List<Entry> entries;
        volatile int completedEntries;
        volatile boolean skipReadResultDueToCursorRewind;
        final String replicatorId;

        public synchronized void incCompletedEntries() {
            if (!CollectionUtils.isEmpty(this.entries) && this.completedEntries < this.entries.size()) {
                ++this.completedEntries;
            } else {
                log.error("Unexpected calling of increase completed entries. {}", (Object)this.toString());
            }
        }

        synchronized void recycle(PositionImpl readStart, int readingEntries) {
            this.readPos = readStart;
            this.readingEntries = readingEntries;
            this.entries = null;
            this.completedEntries = 0;
            this.skipReadResultDueToCursorRewind = false;
        }

        public InFlightTask(PositionImpl readPos, int readingEntries, String replicatorId) {
            this.readPos = readPos;
            this.readingEntries = readingEntries;
            this.replicatorId = replicatorId;
        }

        public boolean isDone() {
            if (this.entries == null) {
                return false;
            }
            if (this.entries != null && this.entries.isEmpty()) {
                return true;
            }
            return this.completedEntries >= this.entries.size();
        }

        public String toString() {
            return "Replicator InFlightTask {replicatorId=" + this.replicatorId + ", readPos=" + String.valueOf(this.readPos) + ", readingEntries=" + this.readingEntries + ", readoutEntries=" + String.valueOf(this.entries == null ? "-1" : Integer.valueOf(this.entries.size())) + ", completedEntries=" + this.completedEntries + ", skipReadResultDueToCursorRewound=" + this.skipReadResultDueToCursorRewind + "}";
        }

        @Generated
        public PositionImpl getReadPos() {
            return this.readPos;
        }

        @Generated
        public int getReadingEntries() {
            return this.readingEntries;
        }

        @Generated
        public List<Entry> getEntries() {
            return this.entries;
        }

        @Generated
        public int getCompletedEntries() {
            return this.completedEntries;
        }

        @Generated
        public boolean isSkipReadResultDueToCursorRewind() {
            return this.skipReadResultDueToCursorRewind;
        }

        @Generated
        public String getReplicatorId() {
            return this.replicatorId;
        }

        @Generated
        public void setReadPos(PositionImpl readPos) {
            this.readPos = readPos;
        }

        @Generated
        public void setReadingEntries(int readingEntries) {
            this.readingEntries = readingEntries;
        }

        @Generated
        public void setEntries(List<Entry> entries) {
            this.entries = entries;
        }

        @Generated
        public void setCompletedEntries(int completedEntries) {
            this.completedEntries = completedEntries;
        }

        @Generated
        public void setSkipReadResultDueToCursorRewind(boolean skipReadResultDueToCursorRewind) {
            this.skipReadResultDueToCursorRewind = skipReadResultDueToCursorRewind;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InFlightTask)) {
                return false;
            }
            InFlightTask other = (InFlightTask)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getReadingEntries() != other.getReadingEntries()) {
                return false;
            }
            if (this.getCompletedEntries() != other.getCompletedEntries()) {
                return false;
            }
            if (this.isSkipReadResultDueToCursorRewind() != other.isSkipReadResultDueToCursorRewind()) {
                return false;
            }
            PositionImpl this$readPos = this.getReadPos();
            PositionImpl other$readPos = other.getReadPos();
            if (this$readPos == null ? other$readPos != null : !this$readPos.equals(other$readPos)) {
                return false;
            }
            List<Entry> this$entries = this.getEntries();
            List<Entry> other$entries = other.getEntries();
            if (this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries)) {
                return false;
            }
            String this$replicatorId = this.getReplicatorId();
            String other$replicatorId = other.getReplicatorId();
            return !(this$replicatorId == null ? other$replicatorId != null : !this$replicatorId.equals(other$replicatorId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InFlightTask;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getReadingEntries();
            result = result * 59 + this.getCompletedEntries();
            result = result * 59 + (this.isSkipReadResultDueToCursorRewind() ? 79 : 97);
            PositionImpl $readPos = this.getReadPos();
            result = result * 59 + ($readPos == null ? 43 : $readPos.hashCode());
            List<Entry> $entries = this.getEntries();
            result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
            String $replicatorId = this.getReplicatorId();
            result = result * 59 + ($replicatorId == null ? 43 : $replicatorId.hashCode());
            return result;
        }
    }

    protected static final class ProducerSendCallback
    implements SendCallback {
        private PersistentReplicator replicator;
        private Entry entry;
        private MessageImpl msg;
        private InFlightTask inFlightTask;
        private final Recycler.Handle<ProducerSendCallback> recyclerHandle;
        private static final Recycler<ProducerSendCallback> RECYCLER = new Recycler<ProducerSendCallback>(){

            protected ProducerSendCallback newObject(Recycler.Handle<ProducerSendCallback> handle) {
                return new ProducerSendCallback(handle);
            }
        };

        public void sendComplete(Exception exception) {
            if (exception != null && !(exception instanceof PulsarClientException.InvalidMessageException)) {
                log.error("[{}] Error producing on remote broker\uff0c in-flight messages: {}, producer pending queue size: {}", new Object[]{this.replicator.replicatorId, this.replicator.inFlightTasks, this.replicator.producer.getPendingQueueSize(), exception});
                this.replicator.beforeTerminateOrCursorRewinding(ReasonOfWaitForCursorRewinding.Failed_Publishing);
                this.replicator.doRewindCursor(false);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Message persisted on remote broker", (Object)this.replicator.replicatorId, (Object)exception);
                }
                this.inFlightTask.incCompletedEntries();
                this.replicator.cursor.asyncDelete(this.entry.getPosition(), (AsyncCallbacks.DeleteCallback)this.replicator, (Object)this.entry.getPosition());
            }
            this.entry.release();
            int permits = this.replicator.getPermitsIfNoPendingRead();
            if (this.replicator.producerQueueSize - permits < this.replicator.producerQueueThreshold) {
                if (this.replicator.producerQueueSize == permits || this.replicator.producer.isWritable()) {
                    this.replicator.readMoreEntries();
                } else if (log.isDebugEnabled()) {
                    log.debug("[{}] Not resuming reads. pending: {} is-writable: {}", new Object[]{this.replicator.replicatorId, this.replicator.producerQueueSize - permits, this.replicator.producer.isWritable()});
                }
            }
            this.recycle();
        }

        private ProducerSendCallback(Recycler.Handle<ProducerSendCallback> recyclerHandle) {
            this.recyclerHandle = recyclerHandle;
        }

        static ProducerSendCallback create(PersistentReplicator replicator, Entry entry, MessageImpl msg, InFlightTask inFlightTask) {
            ProducerSendCallback sendCallback = (ProducerSendCallback)RECYCLER.get();
            sendCallback.replicator = replicator;
            sendCallback.entry = entry;
            sendCallback.msg = msg;
            sendCallback.inFlightTask = inFlightTask;
            return sendCallback;
        }

        private void recycle() {
            this.inFlightTask = null;
            this.replicator = null;
            this.entry = null;
            if (this.msg != null) {
                this.msg.recycle();
                this.msg = null;
            }
            this.recyclerHandle.recycle((Object)this);
        }

        public void addCallback(MessageImpl<?> msg, SendCallback scb) {
        }

        public SendCallback getNextSendCallback() {
            return null;
        }

        public MessageImpl<?> getNextMessage() {
            return null;
        }

        public CompletableFuture<MessageId> getFuture() {
            return CompletableFuture.completedFuture(null);
        }
    }
}

