/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import com.google.common.base.StandardSystemProperty;
import oshi.SystemInfo;

public final class MachineInfo {
    private static volatile int physicalProcessorCount = -1;

    private MachineInfo() {
    }

    public static int getAvailablePhysicalProcessorCount() {
        if (physicalProcessorCount != -1) {
            return physicalProcessorCount;
        }
        String osArch = StandardSystemProperty.OS_ARCH.value();
        int availableProcessorCount = Runtime.getRuntime().availableProcessors();
        int totalPhysicalProcessorCount = "amd64".equals(osArch) || "x86_64".equals(osArch) ? new SystemInfo().getHardware().getProcessor().getPhysicalProcessorCount() : availableProcessorCount;
        physicalProcessorCount = Math.min(totalPhysicalProcessorCount, availableProcessorCount);
        return physicalProcessorCount;
    }
}

