/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableMap;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import java.util.Map;
import java.util.Objects;

public class ReferenceAwareExpressionNodeInliner
extends ExpressionRewriter<Void> {
    private final Map<NodeRef<Expression>, Expression> mappings;

    public static Expression replaceExpression(Expression expression, Map<NodeRef<Expression>, Expression> mappings) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ReferenceAwareExpressionNodeInliner(mappings), (Expression)expression);
    }

    private ReferenceAwareExpressionNodeInliner(Map<NodeRef<Expression>, Expression> mappings) {
        this.mappings = ImmutableMap.copyOf(Objects.requireNonNull(mappings, "mappings is null"));
    }

    protected Expression rewriteExpression(Expression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
        return this.mappings.get(NodeRef.of((Node)node));
    }
}

