/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window.matcher;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Objects;

public class ArrayView {
    public static final ArrayView EMPTY = new ArrayView(new int[0], 0);
    private final int[] array;
    private final int length;

    public ArrayView(int[] array, int length) {
        this.array = Objects.requireNonNull(array, "array is null");
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"used slots count is negative");
        Preconditions.checkArgument((length <= array.length ? 1 : 0) != 0, (Object)"used slots count exceeds array size");
        this.length = length;
    }

    public int get(int index) {
        Preconditions.checkArgument((index >= 0 && index < this.length ? 1 : 0) != 0, (Object)"array index out of bounds");
        return this.array[index];
    }

    public int length() {
        return this.length;
    }

    @VisibleForTesting
    int[] toArray() {
        return Arrays.copyOf(this.array, this.length);
    }
}

