/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamptz;

import io.trino.operator.scalar.QuarterOfYearDateTimeField;
import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.util.DateTimeZoneIndex;
import org.joda.time.Chronology;

@Description(value="Quarter of the year of the given timestamp")
@ScalarFunction(value="quarter")
public class ExtractQuarter {
    private ExtractQuarter() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(@SqlType(value="timestamp(p) with time zone") long packedEpochMillis) {
        return QuarterOfYearDateTimeField.QUARTER_OF_YEAR.getField((Chronology)DateTimeZoneIndex.unpackChronology(packedEpochMillis)).get(DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis));
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp) {
        return QuarterOfYearDateTimeField.QUARTER_OF_YEAR.getField((Chronology)DateTimeZoneIndex.getChronology(TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey()))).get(timestamp.getEpochMillis());
    }
}

