/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlOperator;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.type.UnknownType;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;

public final class CastFromUnknownOperator
extends SqlOperator {
    public static final CastFromUnknownOperator CAST_FROM_UNKNOWN = new CastFromUnknownOperator();
    private static final MethodHandle METHOD_HANDLE_NON_NULL = Reflection.methodHandle(CastFromUnknownOperator.class, "handleNonNull", Boolean.TYPE);

    public CastFromUnknownOperator() {
        super(OperatorType.CAST, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("E")), (List<LongVariableConstraint>)ImmutableList.of(), new TypeSignature("E", new TypeSignatureParameter[0]), (List<TypeSignature>)ImmutableList.of((Object)UnknownType.UNKNOWN.getTypeSignature()), false);
    }

    @Override
    protected ScalarFunctionImplementation specialize(BoundSignature boundSignature) {
        Type toType = boundSignature.getReturnType();
        MethodHandle methodHandle = METHOD_HANDLE_NON_NULL.asType(METHOD_HANDLE_NON_NULL.type().changeReturnType(toType.getJavaType()));
        return new ChoicesScalarFunctionImplementation(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    @UsedByGeneratedCode
    public static Object handleNonNull(boolean arg) {
        throw new IllegalArgumentException("value of unknown type should always be null");
    }
}

