/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.PageBuilder;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.util.Failures;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@ScalarFunction(value="array_remove")
@Description(value="Remove specified values from the given array")
public final class ArrayRemoveFunction {
    private final PageBuilder pageBuilder;

    @TypeParameter(value="E")
    public ArrayRemoveFunction(@TypeParameter(value="E") Type elementType) {
        this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)elementType));
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block remove(@OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"E", "E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equalsFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block array, @SqlType(value="E") long value) {
        return this.remove(equalsFunction, type, array, (Object)value);
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block remove(@OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"E", "E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equalsFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block array, @SqlType(value="E") double value) {
        return this.remove(equalsFunction, type, array, (Object)value);
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block remove(@OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"E", "E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equalsFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block array, @SqlType(value="E") boolean value) {
        return this.remove(equalsFunction, type, array, (Object)value);
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block remove(@OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"E", "E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equalsFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block array, @SqlType(value="E") Object value) {
        ArrayList<Integer> positions = new ArrayList<Integer>();
        for (int i = 0; i < array.getPositionCount(); ++i) {
            Object element = TypeUtils.readNativeValue((Type)type, (Block)array, (int)i);
            try {
                if (element == null) {
                    positions.add(i);
                    continue;
                }
                Boolean result = equalsFunction.invoke(element, value);
                if (result == null) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "array_remove does not support arrays with elements that are null or contain null");
                }
                if (result.booleanValue()) continue;
                positions.add(i);
                continue;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (array.getPositionCount() == positions.size()) {
            return array;
        }
        if (this.pageBuilder.isFull()) {
            this.pageBuilder.reset();
        }
        BlockBuilder blockBuilder = this.pageBuilder.getBlockBuilder(0);
        Iterator iterator = positions.iterator();
        while (iterator.hasNext()) {
            int position = (Integer)iterator.next();
            type.appendTo(array, position, blockBuilder);
        }
        this.pageBuilder.declarePositions(positions.size());
        return blockBuilder.getRegion(blockBuilder.getPositionCount() - positions.size(), positions.size());
    }
}

