/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import io.airlift.stats.QuantileDigest;
import io.trino.operator.aggregation.FloatingPointBitsConverterUtil;
import io.trino.operator.aggregation.LegacyApproximateLongPercentileAggregations;
import io.trino.operator.aggregation.state.QuantileDigestAndPercentileState;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Description;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DoubleType;
import io.trino.util.Failures;

@AggregationFunction(value="approx_percentile")
public final class LegacyApproximateDoublePercentileAggregations {
    private LegacyApproximateDoublePercentileAggregations() {
    }

    @Deprecated
    @Description(value="(DEPRECATED) Use approx_percentile(x, weight, percentile) instead")
    @InputFunction
    public static void weightedInput(@AggregationState QuantileDigestAndPercentileState state, @SqlType(value="double") double value, @SqlType(value="double") double weight, @SqlType(value="double") double percentile, @SqlType(value="double") double accuracy) {
        LegacyApproximateLongPercentileAggregations.weightedInput(state, FloatingPointBitsConverterUtil.doubleToSortableLong(value), weight, percentile, accuracy);
    }

    @CombineFunction
    public static void combine(@AggregationState QuantileDigestAndPercentileState state, QuantileDigestAndPercentileState otherState) {
        LegacyApproximateLongPercentileAggregations.combine(state, otherState);
    }

    @OutputFunction(value="double")
    public static void output(@AggregationState QuantileDigestAndPercentileState state, BlockBuilder out) {
        QuantileDigest digest = state.getDigest();
        double percentile = state.getPercentile();
        if (digest == null || digest.getCount() == 0.0) {
            out.appendNull();
        } else {
            Preconditions.checkState((percentile != -1.0 ? 1 : 0) != 0, (Object)"Percentile is missing");
            Failures.checkCondition(0.0 <= percentile && percentile <= 1.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile must be between 0 and 1", new Object[0]);
            DoubleType.DOUBLE.writeDouble(out, FloatingPointBitsConverterUtil.sortableLongToDouble(digest.getQuantile(percentile)));
        }
    }
}

