/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.airlift.stats.cardinality.HyperLogLog;
import io.trino.operator.aggregation.state.HyperLogLogState;
import io.trino.operator.aggregation.state.StateCompiler;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Convention;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.util.Failures;
import java.lang.invoke.MethodHandle;

@AggregationFunction(value="$approx_set", hidden=true)
public final class ApproximateSetGenericAggregation {
    private static final int NUMBER_OF_BUCKETS = 4096;
    private static final AccumulatorStateSerializer<HyperLogLogState> SERIALIZER = StateCompiler.generateStateSerializer(HyperLogLogState.class);

    private ApproximateSetGenericAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState HyperLogLogState state, @BlockPosition @SqlType(value="unknown") Block block, @BlockIndex int index) {
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@OperatorDependency(operator=OperatorType.XX_HASH_64, argumentTypes={"T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle methodHandle, @AggregationState HyperLogLogState state, @SqlType(value="T") double value) {
        long hash;
        HyperLogLog hll = ApproximateSetGenericAggregation.getOrCreateHyperLogLog(state);
        state.addMemoryUsage(-hll.estimatedInMemorySize());
        try {
            hash = methodHandle.invoke(value);
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
        hll.addHash(hash);
        state.addMemoryUsage(hll.estimatedInMemorySize());
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@OperatorDependency(operator=OperatorType.XX_HASH_64, argumentTypes={"T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle methodHandle, @AggregationState HyperLogLogState state, @SqlType(value="T") long value) {
        long hash;
        HyperLogLog hll = ApproximateSetGenericAggregation.getOrCreateHyperLogLog(state);
        state.addMemoryUsage(-hll.estimatedInMemorySize());
        try {
            hash = methodHandle.invoke(value);
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
        hll.addHash(hash);
        state.addMemoryUsage(hll.estimatedInMemorySize());
    }

    @InputFunction
    public static void input(@AggregationState HyperLogLogState state, @SqlType(value="BOOLEAN") boolean value) {
        HyperLogLog hll = ApproximateSetGenericAggregation.getOrCreateHyperLogLog(state);
        state.addMemoryUsage(-hll.estimatedInMemorySize());
        hll.addHash(value ? 19144387141682250L : -2447670524089286488L);
        state.addMemoryUsage(hll.estimatedInMemorySize());
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@OperatorDependency(operator=OperatorType.XX_HASH_64, argumentTypes={"T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle methodHandle, @AggregationState HyperLogLogState state, @SqlType(value="T") Object value) {
        long hash;
        HyperLogLog hll = ApproximateSetGenericAggregation.getOrCreateHyperLogLog(state);
        state.addMemoryUsage(-hll.estimatedInMemorySize());
        try {
            hash = methodHandle.invoke(value);
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
        hll.addHash(hash);
        state.addMemoryUsage(hll.estimatedInMemorySize());
    }

    @CombineFunction
    public static void combineState(@AggregationState HyperLogLogState state, @AggregationState HyperLogLogState otherState) {
        HyperLogLog input = otherState.getHyperLogLog();
        HyperLogLog previous = state.getHyperLogLog();
        if (previous == null) {
            state.setHyperLogLog(input);
            state.addMemoryUsage(input.estimatedInMemorySize());
        } else {
            state.addMemoryUsage(-previous.estimatedInMemorySize());
            previous.mergeWith(input);
            state.addMemoryUsage(previous.estimatedInMemorySize());
        }
    }

    @OutputFunction(value="HyperLogLog")
    public static void evaluateFinal(@AggregationState HyperLogLogState state, BlockBuilder out) {
        SERIALIZER.serialize((AccumulatorState)state, out);
    }

    public static HyperLogLog getOrCreateHyperLogLog(@AggregationState HyperLogLogState state) {
        HyperLogLog hll = state.getHyperLogLog();
        if (hll == null) {
            hll = ApproximateSetGenericAggregation.newHyperLogLog();
            state.setHyperLogLog(hll);
            state.addMemoryUsage(hll.estimatedInMemorySize());
        }
        return hll;
    }

    public static HyperLogLog newHyperLogLog() {
        return HyperLogLog.newInstance((int)4096);
    }
}

