/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBComparator;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.Range;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.Snapshot;
import org.iq80.leveldb.WriteBatch;
import org.iq80.leveldb.WriteOptions;
import org.iq80.leveldb.impl.Compaction;
import org.iq80.leveldb.impl.DbLock;
import org.iq80.leveldb.impl.FileMetaData;
import org.iq80.leveldb.impl.Filename;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.impl.InternalKeyComparator;
import org.iq80.leveldb.impl.InternalUserComparator;
import org.iq80.leveldb.impl.LogWriter;
import org.iq80.leveldb.impl.Logs;
import org.iq80.leveldb.impl.LookupKey;
import org.iq80.leveldb.impl.LookupResult;
import org.iq80.leveldb.impl.MemTable;
import org.iq80.leveldb.impl.SeekingIterable;
import org.iq80.leveldb.impl.SeekingIteratorAdapter;
import org.iq80.leveldb.impl.SnapshotImpl;
import org.iq80.leveldb.impl.SnapshotSeekingIterator;
import org.iq80.leveldb.impl.TableCache;
import org.iq80.leveldb.impl.ValueType;
import org.iq80.leveldb.impl.Version;
import org.iq80.leveldb.impl.VersionEdit;
import org.iq80.leveldb.impl.VersionSet;
import org.iq80.leveldb.impl.WriteBatchImpl;
import org.iq80.leveldb.table.BytewiseComparator;
import org.iq80.leveldb.table.CustomUserComparator;
import org.iq80.leveldb.table.TableBuilder;
import org.iq80.leveldb.table.UserComparator;
import org.iq80.leveldb.util.DbIterator;
import org.iq80.leveldb.util.MergingIterator;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.SliceInput;
import org.iq80.leveldb.util.SliceOutput;
import org.iq80.leveldb.util.Slices;
import org.iq80.leveldb.util.Snappy;

public class DbImpl
implements DB {
    private final Options options;
    private final File databaseDir;
    private final TableCache tableCache;
    private final DbLock dbLock;
    private final VersionSet versions;
    private final AtomicBoolean shuttingDown = new AtomicBoolean();
    private final ReentrantLock mutex = new ReentrantLock();
    private final Condition backgroundCondition = this.mutex.newCondition();
    private final List<Long> pendingOutputs = new ArrayList<Long>();
    private LogWriter log;
    private MemTable memTable;
    private MemTable immutableMemTable;
    private final InternalKeyComparator internalKeyComparator;
    private volatile Throwable backgroundException;
    private final ExecutorService compactionExecutor;
    private Future<?> backgroundCompaction;
    private ManualCompaction manualCompaction;
    private final Object suspensionMutex = new Object();
    private int suspensionCounter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbImpl(Options options, File databaseDir) throws IOException {
        Objects.requireNonNull(options, "options is null");
        Objects.requireNonNull(databaseDir, "databaseDir is null");
        this.options = options;
        if (this.options.compressionType() == CompressionType.SNAPPY && !Snappy.available()) {
            this.options.compressionType(CompressionType.NONE);
        }
        this.databaseDir = databaseDir;
        DBComparator comparator = options.comparator();
        UserComparator userComparator = comparator != null ? new CustomUserComparator(comparator) : new BytewiseComparator();
        this.internalKeyComparator = new InternalKeyComparator(userComparator);
        this.memTable = new MemTable(this.internalKeyComparator);
        this.immutableMemTable = null;
        ThreadFactory compactionThreadFactory = new ThreadFactoryBuilder().setNameFormat("leveldb-compaction-%s").setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                System.out.printf("%s%n", t);
                e.printStackTrace();
            }
        }).build();
        this.compactionExecutor = Executors.newSingleThreadExecutor(compactionThreadFactory);
        int tableCacheSize = options.maxOpenFiles() - 10;
        this.tableCache = new TableCache(databaseDir, tableCacheSize, new InternalUserComparator(this.internalKeyComparator), options.verifyChecksums());
        databaseDir.mkdirs();
        Preconditions.checkArgument((boolean)databaseDir.exists(), (String)"Database directory '%s' does not exist and could not be created", (Object)databaseDir);
        Preconditions.checkArgument((boolean)databaseDir.isDirectory(), (String)"Database directory '%s' is not a directory", (Object)databaseDir);
        this.mutex.lock();
        try {
            this.dbLock = new DbLock(new File(databaseDir, Filename.lockFileName()));
            File currentFile = new File(databaseDir, Filename.currentFileName());
            if (!currentFile.canRead()) {
                Preconditions.checkArgument((boolean)options.createIfMissing(), (String)"Database '%s' does not exist and the create if missing option is disabled", (Object)databaseDir);
            } else {
                Preconditions.checkArgument((!options.errorIfExists() ? 1 : 0) != 0, (String)"Database '%s' exists and the error if exists option is enabled", (Object)databaseDir);
            }
            this.versions = new VersionSet(databaseDir, this.tableCache, this.internalKeyComparator);
            this.versions.recover();
            long minLogNumber = this.versions.getLogNumber();
            long previousLogNumber = this.versions.getPrevLogNumber();
            List<File> filenames = Filename.listFiles(databaseDir);
            ArrayList<Long> logs = new ArrayList<Long>();
            for (File file : filenames) {
                Filename.FileInfo fileInfo = Filename.parseFileName(file);
                if (fileInfo == null || fileInfo.getFileType() != Filename.FileType.LOG || fileInfo.getFileNumber() < minLogNumber && fileInfo.getFileNumber() != previousLogNumber) continue;
                logs.add(fileInfo.getFileNumber());
            }
            VersionEdit edit = new VersionEdit();
            Collections.sort(logs);
            for (Long fileNumber : logs) {
                long maxSequence = this.recoverLogFile(fileNumber, edit);
                if (this.versions.getLastSequence() >= maxSequence) continue;
                this.versions.setLastSequence(maxSequence);
            }
            long l = this.versions.getNextFileNumber();
            this.log = Logs.createLogWriter(new File(databaseDir, Filename.logFileName(l)), l);
            edit.setLogNumber(this.log.getFileNumber());
            this.versions.logAndApply(edit);
            this.deleteObsoleteFiles();
            this.maybeScheduleCompaction();
        }
        finally {
            this.mutex.unlock();
        }
    }

    public void close() {
        if (this.shuttingDown.getAndSet(true)) {
            return;
        }
        this.mutex.lock();
        try {
            while (this.backgroundCompaction != null) {
                this.backgroundCondition.awaitUninterruptibly();
            }
        }
        finally {
            this.mutex.unlock();
        }
        this.compactionExecutor.shutdown();
        try {
            this.compactionExecutor.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            this.versions.destroy();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.log.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.tableCache.close();
        this.dbLock.release();
    }

    public String getProperty(String name) {
        this.checkBackgroundException();
        return null;
    }

    private void deleteObsoleteFiles() {
        Preconditions.checkState((boolean)this.mutex.isHeldByCurrentThread());
        ArrayList<Long> live = new ArrayList<Long>(this.pendingOutputs);
        for (FileMetaData fileMetaData : this.versions.getLiveFiles()) {
            live.add(fileMetaData.getNumber());
        }
        for (File file : Filename.listFiles(this.databaseDir)) {
            Filename.FileInfo fileInfo = Filename.parseFileName(file);
            if (fileInfo == null) continue;
            long number = fileInfo.getFileNumber();
            boolean keep = true;
            switch (fileInfo.getFileType()) {
                case LOG: {
                    keep = number >= this.versions.getLogNumber() || number == this.versions.getPrevLogNumber();
                    break;
                }
                case DESCRIPTOR: {
                    keep = number >= this.versions.getManifestFileNumber();
                    break;
                }
                case TABLE: {
                    keep = live.contains(number);
                    break;
                }
                case TEMP: {
                    keep = live.contains(number);
                    break;
                }
                case CURRENT: 
                case DB_LOCK: 
                case INFO_LOG: {
                    keep = true;
                }
            }
            if (keep) continue;
            if (fileInfo.getFileType() == Filename.FileType.TABLE) {
                this.tableCache.evict(number);
            }
            file.delete();
        }
    }

    public void flushMemTable() {
        this.mutex.lock();
        try {
            this.makeRoomForWrite(true);
            while (this.immutableMemTable != null) {
                this.backgroundCondition.awaitUninterruptibly();
            }
        }
        finally {
            this.mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactRange(int level, Slice start, Slice end) {
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0, (Object)"level is negative");
        Preconditions.checkArgument((level + 1 < 7 ? 1 : 0) != 0, (String)"level is greater than or equal to %s", (int)7);
        Objects.requireNonNull(start, "start is null");
        Objects.requireNonNull(end, "end is null");
        this.mutex.lock();
        try {
            ManualCompaction manualCompaction;
            while (this.manualCompaction != null) {
                this.backgroundCondition.awaitUninterruptibly();
            }
            this.manualCompaction = manualCompaction = new ManualCompaction(level, start, end);
            this.maybeScheduleCompaction();
            while (this.manualCompaction == manualCompaction) {
                this.backgroundCondition.awaitUninterruptibly();
            }
        }
        finally {
            this.mutex.unlock();
        }
    }

    private void maybeScheduleCompaction() {
        Preconditions.checkState((boolean)this.mutex.isHeldByCurrentThread());
        if (this.backgroundCompaction == null && !this.shuttingDown.get() && (this.immutableMemTable != null || this.manualCompaction != null || this.versions.needsCompaction())) {
            this.backgroundCompaction = this.compactionExecutor.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        DbImpl.this.backgroundCall();
                    }
                    catch (DatabaseShutdownException databaseShutdownException) {
                    }
                    catch (Throwable e) {
                        DbImpl.this.backgroundException = e;
                    }
                    return null;
                }
            });
        }
    }

    public void checkBackgroundException() {
        Throwable e = this.backgroundException;
        if (e != null) {
            throw new BackgroundProcessingException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backgroundCall() throws IOException {
        this.mutex.lock();
        try {
            if (this.backgroundCompaction == null) {
                return;
            }
            try {
                if (!this.shuttingDown.get()) {
                    this.backgroundCompaction();
                }
            }
            finally {
                this.backgroundCompaction = null;
            }
        }
        finally {
            try {
                this.maybeScheduleCompaction();
            }
            finally {
                try {
                    this.backgroundCondition.signalAll();
                }
                finally {
                    this.mutex.unlock();
                }
            }
        }
    }

    private void backgroundCompaction() throws IOException {
        Preconditions.checkState((boolean)this.mutex.isHeldByCurrentThread());
        this.compactMemTableInternal();
        Compaction compaction = this.manualCompaction != null ? this.versions.compactRange(this.manualCompaction.level, new InternalKey(this.manualCompaction.begin, 0xFFFFFFFFFFFFFFL, ValueType.VALUE), new InternalKey(this.manualCompaction.end, 0L, ValueType.DELETION)) : this.versions.pickCompaction();
        if (compaction != null) {
            if (this.manualCompaction == null && compaction.isTrivialMove()) {
                Preconditions.checkState((compaction.getLevelInputs().size() == 1 ? 1 : 0) != 0);
                FileMetaData fileMetaData = compaction.getLevelInputs().get(0);
                compaction.getEdit().deleteFile(compaction.getLevel(), fileMetaData.getNumber());
                compaction.getEdit().addFile(compaction.getLevel() + 1, fileMetaData);
                this.versions.logAndApply(compaction.getEdit());
            } else {
                CompactionState compactionState = new CompactionState(compaction);
                this.doCompactionWork(compactionState);
                this.cleanupCompaction(compactionState);
            }
        }
        if (this.manualCompaction != null) {
            this.manualCompaction = null;
        }
    }

    private void cleanupCompaction(CompactionState compactionState) {
        Preconditions.checkState((boolean)this.mutex.isHeldByCurrentThread());
        if (compactionState.builder != null) {
            compactionState.builder.abandon();
        } else {
            Preconditions.checkArgument((compactionState.outfile == null ? 1 : 0) != 0);
        }
        for (FileMetaData output : compactionState.outputs) {
            this.pendingOutputs.remove(output.getNumber());
        }
    }

    /*
     * Exception decompiling
     */
    private long recoverLogFile(long fileNumber, VersionEdit edit) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] get(byte[] key) throws DBException {
        return this.get(key, new ReadOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(byte[] key, ReadOptions options) throws DBException {
        Slice value;
        LookupKey lookupKey;
        this.checkBackgroundException();
        this.mutex.lock();
        try {
            SnapshotImpl snapshot = this.getSnapshot(options);
            lookupKey = new LookupKey(Slices.wrappedBuffer(key), snapshot.getLastSequence());
            LookupResult lookupResult = this.memTable.get(lookupKey);
            if (lookupResult != null) {
                Slice value2 = lookupResult.getValue();
                if (value2 == null) {
                    byte[] byArray = null;
                    return byArray;
                }
                byte[] byArray = value2.getBytes();
                return byArray;
            }
            if (this.immutableMemTable != null && (lookupResult = this.immutableMemTable.get(lookupKey)) != null) {
                Slice value3 = lookupResult.getValue();
                if (value3 == null) {
                    byte[] byArray = null;
                    return byArray;
                }
                byte[] byArray = value3.getBytes();
                return byArray;
            }
        }
        finally {
            this.mutex.unlock();
        }
        LookupResult lookupResult = this.versions.get(lookupKey);
        this.mutex.lock();
        try {
            if (this.versions.needsCompaction()) {
                this.maybeScheduleCompaction();
            }
        }
        finally {
            this.mutex.unlock();
        }
        if (lookupResult != null && (value = lookupResult.getValue()) != null) {
            return value.getBytes();
        }
        return null;
    }

    public void put(byte[] key, byte[] value) throws DBException {
        this.put(key, value, new WriteOptions());
    }

    public Snapshot put(byte[] key, byte[] value, WriteOptions options) throws DBException {
        return this.writeInternal(new WriteBatchImpl().put(key, value), options);
    }

    public void delete(byte[] key) throws DBException {
        this.writeInternal(new WriteBatchImpl().delete(key), new WriteOptions());
    }

    public Snapshot delete(byte[] key, WriteOptions options) throws DBException {
        return this.writeInternal(new WriteBatchImpl().delete(key), options);
    }

    public void write(WriteBatch updates) throws DBException {
        this.writeInternal((WriteBatchImpl)updates, new WriteOptions());
    }

    public Snapshot write(WriteBatch updates, WriteOptions options) throws DBException {
        return this.writeInternal((WriteBatchImpl)updates, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snapshot writeInternal(WriteBatchImpl updates, WriteOptions options) throws DBException {
        this.checkBackgroundException();
        this.mutex.lock();
        try {
            long sequenceEnd;
            if (updates.size() != 0) {
                this.makeRoomForWrite(false);
                long sequenceBegin = this.versions.getLastSequence() + 1L;
                sequenceEnd = sequenceBegin + (long)updates.size() - 1L;
                this.versions.setLastSequence(sequenceEnd);
                Slice record = this.writeWriteBatch(updates, sequenceBegin);
                try {
                    this.log.addRecord(record, options.sync());
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
                updates.forEach(new InsertIntoHandler(this.memTable, sequenceBegin));
            } else {
                sequenceEnd = this.versions.getLastSequence();
            }
            if (options.snapshot()) {
                SnapshotImpl snapshotImpl = new SnapshotImpl(this.versions.getCurrent(), sequenceEnd);
                return snapshotImpl;
            }
            Snapshot snapshot = null;
            return snapshot;
        }
        finally {
            this.mutex.unlock();
        }
    }

    public WriteBatch createWriteBatch() {
        this.checkBackgroundException();
        return new WriteBatchImpl();
    }

    public SeekingIteratorAdapter iterator() {
        return this.iterator(new ReadOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SeekingIteratorAdapter iterator(ReadOptions options) {
        this.checkBackgroundException();
        this.mutex.lock();
        try {
            DbIterator rawIterator = this.internalIterator();
            SnapshotImpl snapshot = this.getSnapshot(options);
            SnapshotSeekingIterator snapshotIterator = new SnapshotSeekingIterator(rawIterator, snapshot, this.internalKeyComparator.getUserComparator());
            SeekingIteratorAdapter seekingIteratorAdapter = new SeekingIteratorAdapter(snapshotIterator);
            return seekingIteratorAdapter;
        }
        finally {
            this.mutex.unlock();
        }
    }

    SeekingIterable<InternalKey, Slice> internalIterable() {
        return new SeekingIterable<InternalKey, Slice>(){

            public DbIterator iterator() {
                return DbImpl.this.internalIterator();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DbIterator internalIterator() {
        this.mutex.lock();
        try {
            MemTable.MemTableIterator iterator = null;
            if (this.immutableMemTable != null) {
                iterator = this.immutableMemTable.iterator();
            }
            Version current = this.versions.getCurrent();
            DbIterator dbIterator = new DbIterator(this.memTable.iterator(), iterator, current.getLevel0Files(), current.getLevelIterators(), this.internalKeyComparator);
            return dbIterator;
        }
        finally {
            this.mutex.unlock();
        }
    }

    public Snapshot getSnapshot() {
        this.checkBackgroundException();
        this.mutex.lock();
        try {
            SnapshotImpl snapshotImpl = new SnapshotImpl(this.versions.getCurrent(), this.versions.getLastSequence());
            return snapshotImpl;
        }
        finally {
            this.mutex.unlock();
        }
    }

    private SnapshotImpl getSnapshot(ReadOptions options) {
        SnapshotImpl snapshot;
        if (options.snapshot() != null) {
            snapshot = (SnapshotImpl)options.snapshot();
        } else {
            snapshot = new SnapshotImpl(this.versions.getCurrent(), this.versions.getLastSequence());
            snapshot.close();
        }
        return snapshot;
    }

    private void makeRoomForWrite(boolean force) {
        boolean allowDelay;
        Preconditions.checkState((boolean)this.mutex.isHeldByCurrentThread());
        boolean bl = allowDelay = !force;
        while (true) {
            if (allowDelay && this.versions.numberOfFilesInLevel(0) > 8) {
                try {
                    this.mutex.unlock();
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                finally {
                    this.mutex.lock();
                }
                allowDelay = false;
                continue;
            }
            if (!force && this.memTable.approximateMemoryUsage() <= (long)this.options.writeBufferSize()) break;
            if (this.immutableMemTable != null) {
                this.backgroundCondition.awaitUninterruptibly();
                continue;
            }
            if (this.versions.numberOfFilesInLevel(0) >= 12) {
                this.backgroundCondition.awaitUninterruptibly();
                continue;
            }
            Preconditions.checkState((this.versions.getPrevLogNumber() == 0L ? 1 : 0) != 0);
            try {
                this.log.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to close log file " + this.log.getFile(), e);
            }
            long logNumber = this.versions.getNextFileNumber();
            try {
                this.log = Logs.createLogWriter(new File(this.databaseDir, Filename.logFileName(logNumber)), logNumber);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to open new log file " + new File(this.databaseDir, Filename.logFileName(logNumber)).getAbsoluteFile(), e);
            }
            this.immutableMemTable = this.memTable;
            this.memTable = new MemTable(this.internalKeyComparator);
            force = false;
            this.maybeScheduleCompaction();
        }
    }

    public void compactMemTable() throws IOException {
        this.mutex.lock();
        try {
            this.compactMemTableInternal();
        }
        finally {
            this.mutex.unlock();
        }
    }

    private void compactMemTableInternal() throws IOException {
        Preconditions.checkState((boolean)this.mutex.isHeldByCurrentThread());
        if (this.immutableMemTable == null) {
            return;
        }
        try {
            VersionEdit edit = new VersionEdit();
            Version base = this.versions.getCurrent();
            this.writeLevel0Table(this.immutableMemTable, edit, base);
            if (this.shuttingDown.get()) {
                throw new DatabaseShutdownException("Database shutdown during memtable compaction");
            }
            edit.setPreviousLogNumber(0L);
            edit.setLogNumber(this.log.getFileNumber());
            this.versions.logAndApply(edit);
            this.immutableMemTable = null;
            this.deleteObsoleteFiles();
        }
        finally {
            this.backgroundCondition.signalAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLevel0Table(MemTable mem, VersionEdit edit, Version base) throws IOException {
        FileMetaData meta;
        Preconditions.checkState((boolean)this.mutex.isHeldByCurrentThread());
        if (mem.isEmpty()) {
            return;
        }
        long fileNumber = this.versions.getNextFileNumber();
        this.pendingOutputs.add(fileNumber);
        this.mutex.unlock();
        try {
            meta = this.buildTable(mem, fileNumber);
        }
        finally {
            this.mutex.lock();
        }
        this.pendingOutputs.remove(fileNumber);
        int level = 0;
        if (meta != null && meta.getFileSize() > 0L) {
            Slice minUserKey = meta.getSmallest().getUserKey();
            Slice maxUserKey = meta.getLargest().getUserKey();
            if (base != null) {
                level = base.pickLevelForMemTableOutput(minUserKey, maxUserKey);
            }
            edit.addFile(level, meta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileMetaData buildTable(SeekingIterable<InternalKey, Slice> data, long fileNumber) throws IOException {
        File file = new File(this.databaseDir, Filename.tableFileName(fileNumber));
        try {
            InternalKey smallest = null;
            InternalKey largest = null;
            FileChannel channel = new FileOutputStream(file).getChannel();
            try {
                TableBuilder tableBuilder = new TableBuilder(this.options, channel, new InternalUserComparator(this.internalKeyComparator));
                for (Map.Entry entry : data) {
                    InternalKey key = (InternalKey)entry.getKey();
                    if (smallest == null) {
                        smallest = key;
                    }
                    largest = key;
                    tableBuilder.add(key.encode(), (Slice)entry.getValue());
                }
                tableBuilder.finish();
            }
            finally {
                try {
                    channel.force(true);
                }
                finally {
                    channel.close();
                }
            }
            if (smallest == null) {
                return null;
            }
            FileMetaData fileMetaData = new FileMetaData(fileNumber, file.length(), smallest, largest);
            this.tableCache.newIterator(fileMetaData);
            this.pendingOutputs.remove(fileNumber);
            return fileMetaData;
        }
        catch (IOException e) {
            file.delete();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCompactionWork(CompactionState compactionState) throws IOException {
        Preconditions.checkState((boolean)this.mutex.isHeldByCurrentThread());
        Preconditions.checkArgument((this.versions.numberOfBytesInLevel(compactionState.getCompaction().getLevel()) > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((compactionState.builder == null ? 1 : 0) != 0);
        Preconditions.checkArgument((compactionState.outfile == null ? 1 : 0) != 0);
        compactionState.smallestSnapshot = this.versions.getLastSequence();
        this.mutex.unlock();
        try {
            MergingIterator iterator = this.versions.makeInputIterator(compactionState.compaction);
            Slice currentUserKey = null;
            boolean hasCurrentUserKey = false;
            long lastSequenceForKey = 0xFFFFFFFFFFFFFFL;
            while (iterator.hasNext() && !this.shuttingDown.get()) {
                this.mutex.lock();
                try {
                    this.compactMemTableInternal();
                }
                finally {
                    this.mutex.unlock();
                }
                InternalKey key = (InternalKey)iterator.peek().getKey();
                if (compactionState.compaction.shouldStopBefore(key) && compactionState.builder != null) {
                    this.finishCompactionOutputFile(compactionState);
                }
                boolean drop = false;
                if (!hasCurrentUserKey || this.internalKeyComparator.getUserComparator().compare(key.getUserKey(), currentUserKey) != 0) {
                    currentUserKey = key.getUserKey();
                    hasCurrentUserKey = true;
                    lastSequenceForKey = 0xFFFFFFFFFFFFFFL;
                }
                if (lastSequenceForKey <= compactionState.smallestSnapshot) {
                    drop = true;
                } else if (key.getValueType() == ValueType.DELETION && key.getSequenceNumber() <= compactionState.smallestSnapshot && compactionState.compaction.isBaseLevelForKey(key.getUserKey())) {
                    drop = true;
                }
                lastSequenceForKey = key.getSequenceNumber();
                if (!drop) {
                    if (compactionState.builder == null) {
                        this.openCompactionOutputFile(compactionState);
                    }
                    if (compactionState.builder.getEntryCount() == 0L) {
                        compactionState.currentSmallest = key;
                    }
                    compactionState.currentLargest = key;
                    compactionState.builder.add(key.encode(), (Slice)iterator.peek().getValue());
                    if (compactionState.builder.getFileSize() >= compactionState.compaction.getMaxOutputFileSize()) {
                        this.finishCompactionOutputFile(compactionState);
                    }
                }
                iterator.next();
            }
            if (this.shuttingDown.get()) {
                throw new DatabaseShutdownException("DB shutdown during compaction");
            }
            if (compactionState.builder != null) {
                this.finishCompactionOutputFile(compactionState);
            }
        }
        finally {
            this.mutex.lock();
        }
        this.installCompactionResults(compactionState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openCompactionOutputFile(CompactionState compactionState) throws FileNotFoundException {
        Objects.requireNonNull(compactionState, "compactionState is null");
        Preconditions.checkArgument((compactionState.builder == null ? 1 : 0) != 0, (Object)"compactionState builder is not null");
        this.mutex.lock();
        try {
            long fileNumber = this.versions.getNextFileNumber();
            this.pendingOutputs.add(fileNumber);
            compactionState.currentFileNumber = fileNumber;
            compactionState.currentFileSize = 0L;
            compactionState.currentSmallest = null;
            compactionState.currentLargest = null;
            File file = new File(this.databaseDir, Filename.tableFileName(fileNumber));
            compactionState.outfile = new FileOutputStream(file).getChannel();
            compactionState.builder = new TableBuilder(this.options, compactionState.outfile, new InternalUserComparator(this.internalKeyComparator));
        }
        finally {
            this.mutex.unlock();
        }
    }

    private void finishCompactionOutputFile(CompactionState compactionState) throws IOException {
        Objects.requireNonNull(compactionState, "compactionState is null");
        Preconditions.checkArgument((compactionState.outfile != null ? 1 : 0) != 0);
        Preconditions.checkArgument((compactionState.builder != null ? 1 : 0) != 0);
        long outputNumber = compactionState.currentFileNumber;
        Preconditions.checkArgument((outputNumber != 0L ? 1 : 0) != 0);
        long currentEntries = compactionState.builder.getEntryCount();
        compactionState.builder.finish();
        long currentBytes = compactionState.builder.getFileSize();
        compactionState.currentFileSize = currentBytes;
        CompactionState compactionState2 = compactionState;
        compactionState2.totalBytes = compactionState2.totalBytes + currentBytes;
        FileMetaData currentFileMetaData = new FileMetaData(compactionState.currentFileNumber, compactionState.currentFileSize, compactionState.currentSmallest, compactionState.currentLargest);
        compactionState.outputs.add(currentFileMetaData);
        compactionState.builder = null;
        compactionState.outfile.force(true);
        compactionState.outfile.close();
        compactionState.outfile = null;
        if (currentEntries > 0L) {
            this.tableCache.newIterator(outputNumber);
        }
    }

    private void installCompactionResults(CompactionState compact) throws IOException {
        Preconditions.checkState((boolean)this.mutex.isHeldByCurrentThread());
        compact.compaction.addInputDeletions(compact.compaction.getEdit());
        int level = compact.compaction.getLevel();
        for (FileMetaData output : compact.outputs) {
            compact.compaction.getEdit().addFile(level + 1, output);
            this.pendingOutputs.remove(output.getNumber());
        }
        try {
            this.versions.logAndApply(compact.compaction.getEdit());
            this.deleteObsoleteFiles();
        }
        catch (IOException e) {
            for (FileMetaData output : compact.outputs) {
                File file = new File(this.databaseDir, Filename.tableFileName(output.getNumber()));
                file.delete();
            }
            compact.outputs.clear();
        }
    }

    int numberOfFilesInLevel(int level) {
        return this.versions.getCurrent().numberOfFilesInLevel(level);
    }

    public long[] getApproximateSizes(Range ... ranges) {
        Objects.requireNonNull(ranges, "ranges is null");
        long[] sizes = new long[ranges.length];
        for (int i = 0; i < ranges.length; ++i) {
            Range range = ranges[i];
            sizes[i] = this.getApproximateSizes(range);
        }
        return sizes;
    }

    public long getApproximateSizes(Range range) {
        Version v = this.versions.getCurrent();
        InternalKey startKey = new InternalKey(Slices.wrappedBuffer(range.start()), 0xFFFFFFFFFFFFFFL, ValueType.VALUE);
        InternalKey limitKey = new InternalKey(Slices.wrappedBuffer(range.limit()), 0xFFFFFFFFFFFFFFL, ValueType.VALUE);
        long startOffset = v.getApproximateOffsetOf(startKey);
        long limitOffset = v.getApproximateOffsetOf(limitKey);
        return limitOffset >= startOffset ? limitOffset - startOffset : 0L;
    }

    public long getMaxNextLevelOverlappingBytes() {
        return this.versions.getMaxNextLevelOverlappingBytes();
    }

    private WriteBatchImpl readWriteBatch(SliceInput record, int updateSize) throws IOException {
        WriteBatchImpl writeBatch = new WriteBatchImpl();
        int entries = 0;
        while (record.isReadable()) {
            Slice key;
            ++entries;
            ValueType valueType = ValueType.getValueTypeByPersistentId(record.readByte());
            if (valueType == ValueType.VALUE) {
                key = Slices.readLengthPrefixedBytes(record);
                Slice value = Slices.readLengthPrefixedBytes(record);
                writeBatch.put(key, value);
                continue;
            }
            if (valueType == ValueType.DELETION) {
                key = Slices.readLengthPrefixedBytes(record);
                writeBatch.delete(key);
                continue;
            }
            throw new IllegalStateException("Unexpected value type " + (Object)((Object)valueType));
        }
        if (entries != updateSize) {
            throw new IOException(String.format("Expected %d entries in log record but found %s entries", updateSize, entries));
        }
        return writeBatch;
    }

    private Slice writeWriteBatch(WriteBatchImpl updates, long sequenceBegin) {
        Slice record = Slices.allocate(12 + updates.getApproximateSize());
        final SliceOutput sliceOutput = record.output();
        sliceOutput.writeLong(sequenceBegin);
        sliceOutput.writeInt(updates.size());
        updates.forEach(new WriteBatchImpl.Handler(){

            @Override
            public void put(Slice key, Slice value) {
                sliceOutput.writeByte(ValueType.VALUE.getPersistentId());
                Slices.writeLengthPrefixedBytes(sliceOutput, key);
                Slices.writeLengthPrefixedBytes(sliceOutput, value);
            }

            @Override
            public void delete(Slice key) {
                sliceOutput.writeByte(ValueType.DELETION.getPersistentId());
                Slices.writeLengthPrefixedBytes(sliceOutput, key);
            }
        });
        return record.slice(0, sliceOutput.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendCompactions() throws InterruptedException {
        this.compactionExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = DbImpl.this.suspensionMutex;
                    synchronized (object) {
                        DbImpl.this.suspensionCounter++;
                        DbImpl.this.suspensionMutex.notifyAll();
                        while (DbImpl.this.suspensionCounter > 0 && !DbImpl.this.compactionExecutor.isShutdown()) {
                            DbImpl.this.suspensionMutex.wait(500L);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        Object object = this.suspensionMutex;
        synchronized (object) {
            while (this.suspensionCounter < 1) {
                this.suspensionMutex.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeCompactions() {
        Object object = this.suspensionMutex;
        synchronized (object) {
            --this.suspensionCounter;
            this.suspensionMutex.notifyAll();
        }
    }

    public void compactRange(byte[] begin, byte[] end) throws DBException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public static class BackgroundProcessingException
    extends DBException {
        public BackgroundProcessingException(Throwable cause) {
            super(cause);
        }
    }

    public static class DatabaseShutdownException
    extends DBException {
        public DatabaseShutdownException() {
        }

        public DatabaseShutdownException(String message) {
            super(message);
        }
    }

    private static class InsertIntoHandler
    implements WriteBatchImpl.Handler {
        private long sequence;
        private final MemTable memTable;

        public InsertIntoHandler(MemTable memTable, long sequenceBegin) {
            this.memTable = memTable;
            this.sequence = sequenceBegin;
        }

        @Override
        public void put(Slice key, Slice value) {
            this.memTable.add(this.sequence++, ValueType.VALUE, key, value);
        }

        @Override
        public void delete(Slice key) {
            this.memTable.add(this.sequence++, ValueType.DELETION, key, Slices.EMPTY_SLICE);
        }
    }

    private static class ManualCompaction {
        private final int level;
        private final Slice begin;
        private final Slice end;

        private ManualCompaction(int level, Slice begin, Slice end) {
            this.level = level;
            this.begin = begin;
            this.end = end;
        }
    }

    private static class CompactionState {
        private final Compaction compaction;
        private final List<FileMetaData> outputs = new ArrayList<FileMetaData>();
        private long smallestSnapshot;
        private FileChannel outfile;
        private TableBuilder builder;
        private long currentFileNumber;
        private long currentFileSize;
        private InternalKey currentSmallest;
        private InternalKey currentLargest;
        private long totalBytes;

        private CompactionState(Compaction compaction) {
            this.compaction = compaction;
        }

        public Compaction getCompaction() {
            return this.compaction;
        }
    }
}

