/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.log.Logger;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorMetadata;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.transaction.IsolationLevel;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.pulsar.sql.presto.PulsarConnectorCache;
import org.apache.pulsar.sql.presto.PulsarConnectorConfig;
import org.apache.pulsar.sql.presto.PulsarMetadata;
import org.apache.pulsar.sql.presto.PulsarRecordSetProvider;
import org.apache.pulsar.sql.presto.PulsarSplitManager;
import org.apache.pulsar.sql.presto.PulsarTransactionHandle;

public class PulsarConnector
implements Connector {
    private static final Logger log = Logger.get(PulsarConnector.class);
    private final LifeCycleManager lifeCycleManager;
    private final PulsarMetadata metadata;
    private final PulsarSplitManager splitManager;
    private final PulsarRecordSetProvider recordSetProvider;
    private final PulsarConnectorConfig pulsarConnectorConfig;

    @Inject
    public PulsarConnector(LifeCycleManager lifeCycleManager, PulsarMetadata metadata, PulsarSplitManager splitManager, PulsarRecordSetProvider recordSetProvider, PulsarConnectorConfig pulsarConnectorConfig) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.recordSetProvider = Objects.requireNonNull(recordSetProvider, "recordSetProvider is null");
        this.pulsarConnectorConfig = Objects.requireNonNull(pulsarConnectorConfig, "pulsarConnectorConfig is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_COMMITTED, (IsolationLevel)isolationLevel);
        return PulsarTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return new ClassLoaderSafeConnectorMetadata((ConnectorMetadata)this.metadata, this.getClass().getClassLoader());
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorRecordSetProvider getRecordSetProvider() {
        return this.recordSetProvider;
    }

    public void initConnectorCache() throws Exception {
        PulsarConnectorCache.getConnectorCache(this.pulsarConnectorConfig);
    }

    public final void shutdown() {
        try {
            this.pulsarConnectorConfig.close();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Failed to close pulsar connector");
        }
        try {
            this.lifeCycleManager.stop();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error shutting down connector");
        }
    }
}

