/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum BACnetAccessEvent {
  NONE((int) 0),
  GRANTED((int) 1),
  MUSTER((int) 2),
  PASSBACK_DETECTED((int) 3),
  DURESS((int) 4),
  TRACE((int) 5),
  LOCKOUT_MAX_ATTEMPTS((int) 6),
  LOCKOUT_OTHER((int) 7),
  LOCKOUT_RELINQUISHED((int) 8),
  LOCKED_BY_HIGHER_PRIORITY((int) 9),
  OUT_OF_SERVICE((int) 10),
  OUT_OF_SERVICE_RELINQUISHED((int) 11),
  ACCOMPANIMENT_BY((int) 12),
  AUTHENTICATION_FACTOR_READ((int) 13),
  AUTHORIZATION_DELAYED((int) 14),
  VERIFICATION_REQUIRED((int) 15),
  NO_ENTRY_AFTER_GRANTED((int) 16),
  DENIED_DENY_ALL((int) 128),
  DENIED_UNKNOWN_CREDENTIAL((int) 129),
  DENIED_AUTHENTICATION_UNAVAILABLE((int) 130),
  DENIED_AUTHENTICATION_FACTOR_TIMEOUT((int) 131),
  DENIED_INCORRECT_AUTHENTICATION_FACTOR((int) 132),
  DENIED_ZONE_NO_ACCESS_RIGHTS((int) 133),
  DENIED_POINT_NO_ACCESS_RIGHTS((int) 134),
  DENIED_NO_ACCESS_RIGHTS((int) 135),
  DENIED_OUT_OF_TIME_RANGE((int) 136),
  DENIED_THREAT_LEVEL((int) 137),
  DENIED_PASSBACK((int) 138),
  DENIED_UNEXPECTED_LOCATION_USAGE((int) 139),
  DENIED_MAX_ATTEMPTS((int) 140),
  DENIED_LOWER_OCCUPANCY_LIMIT((int) 141),
  DENIED_UPPER_OCCUPANCY_LIMIT((int) 142),
  DENIED_AUTHENTICATION_FACTOR_LOST((int) 143),
  DENIED_AUTHENTICATION_FACTOR_STOLEN((int) 144),
  DENIED_AUTHENTICATION_FACTOR_DAMAGED((int) 145),
  DENIED_AUTHENTICATION_FACTOR_DESTROYED((int) 146),
  DENIED_AUTHENTICATION_FACTOR_DISABLED((int) 147),
  DENIED_AUTHENTICATION_FACTOR_ERROR((int) 148),
  DENIED_CREDENTIAL_UNASSIGNED((int) 149),
  DENIED_CREDENTIAL_NOT_PROVISIONED((int) 150),
  DENIED_CREDENTIAL_NOT_YET_ACTIVE((int) 151),
  DENIED_CREDENTIAL_EXPIRED((int) 152),
  DENIED_CREDENTIAL_MANUAL_DISABLE((int) 153),
  DENIED_CREDENTIAL_LOCKOUT((int) 154),
  DENIED_CREDENTIAL_MAX_DAYS((int) 155),
  DENIED_CREDENTIAL_MAX_USES((int) 156),
  DENIED_CREDENTIAL_INACTIVITY((int) 157),
  DENIED_CREDENTIAL_DISABLED((int) 158),
  DENIED_NO_ACCOMPANIMENT((int) 159),
  DENIED_INCORRECT_ACCOMPANIMENT((int) 160),
  DENIED_LOCKOUT((int) 161),
  DENIED_VERIFICATION_FAILED((int) 162),
  DENIED_VERIFICATION_TIMEOUT((int) 163),
  DENIED_OTHER((int) 164),
  VENDOR_PROPRIETARY_VALUE((int) 0XFFFF);
  private static final Map<Integer, BACnetAccessEvent> map;

  static {
    map = new HashMap<>();
    for (BACnetAccessEvent value : BACnetAccessEvent.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private final int value;

  BACnetAccessEvent(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static BACnetAccessEvent enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
