/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.stats.CounterStatsAggregator;
import org.apache.hadoop.hive.ql.stats.StatsAggregator;
import org.apache.hadoop.hive.ql.stats.StatsCollectionTaskIndependent;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TezCounters;

public class CounterStatsAggregatorTez
implements StatsAggregator,
StatsCollectionTaskIndependent {
    private static final Log LOG = LogFactory.getLog((String)CounterStatsAggregatorTez.class.getName());
    private TezCounters counters;
    private final CounterStatsAggregator mrAggregator = new CounterStatsAggregator();
    private boolean delegate;

    @Override
    public boolean connect(Configuration hconf, Task sourceTask) {
        if (!(sourceTask instanceof TezTask)) {
            this.delegate = true;
            return this.mrAggregator.connect(hconf, sourceTask);
        }
        this.counters = ((TezTask)sourceTask).getTezCounters();
        return this.counters != null;
    }

    @Override
    public String aggregateStats(String keyPrefix, String statType) {
        String result;
        if (this.delegate) {
            result = this.mrAggregator.aggregateStats(keyPrefix, statType);
        } else {
            long value = 0L;
            for (String groupName : this.counters.getGroupNames()) {
                if (!groupName.startsWith(keyPrefix)) continue;
                value += ((CounterGroup)this.counters.getGroup(groupName)).findCounter(statType).getValue();
            }
            result = String.valueOf(value);
        }
        LOG.info((Object)("Counter based stats for (" + keyPrefix + ") are: " + result));
        return result;
    }

    @Override
    public boolean closeConnection() {
        return true;
    }

    @Override
    public boolean cleanUp(String keyPrefix) {
        return true;
    }
}

