/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class ExprNodeFieldDesc
extends ExprNodeDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    ExprNodeDesc desc;
    String fieldName;
    Boolean isList;

    public ExprNodeFieldDesc() {
    }

    public ExprNodeFieldDesc(TypeInfo typeInfo, ExprNodeDesc desc, String fieldName, Boolean isList) {
        super(typeInfo);
        this.desc = desc;
        this.fieldName = fieldName;
        this.isList = isList;
    }

    @Override
    public List<ExprNodeDesc> getChildren() {
        ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>(2);
        children.add(this.desc);
        return children;
    }

    public ExprNodeDesc getDesc() {
        return this.desc;
    }

    public void setDesc(ExprNodeDesc desc) {
        this.desc = desc;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public Boolean getIsList() {
        return this.isList;
    }

    public void setIsList(Boolean isList) {
        this.isList = isList;
    }

    public String toString() {
        return this.desc.toString() + "." + this.fieldName;
    }

    @Override
    public String getExprString() {
        return this.desc.getExprString() + "." + this.fieldName;
    }

    @Override
    public List<String> getCols() {
        List<String> colList = new ArrayList<String>();
        if (this.desc != null) {
            colList = Utilities.mergeUniqElems(colList, this.desc.getCols());
        }
        return colList;
    }

    @Override
    public ExprNodeDesc clone() {
        return new ExprNodeFieldDesc(this.typeInfo, this.desc.clone(), this.fieldName, this.isList);
    }

    @Override
    public boolean isSame(Object o) {
        if (!(o instanceof ExprNodeFieldDesc)) {
            return false;
        }
        ExprNodeFieldDesc dest = (ExprNodeFieldDesc)o;
        if (!this.typeInfo.equals((Object)dest.getTypeInfo())) {
            return false;
        }
        return this.fieldName.equals(dest.getFieldName()) && this.isList.equals(dest.getIsList()) && this.desc.isSame(dest.getDesc());
    }

    @Override
    public int hashCode() {
        int superHashCode = super.hashCode();
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.appendSuper(superHashCode);
        builder.append((Object)this.desc);
        builder.append((Object)this.fieldName);
        builder.append((Object)this.isList);
        return builder.toHashCode();
    }
}

