/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.optimizer;

import java.util.LinkedList;
import java.util.List;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POGlobalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperPlan;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperator;
import org.apache.pig.backend.hadoop.executionengine.util.AccumulatorOptimizerUtil;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

public class AccumulatorOptimizer
extends SparkOpPlanVisitor {
    public AccumulatorOptimizer(SparkOperPlan plan) {
        super(plan, (PlanWalker<SparkOperator, SparkOperPlan>)new DepthFirstWalker<SparkOperator, SparkOperPlan>(plan));
    }

    @Override
    public void visitSparkOp(SparkOperator sparkOperator) throws VisitorException {
        PhysicalPlan plan = sparkOperator.physicalPlan;
        List pos = plan.getRoots();
        if (pos == null || pos.size() == 0) {
            return;
        }
        LinkedList<POGlobalRearrange> glrs = PlanHelper.getPhysicalOperators(plan, POGlobalRearrange.class);
        for (POGlobalRearrange glr : glrs) {
            List<PhysicalOperator> successors = plan.getSuccessors(glr);
            AccumulatorOptimizerUtil.addAccumulator(plan, successors);
        }
    }
}

