/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.converter;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODistinct;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkPigContext;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkUtil;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.RDDConverter;
import org.apache.pig.data.Tuple;
import org.apache.spark.rdd.PairRDDFunctions;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Function2;
import scala.Tuple2;
import scala.runtime.AbstractFunction1;
import scala.runtime.AbstractFunction2;

public class DistinctConverter
implements RDDConverter<Tuple, Tuple, PODistinct> {
    private static final Log LOG = LogFactory.getLog(DistinctConverter.class);

    @Override
    public RDD<Tuple> convert(List<RDD<Tuple>> predecessors, PODistinct op) throws IOException {
        SparkUtil.assertPredecessorSize(predecessors, op, 1);
        RDD<Tuple> rdd = predecessors.get(0);
        RDD keyValRDD = rdd.map((Function1)new ToKeyValueFunction(), SparkUtil.getTuple2Manifest());
        PairRDDFunctions pairRDDFunctions = new PairRDDFunctions(keyValRDD, SparkUtil.getManifest(Tuple.class), SparkUtil.getManifest(Object.class), null);
        SparkPigContext.get();
        int parallelism = SparkPigContext.getParallelism(predecessors, op);
        return pairRDDFunctions.reduceByKey(SparkUtil.getPartitioner(op.getCustomPartitioner(), parallelism), (Function2)new MergeValuesFunction()).map((Function1)new ToValueFunction(), SparkUtil.getManifest(Tuple.class));
    }

    private static final class ToValueFunction
    extends AbstractFunction1<Tuple2<Tuple, Object>, Tuple>
    implements Serializable {
        private ToValueFunction() {
        }

        public Tuple apply(Tuple2<Tuple, Object> input) {
            return (Tuple)input._1;
        }
    }

    private static final class MergeValuesFunction
    extends AbstractFunction2<Object, Object, Object>
    implements Serializable {
        private MergeValuesFunction() {
        }

        public Object apply(Object arg0, Object arg1) {
            return null;
        }
    }

    private static final class ToKeyValueFunction
    extends AbstractFunction1<Tuple, Tuple2<Tuple, Object>>
    implements Serializable {
        private ToKeyValueFunction() {
        }

        public Tuple2<Tuple, Object> apply(Tuple t) {
            Tuple key = t;
            Object value = null;
            Tuple2 out = new Tuple2((Object)key, value);
            return out;
        }
    }
}

