/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.impl.logicalLayer.FrontendException;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public interface LoadPushDown {
    public List<OperatorSet> getFeatures();

    public RequiredFieldResponse pushProjection(RequiredFieldList var1) throws FrontendException;

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class RequiredFieldResponse {
        private boolean requiredFieldRequestHonored;

        public RequiredFieldResponse(boolean requiredFieldRequestHonored) {
            this.requiredFieldRequestHonored = requiredFieldRequestHonored;
        }

        public boolean getRequiredFieldResponse() {
            return this.requiredFieldRequestHonored;
        }

        public void setRequiredFieldResponse(boolean honored) {
            this.requiredFieldRequestHonored = honored;
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class RequiredFieldList
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<RequiredField> fields = new ArrayList<RequiredField>();

        public RequiredFieldList(List<RequiredField> fields) {
            this.fields = fields;
        }

        public List<RequiredField> getFields() {
            return this.fields;
        }

        public RequiredFieldList() {
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            if (this.fields == null) {
                result.append("*");
            } else {
                result.append("[");
                for (int i = 0; i < this.fields.size(); ++i) {
                    result.append(this.fields.get(i));
                    if (i == this.fields.size() - 1) continue;
                    result.append(",");
                }
                result.append("]");
            }
            return result.toString();
        }

        public void add(RequiredField rf) {
            this.fields.add(rf);
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class RequiredField
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String alias;
        private int index;
        private List<RequiredField> subFields;
        private byte type;

        public RequiredField() {
        }

        public RequiredField(String alias, int index, List<RequiredField> subFields, byte type) {
            this.alias = alias;
            this.index = index;
            this.subFields = subFields;
            this.type = type;
        }

        public String getAlias() {
            return this.alias;
        }

        public int getIndex() {
            return this.index;
        }

        public List<RequiredField> getSubFields() {
            return this.subFields;
        }

        public void setSubFields(List<RequiredField> subFields) {
            this.subFields = subFields;
        }

        public byte getType() {
            return this.type;
        }

        public void setType(byte t) {
            this.type = t;
        }

        public void setIndex(int i) {
            this.index = i;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public String toString() {
            if (this.index != -1) {
                return "" + this.index;
            }
            if (this.alias != null) {
                return this.alias;
            }
            return "";
        }
    }

    public static enum OperatorSet {
        PROJECTION;

    }
}

