/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.plus.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.spark_project.jetty.plus.annotation.Injection;
import org.spark_project.jetty.util.log.Log;
import org.spark_project.jetty.util.log.Logger;

public class InjectionCollection {
    private static final Logger LOG = Log.getLogger(InjectionCollection.class);
    public static final String INJECTION_COLLECTION = "org.spark_project.jetty.injectionCollection";
    private final ConcurrentMap<String, Set<Injection>> _injectionMap = new ConcurrentHashMap<String, Set<Injection>>();

    public void add(Injection injection) {
        Set tmp;
        if (injection == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring null Injection", new Object[0]);
            }
            return;
        }
        String name2 = injection.getTargetClass().getName();
        Set<Injection> injections = (CopyOnWriteArraySet<Injection>)this._injectionMap.get(name2);
        if (injections == null && (tmp = (Set)this._injectionMap.putIfAbsent(name2, injections = new CopyOnWriteArraySet<Injection>())) != null) {
            injections = tmp;
        }
        boolean added = injections.add(injection);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding injection for class={} on {} added={}", name2, injection.getTarget().getName(), added);
        }
    }

    public Set<Injection> getInjections(String className) {
        if (className == null) {
            return null;
        }
        return (Set)this._injectionMap.get(className);
    }

    public Injection getInjection(String jndiName, Class<?> clazz, Field field) {
        if (field == null || clazz == null) {
            return null;
        }
        Set<Injection> injections = this.getInjections(clazz.getName());
        if (injections == null) {
            return null;
        }
        Iterator<Injection> itor = injections.iterator();
        Injection injection = null;
        while (itor.hasNext() && injection == null) {
            Injection i = itor.next();
            if (!i.isField() || !field.getName().equals(i.getTarget().getName())) continue;
            injection = i;
        }
        return injection;
    }

    public Injection getInjection(String jndiName, Class<?> clazz, Method method, Class<?> paramClass) {
        if (clazz == null || method == null || paramClass == null) {
            return null;
        }
        Set<Injection> injections = this.getInjections(clazz.getName());
        if (injections == null) {
            return null;
        }
        Iterator<Injection> itor = injections.iterator();
        Injection injection = null;
        while (itor.hasNext() && injection == null) {
            Injection i = itor.next();
            if (!i.isMethod() || !i.getTarget().getName().equals(method.getName()) || !paramClass.equals(i.getParamClass())) continue;
            injection = i;
        }
        return injection;
    }

    public void inject(Object injectable) {
        if (injectable == null) {
            return;
        }
        for (Class<?> clazz = injectable.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Set injections = (Set)this._injectionMap.get(clazz.getName());
            if (injections == null) continue;
            for (Injection i : injections) {
                i.inject(injectable);
            }
        }
    }
}

