/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.tez.dag.app.dag.event.DAGEventSchedulerUpdate;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezVertexID;

public abstract class DAGScheduler {
    Map<TezVertexID, VertexInfo> vertexInfo = null;

    public void addVertexConcurrencyLimit(TezVertexID vId, int concurrency) {
        if (this.vertexInfo == null) {
            this.vertexInfo = new HashMap<TezVertexID, VertexInfo>();
        }
        if (concurrency > 0) {
            this.vertexInfo.put(vId, new VertexInfo(concurrency));
        }
    }

    public void scheduleTask(DAGEventSchedulerUpdate event) {
        VertexInfo vInfo = null;
        if (this.vertexInfo != null) {
            vInfo = this.vertexInfo.get(event.getAttempt().getID().getTaskID().getVertexID());
        }
        this.scheduleTaskWithLimit(event, vInfo);
    }

    private void scheduleTaskWithLimit(DAGEventSchedulerUpdate event, VertexInfo vInfo) {
        if (vInfo != null) {
            if (vInfo.concurrency >= vInfo.concurrencyLimit) {
                vInfo.pendingAttempts.put(event.getAttempt().getID(), event);
                return;
            }
            ++vInfo.concurrency;
        }
        this.scheduleTaskEx(event);
    }

    public void taskCompleted(DAGEventSchedulerUpdate event) {
        VertexInfo vInfo;
        this.taskCompletedEx(event);
        if (this.vertexInfo != null && (vInfo = this.vertexInfo.get(event.getAttempt().getID().getTaskID().getVertexID())) != null && vInfo.pendingAttempts.remove(event.getAttempt().getID()) == null) {
            --vInfo.concurrency;
            if (!vInfo.pendingAttempts.isEmpty()) {
                Iterator<DAGEventSchedulerUpdate> i = vInfo.pendingAttempts.values().iterator();
                DAGEventSchedulerUpdate nextTaskAttempt = i.next();
                i.remove();
                this.scheduleTaskWithLimit(nextTaskAttempt, vInfo);
            }
        }
    }

    public abstract void scheduleTaskEx(DAGEventSchedulerUpdate var1);

    public abstract void taskCompletedEx(DAGEventSchedulerUpdate var1);

    private static class VertexInfo {
        int concurrencyLimit;
        int concurrency;
        Map<TezTaskAttemptID, DAGEventSchedulerUpdate> pendingAttempts = new LinkedHashMap<TezTaskAttemptID, DAGEventSchedulerUpdate>();

        VertexInfo(int limit) {
            this.concurrencyLimit = limit;
        }
    }
}

