/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.net.NetUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestWebHdfsContentLength {
    private static ServerSocket listenSocket;
    private static String bindAddr;
    private static Path p;
    private static FileSystem fs;
    private static final Pattern contentLengthPattern;
    private static String errResponse;
    private static String redirectResponse;
    private static ExecutorService executor;
    @Rule
    public Timeout timeout = new Timeout(30000);

    @BeforeClass
    public static void setup() throws IOException {
        listenSocket = new ServerSocket();
        listenSocket.bind(null);
        bindAddr = NetUtils.getHostPortString((InetSocketAddress)((InetSocketAddress)listenSocket.getLocalSocketAddress()));
        redirectResponse = "HTTP/1.1 307 Redirect\r\nLocation: http://" + bindAddr + "/path\r\n" + "Connection: close\r\n\r\n";
        p = new Path("webhdfs://" + bindAddr + "/path");
        fs = p.getFileSystem(new Configuration());
        executor = Executors.newSingleThreadExecutor();
    }

    @AfterClass
    public static void teardown() throws IOException {
        if (listenSocket != null) {
            listenSocket.close();
        }
        if (executor != null) {
            executor.shutdownNow();
        }
    }

    @Test
    public void testGetOp() throws Exception {
        Future<String> future = this.contentLengthFuture(errResponse);
        try {
            fs.getFileStatus(p);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertEquals(null, (Object)this.getContentLength(future));
    }

    @Test
    public void testGetOpWithRedirect() {
        Future<String> future1 = this.contentLengthFuture(redirectResponse);
        Future<String> future2 = this.contentLengthFuture(errResponse);
        Future<String> future3 = this.contentLengthFuture(errResponse);
        try {
            fs.open(p).read();
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertEquals(null, (Object)this.getContentLength(future1));
        Assert.assertEquals(null, (Object)this.getContentLength(future2));
        Assert.assertEquals(null, (Object)this.getContentLength(future3));
    }

    @Test
    public void testPutOp() {
        Future<String> future = this.contentLengthFuture(errResponse);
        try {
            fs.mkdirs(p);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"0", (Object)this.getContentLength(future));
    }

    @Test
    public void testPutOpWithRedirect() {
        Future<String> future1 = this.contentLengthFuture(redirectResponse);
        Future<String> future2 = this.contentLengthFuture(errResponse);
        try {
            FSDataOutputStream os = fs.create(p);
            os.write(new byte[]{0});
            os.close();
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"0", (Object)this.getContentLength(future1));
        Assert.assertEquals((Object)"chunked", (Object)this.getContentLength(future2));
    }

    @Test
    public void testPostOp() {
        Future<String> future = this.contentLengthFuture(errResponse);
        try {
            fs.concat(p, new Path[]{p});
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"0", (Object)this.getContentLength(future));
    }

    @Test
    public void testPostOpWithRedirect() {
        Future<String> future1 = this.contentLengthFuture(redirectResponse);
        Future<String> future2 = this.contentLengthFuture(errResponse);
        try {
            FSDataOutputStream os = fs.append(p);
            os.write(new byte[]{0});
            os.close();
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"0", (Object)this.getContentLength(future1));
        Assert.assertEquals((Object)"chunked", (Object)this.getContentLength(future2));
    }

    @Test
    public void testDelete() {
        Future<String> future = this.contentLengthFuture(errResponse);
        try {
            fs.delete(p, false);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertEquals(null, (Object)this.getContentLength(future));
    }

    private String getContentLength(Future<String> future) {
        String request = null;
        try {
            request = future.get(2L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
        Matcher matcher = contentLengthPattern.matcher(request);
        return matcher.find() ? matcher.group(2) : null;
    }

    private Future<String> contentLengthFuture(final String response) {
        return executor.submit(new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws Exception {
                client.setSoTimeout(2000);
                try (Socket client = listenSocket.accept();){
                    int n;
                    client.getOutputStream().write(response.getBytes());
                    client.shutdownOutput();
                    byte[] buf = new byte[4096];
                    StringBuilder sb = new StringBuilder();
                    while ((n = client.getInputStream().read(buf)) > 0) {
                        sb.append(new String(buf, 0, n, "UTF-8"));
                    }
                    String string = sb.toString();
                    return string;
                }
            }
        });
    }

    static {
        contentLengthPattern = Pattern.compile("^(Content-Length|Transfer-Encoding):\\s*(.*)", 8);
        errResponse = "HTTP/1.1 500 Boom\r\nContent-Length: 0\r\nConnection: close\r\n\r\n";
    }
}

