/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.impl.util.GroupingSpillable;
import org.apache.pig.impl.util.Spillable;

public class SpillableMemoryManager
implements NotificationListener {
    private static final Log log = LogFactory.getLog(SpillableMemoryManager.class);
    private static final int UNUSED_MEMORY_THRESHOLD_DEFAULT = 367001600;
    private static final float MEMORY_THRESHOLD_FRACTION_DEFAULT = 0.7f;
    private static final float COLLECTION_THRESHOLD_FRACTION_DEFAULT = 0.7f;
    private LinkedList<WeakReference<Spillable>> spillables = new LinkedList();
    private LinkedList<SpillablePtr> spillablesSR = null;
    private Object spillLock = new Object();
    private static long gcActivationSize = 40000000L;
    private static long spillFileSizeThreshold = 5000000L;
    private long accumulatedFreeSize = 0L;
    private long memoryThresholdSize = 0L;
    private long collectionThresholdSize = 0L;
    private boolean firstUsageThreshExceededLogged = false;
    private boolean firstCollectionThreshExceededLogged = false;
    private float extraGCThresholdFraction = 0.05f;
    private long extraGCSpillSizeThreshold = 0L;
    private volatile boolean blockRegisterOnSpill = false;
    private MemoryPoolMXBean tenuredHeap;
    private static final SpillableMemoryManager manager = new SpillableMemoryManager();

    public static void staticDataCleanup() {
        SpillableMemoryManager.manager.spillables.clear();
        SpillableMemoryManager.manager.accumulatedFreeSize = 0L;
    }

    private SpillableMemoryManager() {
        ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).addNotificationListener(this, null, null);
        List<MemoryPoolMXBean> mpbeans = ManagementFactory.getMemoryPoolMXBeans();
        long totalSize = 0L;
        for (MemoryPoolMXBean pool : mpbeans) {
            log.debug((Object)("Found heap (" + pool.getName() + ") of type " + (Object)((Object)pool.getType())));
            if (pool.getType() != MemoryType.HEAP) continue;
            long size = pool.getUsage().getMax();
            totalSize += size;
            if (!pool.isUsageThresholdSupported()) continue;
            this.tenuredHeap = pool;
        }
        this.extraGCSpillSizeThreshold = (long)((float)totalSize * this.extraGCThresholdFraction);
        if (this.tenuredHeap == null) {
            throw new RuntimeException("Couldn't find heap");
        }
        this.configureMemoryThresholds(0.7f, 0.7f, 367001600L);
    }

    private void configureMemoryThresholds(float memoryThresholdFraction, float collectionMemoryThresholdFraction, long unusedMemoryThreshold) {
        long tenuredHeapSize = this.tenuredHeap.getUsage().getMax();
        this.memoryThresholdSize = (long)((float)tenuredHeapSize * memoryThresholdFraction);
        this.collectionThresholdSize = (long)((float)tenuredHeapSize * collectionMemoryThresholdFraction);
        if (unusedMemoryThreshold > 0L) {
            long unusedThreshold = tenuredHeapSize - unusedMemoryThreshold;
            this.memoryThresholdSize = Math.max(this.memoryThresholdSize, unusedThreshold);
            this.collectionThresholdSize = Math.max(this.collectionThresholdSize, unusedThreshold);
        }
        this.tenuredHeap.setCollectionUsageThreshold(this.collectionThresholdSize);
        this.tenuredHeap.setUsageThreshold(this.memoryThresholdSize);
        log.info((Object)("Selected heap (" + this.tenuredHeap.getName() + ") of size " + tenuredHeapSize + " to monitor. collectionUsageThreshold = " + this.tenuredHeap.getCollectionUsageThreshold() + ", usageThreshold = " + this.tenuredHeap.getUsageThreshold()));
    }

    public static SpillableMemoryManager getInstance() {
        return manager;
    }

    public void configure(Configuration conf) {
        spillFileSizeThreshold = conf.getLong("pig.spill.size.threshold", spillFileSizeThreshold);
        gcActivationSize = conf.getLong("pig.spill.gc.activation.size", gcActivationSize);
        float memoryThresholdFraction = conf.getFloat("pig.spill.memory.usage.threshold.fraction", 0.7f);
        float collectionThresholdFraction = conf.getFloat("pig.spill.collection.threshold.fraction", 0.7f);
        long unusedMemoryThreshold = conf.getLong("pig.spill.unused.memory.threshold.size", 367001600L);
        this.configureMemoryThresholds(memoryThresholdFraction, collectionThresholdFraction, unusedMemoryThreshold);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(Notification n, Object o) {
        String msg;
        CompositeData cd = (CompositeData)n.getUserData();
        MemoryNotificationInfo info = MemoryNotificationInfo.from(cd);
        long toFree = 0L;
        if (n.getType().equals("java.management.memory.threshold.exceeded")) {
            toFree = info.getUsage().getUsed() - this.memoryThresholdSize + (long)((double)this.memoryThresholdSize * 0.5);
            msg = "memory handler call- Usage threshold " + info.getUsage() + ", toFree = " + toFree;
            if (!this.firstUsageThreshExceededLogged) {
                log.info((Object)("first " + msg));
                this.firstUsageThreshExceededLogged = true;
            } else {
                log.debug((Object)msg);
            }
        } else {
            toFree = info.getUsage().getUsed() - this.collectionThresholdSize + (long)((double)this.collectionThresholdSize * 0.5);
            msg = "memory handler call - Collection threshold " + info.getUsage() + ", toFree = " + toFree;
            if (!this.firstCollectionThreshExceededLogged) {
                log.info((Object)("first " + msg));
                this.firstCollectionThreshExceededLogged = true;
            } else {
                log.debug((Object)msg);
            }
        }
        if (toFree < 0L) {
            log.debug((Object)"low memory handler returning because there is nothing to free");
            return;
        }
        Object object = this.spillLock;
        synchronized (object) {
            LinkedList<WeakReference<Spillable>> linkedList = this.spillables;
            synchronized (linkedList) {
                this.spillablesSR = new LinkedList();
                Iterator i = this.spillables.iterator();
                while (i.hasNext()) {
                    Spillable s = (Spillable)((WeakReference)i.next()).get();
                    if (s == null) {
                        i.remove();
                        continue;
                    }
                    this.spillablesSR.add(new SpillablePtr(s, s.getMemorySize()));
                }
                log.debug((Object)("Spillables list size: " + this.spillablesSR.size()));
                Collections.sort(this.spillablesSR, new Comparator<SpillablePtr>(){

                    @Override
                    public int compare(SpillablePtr o1Ref, SpillablePtr o2Ref) {
                        long o2Size;
                        long o1Size = o1Ref.getMemorySize();
                        if (o1Size == (o2Size = o2Ref.getMemorySize())) {
                            return 0;
                        }
                        if (o1Size < o2Size) {
                            return 1;
                        }
                        return -1;
                    }
                });
                this.blockRegisterOnSpill = true;
            }
            try {
                long estimatedFreed = 0L;
                int numObjSpilled = 0;
                boolean invokeGC = false;
                boolean extraGCCalled = false;
                boolean isGroupingSpillable = false;
                Iterator i = this.spillablesSR.iterator();
                while (i.hasNext()) {
                    long numSpilled;
                    SpillablePtr sPtr = (SpillablePtr)i.next();
                    Spillable s = sPtr.get();
                    if (s == null) {
                        i.remove();
                        continue;
                    }
                    long toBeFreed = sPtr.getMemorySize();
                    log.debug((Object)("Memorysize = " + toBeFreed + ", spillFilesizethreshold = " + spillFileSizeThreshold + ", gcactivationsize = " + gcActivationSize));
                    if (toBeFreed < spillFileSizeThreshold) {
                        log.debug((Object)"spilling small files - getting out of memory handler");
                        break;
                    }
                    isGroupingSpillable = s instanceof GroupingSpillable;
                    if (!extraGCCalled && this.extraGCSpillSizeThreshold != 0L && toBeFreed > this.extraGCSpillSizeThreshold && !isGroupingSpillable && n.getType().equals("java.management.memory.threshold.exceeded")) {
                        log.debug((Object)("Single spillable has size " + toBeFreed + "bytes. Calling extra gc()"));
                        s = null;
                        System.gc();
                        extraGCCalled = true;
                        s = sPtr.get();
                        if (s == null) {
                            i.remove();
                            this.accumulatedFreeSize = 0L;
                            invokeGC = false;
                            continue;
                        }
                    }
                    this.blockRegisterOnSpill = !isGroupingSpillable;
                    try {
                        numSpilled = s.spill();
                    }
                    finally {
                        this.blockRegisterOnSpill = true;
                    }
                    if (numSpilled > 0L) {
                        ++numObjSpilled;
                        estimatedFreed += toBeFreed;
                        this.accumulatedFreeSize += toBeFreed;
                    }
                    if (this.accumulatedFreeSize > gcActivationSize) {
                        invokeGC = true;
                    }
                    if (estimatedFreed <= toFree) continue;
                    log.debug((Object)"Freed enough space - getting out of memory handler");
                    invokeGC = true;
                    break;
                }
                this.spillablesSR = null;
                if (invokeGC) {
                    System.gc();
                    this.accumulatedFreeSize = 0L;
                }
                if (estimatedFreed > 0L) {
                    String msg2 = "Spilled an estimate of " + estimatedFreed + " bytes from " + numObjSpilled + " objects. " + info.getUsage();
                    log.info((Object)msg2);
                }
            }
            finally {
                this.blockRegisterOnSpill = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSpillables() {
        LinkedList<WeakReference<Spillable>> linkedList = this.spillables;
        synchronized (linkedList) {
            Iterator i = this.spillables.iterator();
            while (i.hasNext()) {
                Spillable s = (Spillable)((WeakReference)i.next()).get();
                if (s != null) continue;
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSpillable(Spillable s) {
        LinkedList<WeakReference<Spillable>> linkedList = this.spillables;
        synchronized (linkedList) {
            WeakReference<Spillable> first = this.spillables.peek();
            while (first != null && first.get() == null) {
                this.spillables.remove();
                first = this.spillables.peek();
            }
            if (this.blockRegisterOnSpill) {
                try {
                    int i;
                    for (i = 6000; i > 0 && this.blockRegisterOnSpill; --i) {
                        Thread.sleep(50L);
                    }
                    if (i == 0) {
                        log.warn((Object)"Spill took more than 5 mins. This needs investigation");
                    }
                }
                catch (InterruptedException e) {
                    log.warn((Object)"Interrupted exception in registerSpillable while blocked on spill", (Throwable)e);
                }
                this.blockRegisterOnSpill = false;
            }
            this.spillables.add(new WeakReference<Spillable>(s));
        }
    }

    private static class SpillablePtr {
        private WeakReference<Spillable> spillable;
        private long size;

        public SpillablePtr(Spillable p, long s) {
            this.spillable = new WeakReference<Spillable>(p);
            this.size = s;
        }

        public Spillable get() {
            return (Spillable)this.spillable.get();
        }

        public long getMemorySize() {
            return this.size;
        }
    }
}

