/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.runtime;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.VertexManagerPlugin;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.dag.api.event.VertexState;
import org.apache.tez.dag.api.event.VertexStateUpdate;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.events.VertexManagerEvent;

public class PartitionerDefinedVertexManager
extends VertexManagerPlugin {
    private static final Log LOG = LogFactory.getLog(PartitionerDefinedVertexManager.class);
    private volatile boolean parallelismSet;
    private int dynamicParallelism = -1;
    private int numConfiguredSources;
    private int numSources = -1;
    private volatile boolean configured;
    private volatile boolean started;
    private volatile boolean scheduled;

    public PartitionerDefinedVertexManager(VertexManagerPluginContext context) {
        super(context);
    }

    public void initialize() {
        this.getContext().vertexReconfigurationPlanned();
        this.parallelismSet = false;
        this.numConfiguredSources = 0;
        this.configured = false;
        this.started = false;
        this.numSources = this.getContext().getInputVertexEdgeProperties().size();
        Map edges = this.getContext().getInputVertexEdgeProperties();
        for (String entry : edges.keySet()) {
            this.getContext().registerForVertexStateUpdates(entry, EnumSet.of(VertexState.CONFIGURED));
        }
    }

    public synchronized void onVertexStateUpdated(VertexStateUpdate stateUpdate) throws Exception {
        ++this.numConfiguredSources;
        LOG.info((Object)("For vertex: " + this.getContext().getVertexName() + " Received configured signal from: " + stateUpdate.getVertexName() + " numConfiguredSources: " + this.numConfiguredSources + " needed: " + this.numSources));
        Preconditions.checkState((this.numConfiguredSources <= this.numSources ? 1 : 0) != 0, (Object)("Vertex: " + this.getContext().getVertexName()));
        if (this.numConfiguredSources == this.numSources) {
            this.configure();
        }
    }

    public void onRootVertexInitialized(String inputName, InputDescriptor inputDescriptor, List<Event> events) {
    }

    public void onSourceTaskCompleted(String srcVertexName, Integer srcTaskId) {
    }

    public void onVertexManagerEventReceived(VertexManagerEvent vmEvent) throws Exception {
        if (this.parallelismSet) {
            return;
        }
        if (vmEvent.getUserPayload().limit() != 4) {
            return;
        }
        this.dynamicParallelism = vmEvent.getUserPayload().getInt();
        int currentParallelism = this.getContext().getVertexNumTasks(this.getContext().getVertexName());
        if (this.dynamicParallelism != -1 && this.dynamicParallelism != currentParallelism) {
            LOG.info((Object)("Pig Partitioner Defined Vertex Manager: reset parallelism to " + this.dynamicParallelism + " from " + currentParallelism));
            HashMap edgeManagers = new HashMap();
            for (Map.Entry entry : this.getContext().getInputVertexEdgeProperties().entrySet()) {
                EdgeProperty edge = (EdgeProperty)entry.getValue();
                edge = EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)edge.getDataSourceType(), (EdgeProperty.SchedulingType)edge.getSchedulingType(), (OutputDescriptor)edge.getEdgeSource(), (InputDescriptor)edge.getEdgeDestination());
                edgeManagers.put(entry.getKey(), edge);
            }
            this.getContext().reconfigureVertex(this.dynamicParallelism, null, edgeManagers);
            this.parallelismSet = true;
            this.configure();
        }
    }

    private void configure() {
        if (this.parallelismSet && this.numSources == this.numConfiguredSources) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Done reconfiguring vertex " + this.getContext().getVertexName()));
            }
            this.getContext().doneReconfiguringVertex();
            this.configured = true;
            this.trySchedulingTasks();
        }
    }

    private synchronized void trySchedulingTasks() {
        if (this.configured && this.started && !this.scheduled) {
            LOG.info((Object)("Scheduling " + this.dynamicParallelism + " tasks for vertex " + this.getContext().getVertexName()));
            ArrayList tasksToStart = Lists.newArrayListWithCapacity((int)this.dynamicParallelism);
            for (int i = 0; i < this.dynamicParallelism; ++i) {
                tasksToStart.add(new VertexManagerPluginContext.TaskWithLocationHint(new Integer(i), null));
            }
            this.getContext().scheduleVertexTasks((List)tasksToStart);
            this.scheduled = true;
        }
    }

    public void onVertexStarted(Map<String, List<Integer>> completions) {
        this.started = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Vertex start received for " + this.getContext().getVertexName()));
        }
        this.trySchedulingTasks();
    }
}

