/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.converter;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.LazyOutputFormat;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigOutputFormat;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkUtil;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.RDDConverter;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.tools.pigstats.spark.SparkCounters;
import org.apache.pig.tools.pigstats.spark.SparkPigStatusReporter;
import org.apache.pig.tools.pigstats.spark.SparkStatsUtil;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.rdd.PairRDDFunctions;
import org.apache.spark.rdd.RDD;
import scala.Tuple2;

public class StoreConverter
implements RDDConverter<Tuple, Tuple2<Text, Tuple>, POStore> {
    private static final Log LOG = LogFactory.getLog(StoreConverter.class);
    private JobConf jobConf = null;

    public StoreConverter(JobConf jobConf) {
        this.jobConf = jobConf;
    }

    @Override
    public RDD<Tuple2<Text, Tuple>> convert(List<RDD<Tuple>> predecessors, POStore op) throws IOException {
        SparkUtil.assertPredecessorSize(predecessors, op, 1);
        RDD<Tuple> rdd = predecessors.get(0);
        SparkPigStatusReporter.getInstance().createCounter("MultiStoreCounters", SparkStatsUtil.getCounterName(op));
        JavaRDD rddPairs = rdd.toJavaRDD().map((Function)this.buildFromTupleFunction(op));
        PairRDDFunctions pairRDDFunctions = new PairRDDFunctions(rddPairs.rdd(), SparkUtil.getManifest(Text.class), SparkUtil.getManifest(Tuple.class), null);
        POStore poStore = StoreConverter.configureStorer(this.jobConf, op);
        if ("true".equalsIgnoreCase(this.jobConf.get("pig.output.lazy"))) {
            Job storeJob = new Job((Configuration)this.jobConf);
            LazyOutputFormat.setOutputFormatClass((Job)storeJob, PigOutputFormat.class);
            this.jobConf = (JobConf)storeJob.getConfiguration();
            this.jobConf.setOutputKeyClass(Text.class);
            this.jobConf.setOutputValueClass(Tuple.class);
            String fileName = poStore.getSFile().getFileName();
            Path filePath = new Path(fileName);
            FileOutputFormat.setOutputPath((JobConf)this.jobConf, (Path)filePath);
            pairRDDFunctions.saveAsNewAPIHadoopDataset((Configuration)this.jobConf);
        } else {
            pairRDDFunctions.saveAsNewAPIHadoopFile(poStore.getSFile().getFileName(), Text.class, Tuple.class, PigOutputFormat.class, (Configuration)this.jobConf);
        }
        RDD retRdd = rddPairs.rdd();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RDD lineage: " + retRdd.toDebugString()));
        }
        return retRdd;
    }

    private static POStore configureStorer(JobConf jobConf, PhysicalOperator op) throws IOException {
        ArrayList storeLocations = Lists.newArrayList();
        POStore poStore = (POStore)op;
        storeLocations.add(poStore);
        StoreFuncInterface sFunc = poStore.getStoreFunc();
        sFunc.setStoreLocation(poStore.getSFile().getFileName(), new Job((Configuration)jobConf));
        poStore.setInputs(null);
        poStore.setParentPlan(null);
        jobConf.set("pig.map.stores", ObjectSerializer.serialize(Lists.newArrayList()));
        jobConf.set("pig.reduce.stores", ObjectSerializer.serialize(storeLocations));
        return poStore;
    }

    private FromTupleFunction buildFromTupleFunction(POStore op) {
        FromTupleFunction ftf = new FromTupleFunction();
        boolean disableCounter = op.disableCounter();
        if (!op.isTmpStore() && !disableCounter) {
            ftf.setDisableCounter(disableCounter);
            ftf.setCounterGroupName("MultiStoreCounters");
            ftf.setCounterName(SparkStatsUtil.getCounterName(op));
            SparkPigStatusReporter counterReporter = SparkPigStatusReporter.getInstance();
            ftf.setSparkCounters(counterReporter.getCounters());
        }
        return ftf;
    }

    private static class FromTupleFunction
    implements Function<Tuple, Tuple2<Text, Tuple>> {
        private static Text EMPTY_TEXT = new Text();
        private String counterGroupName;
        private String counterName;
        private SparkCounters sparkCounters;
        private boolean disableCounter;

        private FromTupleFunction() {
        }

        public Tuple2<Text, Tuple> call(Tuple v1) {
            if (this.sparkCounters != null && !this.disableCounter) {
                this.sparkCounters.increment(this.counterGroupName, this.counterName, 1L);
            }
            return new Tuple2((Object)EMPTY_TEXT, (Object)v1);
        }

        public void setCounterGroupName(String counterGroupName) {
            this.counterGroupName = counterGroupName;
        }

        public void setCounterName(String counterName) {
            this.counterName = counterName;
        }

        public void setSparkCounters(SparkCounters sparkCounter) {
            this.sparkCounters = sparkCounter;
        }

        public void setDisableCounter(boolean disableCounter) {
            this.disableCounter = disableCounter;
        }
    }
}

