/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.converter;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.hadoop.executionengine.spark.PairFlatMapFunctionAdapter;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkUtil;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.IteratorTransform;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.RDDConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.POSampleSortSpark;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DefaultBagFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Tuple2;
import scala.runtime.AbstractFunction1;

public class SparkSampleSortConverter
implements RDDConverter<Tuple, Tuple, POSampleSortSpark> {
    private static final Log LOG = LogFactory.getLog(SparkSampleSortConverter.class);
    private static TupleFactory tf = TupleFactory.getInstance();
    private static BagFactory bf = DefaultBagFactory.getInstance();

    @Override
    public RDD<Tuple> convert(List<RDD<Tuple>> predecessors, POSampleSortSpark sortOperator) throws IOException {
        SparkUtil.assertPredecessorSize(predecessors, sortOperator, 1);
        RDD<Tuple> rdd = predecessors.get(0);
        RDD rddPair = rdd.map((Function1)new ToKeyValueFunction(), SparkUtil.getTuple2Manifest());
        JavaPairRDD r = new JavaPairRDD(rddPair, SparkUtil.getManifest(Tuple.class), SparkUtil.getManifest(Object.class));
        JavaPairRDD sorted = r.sortByKey(true);
        JavaPairRDD mapped = sorted.mapPartitionsToPair(SparkUtil.pairFlatMapFunction(new AggregateFunction()));
        JavaRDD groupByKey = mapped.groupByKey().map((Function)new ToValueFunction());
        return groupByKey.rdd();
    }

    private static class ToKeyValueFunction
    extends AbstractFunction1<Tuple, Tuple2<Tuple, Object>>
    implements Serializable {
        private ToKeyValueFunction() {
        }

        public Tuple2<Tuple, Object> apply(Tuple t) {
            if (LOG.isDebugEnabled()) {
                LOG.info((Object)("Sort ToKeyValueFunction in " + t));
            }
            Tuple key = t;
            Object value = null;
            Tuple2 out = new Tuple2((Object)key, value);
            if (LOG.isDebugEnabled()) {
                LOG.info((Object)("Sort ToKeyValueFunction out " + out));
            }
            return out;
        }
    }

    private static class ToValueFunction
    implements Function<Tuple2<String, Iterable<Tuple>>, Tuple> {
        private ToValueFunction() {
        }

        public Tuple call(Tuple2<String, Iterable<Tuple>> next) throws Exception {
            Tuple res = tf.newTuple();
            res.append(next._1());
            Iterator iter = ((Iterable)next._2()).iterator();
            DataBag bag = bf.newDefaultBag();
            while (iter.hasNext()) {
                bag.add((Tuple)iter.next());
            }
            res.append(bag);
            LOG.info((Object)("ToValueFunction1 out:" + res));
            return res;
        }
    }

    private static class AggregateFunction
    implements PairFlatMapFunctionAdapter<Iterator<Tuple2<Tuple, Object>>, String, Tuple>,
    Serializable {
        private AggregateFunction() {
        }

        @Override
        public Iterator<Tuple2<String, Tuple>> call(Iterator<Tuple2<Tuple, Object>> input) throws Exception {
            return new Tuple2TransformIterable(input).iterator();
        }

        private class Tuple2TransformIterable
        implements Iterable<Tuple2<String, Tuple>> {
            Iterator<Tuple2<Tuple, Object>> in;

            Tuple2TransformIterable(Iterator<Tuple2<Tuple, Object>> input) {
                this.in = input;
            }

            @Override
            public Iterator<Tuple2<String, Tuple>> iterator() {
                return new IteratorTransform<Tuple2<Tuple, Object>, Tuple2<String, Tuple>>(this.in){

                    @Override
                    protected Tuple2<String, Tuple> transform(Tuple2<Tuple, Object> next) {
                        LOG.info((Object)("AggregateFunction in:" + next._1()));
                        return new Tuple2((Object)"all", next._1());
                    }
                };
            }
        }
    }

    private static class MergeFunction
    implements Function2<Tuple, Tuple, Tuple>,
    Serializable {
        private MergeFunction() {
        }

        public Tuple call(Tuple v1, Tuple v2) {
            Tuple res = tf.newTuple();
            res.append(v1);
            res.append(v2);
            LOG.info((Object)("MergeFunction out:" + res));
            return res;
        }
    }
}

