/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.converter;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.spark.FlatMapFunctionAdapter;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkUtil;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.OutputConsumerIterator;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.RDDConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.POPoissonSampleSpark;
import org.apache.pig.data.Tuple;
import org.apache.spark.rdd.RDD;

public class PoissonSampleConverter
implements RDDConverter<Tuple, Tuple, POPoissonSampleSpark> {
    @Override
    public RDD<Tuple> convert(List<RDD<Tuple>> predecessors, POPoissonSampleSpark po) throws IOException {
        SparkUtil.assertPredecessorSize(predecessors, po, 1);
        RDD<Tuple> rdd = predecessors.get(0);
        PoissionSampleFunction poissionSampleFunction = new PoissionSampleFunction(po);
        return rdd.toJavaRDD().mapPartitions(SparkUtil.flatMapFunction(poissionSampleFunction), false).rdd();
    }

    private static class PoissionSampleFunction
    implements FlatMapFunctionAdapter<Iterator<Tuple>, Tuple> {
        private final POPoissonSampleSpark po;

        public PoissionSampleFunction(POPoissonSampleSpark po) {
            this.po = po;
        }

        @Override
        public Iterator<Tuple> call(Iterator<Tuple> tuples) {
            return new OutputConsumerIterator(tuples){

                @Override
                protected void attach(Tuple tuple) {
                    po.setInputs(null);
                    po.attachInput(tuple);
                }

                @Override
                protected Result getNextResult() throws ExecException {
                    return po.getNextTuple();
                }

                @Override
                protected void endOfInput() {
                    po.setEndOfInput(true);
                }
            };
        }
    }
}

