/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.io;

import java.io.DataOutput;
import java.io.IOException;
import java.rmi.server.UID;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Time;
import org.apache.pig.data.InterSedes;
import org.apache.pig.data.InterSedesFactory;
import org.apache.pig.data.Tuple;

public class InterRecordWriter
extends RecordWriter<WritableComparable, Tuple> {
    private static InterSedes sedes = InterSedesFactory.getInterSedesInstance();
    private byte[] syncMarker;
    private long lastSyncPos = -1L;
    private long syncMarkerInterval;
    private FSDataOutputStream out;

    public InterRecordWriter(FSDataOutputStream out, int syncMarkerLength, long syncMarkerInterval) {
        this.out = out;
        this.syncMarkerInterval = syncMarkerInterval;
        this.syncMarker = new byte[syncMarkerLength];
        try {
            MessageDigest digester = MessageDigest.getInstance("MD5");
            long time = Time.now();
            digester.update((new UID() + "@" + time).getBytes());
            byte[] generatedMarker = digester.digest();
            System.arraycopy(generatedMarker, 0, this.syncMarker, 0, syncMarkerLength);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public void close(TaskAttemptContext arg0) throws IOException, InterruptedException {
        this.out.close();
    }

    public void write(WritableComparable wc, Tuple t) throws IOException, InterruptedException {
        if (this.lastSyncPos == -1L || this.out.getPos() >= this.lastSyncPos + this.syncMarkerInterval) {
            this.out.write(this.syncMarker);
            this.lastSyncPos = this.out.getPos();
        }
        sedes.writeDatum((DataOutput)this.out, t);
    }
}

