/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.operator;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.bloom.Key;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POLocalRearrangeTez;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.bloom.BloomFilter;
import org.apache.pig.impl.io.NullableBytesWritable;
import org.apache.pig.impl.io.NullableIntWritable;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.io.PigNullableWritable;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.library.api.KeyValueWriter;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class POBuildBloomRearrangeTez
extends POLocalRearrangeTez {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(POBuildBloomRearrangeTez.class);
    public static final String DEFAULT_BLOOM_STRATEGY = "map";
    public static final int DEFAULT_NUM_BLOOM_FILTERS_REDUCE = 11;
    public static final int DEFAULT_NUM_BLOOM_HASH_FUNCTIONS = 3;
    public static final String DEFAULT_BLOOM_HASH_TYPE = "murmur";
    public static final int DEFAULT_BLOOM_VECTOR_SIZE_BYTES = 0x100000;
    private String bloomOutputKey;
    private boolean skipNullKeys = false;
    private boolean createBloomInMap;
    private int numBloomFilters;
    private int vectorSizeBytes;
    private int numHash;
    private int hashType;
    private transient BloomFilter[] bloomFilters;
    private transient KeyValueWriter bloomWriter;
    private transient PigNullableWritable nullKey;
    private transient NullableTuple[] bloomPartitions;

    public POBuildBloomRearrangeTez(POLocalRearrangeTez lr, boolean createBloomInMap, int numBloomFilters, int vectorSizeBytes, int numHash, int hashType) {
        super(lr);
        this.createBloomInMap = createBloomInMap;
        this.numBloomFilters = numBloomFilters;
        this.vectorSizeBytes = vectorSizeBytes;
        this.numHash = numHash;
        this.hashType = hashType;
    }

    public static int getNumBloomFilters(Configuration conf) {
        if (DEFAULT_BLOOM_STRATEGY.equals(conf.get("pig.bloomjoin.strategy", DEFAULT_BLOOM_STRATEGY))) {
            return conf.getInt("pig.bloomjoin.num.filters", 1);
        }
        return conf.getInt("pig.bloomjoin.num.filters", 11);
    }

    public void setSkipNullKeys(boolean skipNullKeys) {
        this.skipNullKeys = skipNullKeys;
    }

    public void setBloomOutputKey(String bloomOutputKey) {
        this.bloomOutputKey = bloomOutputKey;
    }

    @Override
    public boolean containsOutputKey(String key) {
        if (super.containsOutputKey(key)) {
            return true;
        }
        return this.bloomOutputKey.equals(key);
    }

    @Override
    public String[] getTezOutputs() {
        return new String[]{this.outputKey, this.bloomOutputKey};
    }

    @Override
    public void replaceOutput(String oldOutputKey, String newOutputKey) {
        if (oldOutputKey.equals(this.outputKey)) {
            this.outputKey = newOutputKey;
        } else if (oldOutputKey.equals(this.bloomOutputKey)) {
            this.bloomOutputKey = newOutputKey;
        }
    }

    @Override
    public void attachOutputs(Map<String, LogicalOutput> outputs, Configuration conf) throws ExecException {
        super.attachOutputs(outputs, conf);
        LogicalOutput output = outputs.get(this.bloomOutputKey);
        if (output == null) {
            throw new ExecException("Output to vertex " + this.bloomOutputKey + " is missing");
        }
        try {
            this.bloomWriter = (KeyValueWriter)output.getWriter();
            LOG.info((Object)("Attached output to vertex " + this.bloomOutputKey + " : output=" + output + ", writer=" + this.bloomWriter));
        }
        catch (Exception e) {
            throw new ExecException(e);
        }
        this.bloomFilters = new BloomFilter[this.numBloomFilters];
        this.bloomPartitions = new NullableTuple[this.numBloomFilters];
    }

    /*
     * Exception decompiling
     */
    @Override
    public Result getNextTuple() throws ExecException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addKeyToBloomFilter(Object key) throws ExecException {
        Key k = new Key(DataType.toBytes(key, this.keyType));
        if (this.bloomFilters.length == 1) {
            if (this.bloomFilters[0] == null) {
                this.bloomFilters[0] = new BloomFilter(this.vectorSizeBytes * 8, this.numHash, this.hashType);
            }
            this.bloomFilters[0].add(k);
        } else {
            int partition = (key.hashCode() & Integer.MAX_VALUE) % this.numBloomFilters;
            BloomFilter filter = this.bloomFilters[partition];
            if (filter == null) {
                this.bloomFilters[partition] = filter = new BloomFilter(this.vectorSizeBytes * 8, this.numHash, this.hashType);
            }
            filter.add(k);
        }
    }

    private void writeJoinKeyForBloom(Object keyObj, PigNullableWritable key) throws IOException {
        int partition = (keyObj.hashCode() & Integer.MAX_VALUE) % this.numBloomFilters;
        if (this.bloomPartitions[partition] == null) {
            Tuple tuple = mTupleFactory.newTuple(1);
            tuple.set(0, partition);
            this.bloomPartitions[partition] = new NullableTuple(tuple);
        }
        this.bloomWriter.write((Object)new NullableBytesWritable(new DataByteArray(DataType.toBytes(keyObj, this.keyType))), (Object)this.bloomPartitions[partition]);
    }

    private void writeBloomFilters() throws IOException {
        Tuple tuple = mTupleFactory.newTuple(1);
        NullableTuple nTuple = new NullableTuple(tuple);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.vectorSizeBytes + 64);
        for (int i = 0; i < this.bloomFilters.length; ++i) {
            if (this.bloomFilters[i] == null) continue;
            DataOutputStream dos = new DataOutputStream(baos);
            this.bloomFilters[i].write(dos);
            dos.flush();
            tuple.set(0, new DataByteArray(baos.toByteArray()));
            this.bloomWriter.write((Object)new NullableIntWritable(i), (Object)nTuple);
            baos.reset();
        }
    }

    @Override
    public POBuildBloomRearrangeTez clone() throws CloneNotSupportedException {
        return (POBuildBloomRearrangeTez)super.clone();
    }

    @Override
    public String name() {
        return this.getAliasString() + "BuildBloom Rearrange[" + DataType.findTypeName(this.resultType) + "]{" + DataType.findTypeName(this.keyType) + "}(" + this.mIsDistinct + ") - " + this.mKey.toString() + "\t->\t[ " + this.outputKey + ", " + this.bloomOutputKey + "]";
    }
}

