/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.optimizer;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POGlobalRearrange;
import org.apache.pig.backend.hadoop.executionengine.util.SecondaryKeyOptimizerUtil;

public class SparkSecondaryKeyOptimizerUtil
extends SecondaryKeyOptimizerUtil {
    private static Log log = LogFactory.getLog(SparkSecondaryKeyOptimizerUtil.class);

    @Override
    protected PhysicalOperator getCurrentNode(PhysicalOperator root, PhysicalPlan reducePlan) {
        PhysicalOperator currentNode = null;
        if (!(root instanceof POGlobalRearrange)) {
            log.debug((Object)"Expected reduce root to be a POGlobalRearrange, skip secondary key optimizing");
            currentNode = null;
        } else {
            List<PhysicalOperator> globalRearrangeSuccs = reducePlan.getSuccessors(root);
            if (globalRearrangeSuccs.size() == 1) {
                currentNode = globalRearrangeSuccs.get(0);
            } else {
                log.debug((Object)"Expected successor of a POGlobalRearrange is POPackage, skip secondary key optimizing");
                currentNode = null;
            }
        }
        return currentNode;
    }
}

