/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.shims;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.ContextFactory;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;

public class HadoopShims {
    private static Log LOG = LogFactory.getLog(HadoopShims.class);

    public static JobContext cloneJobContext(JobContext original) throws IOException, InterruptedException {
        JobContext newContext = ContextFactory.cloneContext((JobContext)original, (Configuration)new JobConf(original.getConfiguration()));
        return newContext;
    }

    public static TaskAttemptContext createTaskAttemptContext(Configuration conf, TaskAttemptID taskId) {
        if (conf instanceof JobConf) {
            return new TaskAttemptContextImpl((Configuration)new JobConf(conf), taskId);
        }
        return new TaskAttemptContextImpl(conf, taskId);
    }

    public static JobContext createJobContext(Configuration conf, JobID jobId) {
        if (conf instanceof JobConf) {
            return new JobContextImpl((Configuration)new JobConf(conf), jobId);
        }
        return new JobContextImpl(conf, jobId);
    }

    public static boolean isMap(TaskAttemptID taskAttemptID) {
        TaskType type = taskAttemptID.getTaskType();
        return type == TaskType.MAP;
    }

    public static TaskAttemptID getNewTaskAttemptID() {
        TaskAttemptID taskAttemptID = new TaskAttemptID("", 1, TaskType.MAP, 1, 1);
        return taskAttemptID;
    }

    public static TaskAttemptID createTaskAttemptID(String jtIdentifier, int jobId, boolean isMap, int taskId, int id) {
        if (isMap) {
            return new TaskAttemptID(jtIdentifier, jobId, TaskType.MAP, taskId, id);
        }
        return new TaskAttemptID(jtIdentifier, jobId, TaskType.REDUCE, taskId, id);
    }

    public static boolean hasFileSystemImpl(Path path, Configuration conf) {
        String scheme = path.toUri().getScheme();
        if (scheme != null) {
            if (conf.get("fs.file.impl") != null) {
                String fsImpl = conf.get("fs." + scheme + ".impl");
                if (fsImpl == null) {
                    return false;
                }
            } else {
                try {
                    Class fs = FileSystem.getFileSystemClass((String)scheme, (Configuration)conf);
                    return fs != null;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return true;
    }
}

