/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators;

import java.util.List;
import java.util.Map;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

public class POMapLookUp
extends ExpressionOperator {
    private static final long serialVersionUID = 1L;
    private String key;

    public POMapLookUp(OperatorKey k) {
        super(k);
    }

    public POMapLookUp(OperatorKey k, int rp) {
        super(k, rp);
    }

    public POMapLookUp(OperatorKey k, int rp, String key) {
        super(k, rp);
        this.key = key;
    }

    public void setLookUpKey(String key) {
        this.key = key;
    }

    public String getLookUpKey() {
        return this.key;
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitMapLookUp(this);
    }

    @Override
    public String name() {
        return "POMapLookUp[" + DataType.findTypeName(this.resultType) + "] - " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public Result processInput() throws ExecException {
        Result res = new Result();
        Object inpValue = null;
        if (this.input == null && (this.inputs == null || this.inputs.size() == 0)) {
            res.returnStatus = (byte)3;
            return res;
        }
        if (!this.isInputAttached()) {
            return ((PhysicalOperator)this.inputs.get(0)).getNextMap();
        }
        res.result = this.input;
        res.returnStatus = 0;
        this.detachInput();
        return res;
    }

    private Result getNext() throws ExecException {
        Result res = this.processInput();
        if (res.result != null && res.returnStatus == 0) {
            res.result = ((Map)res.result).get(this.key);
        }
        return res;
    }

    @Override
    public Result getNextBoolean() throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNextDataBag() throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNextDataByteArray() throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNextDouble() throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNextFloat() throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNextInteger() throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNextLong() throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNextDateTime() throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNextMap() throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNextString() throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNextTuple() throws ExecException {
        return this.getNext();
    }

    @Override
    public POMapLookUp clone() throws CloneNotSupportedException {
        POMapLookUp clone = new POMapLookUp(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)), -1, this.key);
        clone.cloneHelper(this);
        return clone;
    }

    @Override
    public List<ExpressionOperator> getChildExpressions() {
        return null;
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        return (Tuple)out;
    }
}

