/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.IncreasingToUpperBoundRegionSplitPolicy;

@InterfaceAudience.Private
public class KeyPrefixRegionSplitPolicy
extends IncreasingToUpperBoundRegionSplitPolicy {
    private static final Log LOG = LogFactory.getLog(KeyPrefixRegionSplitPolicy.class);
    @Deprecated
    public static final String PREFIX_LENGTH_KEY_DEPRECATED = "prefix_split_key_policy.prefix_length";
    public static final String PREFIX_LENGTH_KEY = "KeyPrefixRegionSplitPolicy.prefix_length";
    private int prefixLength = 0;

    @Override
    protected void configureForRegion(HRegion region) {
        super.configureForRegion(region);
        this.prefixLength = 0;
        String prefixLengthString = region.getTableDesc().getValue(PREFIX_LENGTH_KEY);
        if (prefixLengthString == null && (prefixLengthString = region.getTableDesc().getValue(PREFIX_LENGTH_KEY_DEPRECATED)) == null) {
            LOG.error((Object)("KeyPrefixRegionSplitPolicy.prefix_length not specified for table " + region.getTableDesc().getTableName() + ". Using default RegionSplitPolicy"));
            return;
        }
        try {
            this.prefixLength = Integer.parseInt(prefixLengthString);
        }
        catch (NumberFormatException nfe) {
            LOG.error((Object)("Number format exception when parsing KeyPrefixRegionSplitPolicy.prefix_length for table " + region.getTableDesc().getTableName() + ":" + prefixLengthString + ". " + nfe));
            return;
        }
        if (this.prefixLength <= 0) {
            LOG.error((Object)("Invalid value for KeyPrefixRegionSplitPolicy.prefix_length for table " + region.getTableDesc().getTableName() + ":" + prefixLengthString + ". Using default RegionSplitPolicy"));
        }
    }

    @Override
    protected byte[] getSplitPoint() {
        byte[] splitPoint = super.getSplitPoint();
        if (this.prefixLength > 0 && splitPoint != null && splitPoint.length > 0) {
            return Arrays.copyOf(splitPoint, Math.min(this.prefixLength, splitPoint.length));
        }
        return splitPoint;
    }
}

