/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2;

import com.google.common.base.Supplier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.app.MRApp;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptStatusUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.speculate.LegacyTaskRuntimeEstimator;
import org.apache.hadoop.mapreduce.v2.app.speculate.SimpleExponentialTaskRuntimeEstimator;
import org.apache.hadoop.mapreduce.v2.app.speculate.TaskRuntimeEstimator;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestSpeculativeExecutionWithMRApp {
    private static final int NUM_MAPPERS = 5;
    private static final int NUM_REDUCERS = 0;
    private Class<? extends TaskRuntimeEstimator> estimatorClass;
    private final ControlledClock controlledClk;

    @Parameterized.Parameters(name="{index}: TaskEstimator(EstimatorClass {0})")
    public static Collection<Object[]> getTestParameters() {
        return Arrays.asList({SimpleExponentialTaskRuntimeEstimator.class}, {LegacyTaskRuntimeEstimator.class});
    }

    public TestSpeculativeExecutionWithMRApp(Class<? extends TaskRuntimeEstimator> estimatorKlass) {
        this.estimatorClass = estimatorKlass;
        this.controlledClk = new ControlledClock();
    }

    @Before
    public void setup() {
        this.controlledClk.setTime(System.currentTimeMillis());
    }

    @Test(timeout=360000L)
    public void testSpeculateSuccessfulWithoutUpdateEvents() throws Exception {
        MRApp app = new MRApp(5, 0, false, "test", true, (Clock)this.controlledClk);
        Job job = app.submit(this.createConfiguration(), true, true);
        app.waitForState(job, JobState.RUNNING);
        Map tasks = job.getTasks();
        Assert.assertEquals((String)"Num tasks is not correct", (long)5L, (long)tasks.size());
        Iterator taskIter = tasks.values().iterator();
        while (taskIter.hasNext()) {
            app.waitForState((Task)taskIter.next(), TaskState.RUNNING);
        }
        this.controlledClk.tickMsec(1000L);
        EventHandler appEventHandler = app.getContext().getEventHandler();
        for (Map.Entry mapTask : tasks.entrySet()) {
            for (Map.Entry taskAttempt : ((Task)mapTask.getValue()).getAttempts().entrySet()) {
                this.updateTaskProgress(appEventHandler, (TaskAttempt)taskAttempt.getValue(), 0.8f);
            }
        }
        Random generator = new Random();
        Object[] taskValues = tasks.values().toArray();
        Task taskToBeSpeculated = (Task)taskValues[generator.nextInt(taskValues.length)];
        for (Map.Entry mapTask : tasks.entrySet()) {
            if (mapTask.getKey() == taskToBeSpeculated.getID()) continue;
            for (Map.Entry taskAttempt : ((Task)mapTask.getValue()).getAttempts().entrySet()) {
                TaskAttemptId taId = (TaskAttemptId)taskAttempt.getKey();
                if (taId.getId() > 0) continue;
                TestSpeculativeExecutionWithMRApp.markTACompleted(appEventHandler, (TaskAttempt)taskAttempt.getValue());
                this.waitForTAState((TaskAttempt)taskAttempt.getValue(), TaskAttemptState.SUCCEEDED, this.controlledClk);
            }
        }
        this.controlledClk.tickMsec(2000L);
        this.waitForSpeculation(taskToBeSpeculated, this.controlledClk);
        TaskAttempt[] ta = TestSpeculativeExecutionWithMRApp.makeFirstAttemptWin(appEventHandler, taskToBeSpeculated);
        this.waitForTAState(ta[0], TaskAttemptState.SUCCEEDED, this.controlledClk);
        this.waitForAppStop(app, this.controlledClk);
    }

    @Test(timeout=360000L)
    public void testSpeculateSuccessfulWithUpdateEvents() throws Exception {
        MRApp app = new MRApp(5, 0, false, "test", true, (Clock)this.controlledClk);
        Job job = app.submit(this.createConfiguration(), true, true);
        app.waitForState(job, JobState.RUNNING);
        Map tasks = job.getTasks();
        Assert.assertEquals((String)"Num tasks is not correct", (long)5L, (long)tasks.size());
        Iterator taskIter = tasks.values().iterator();
        while (taskIter.hasNext()) {
            app.waitForState((Task)taskIter.next(), TaskState.RUNNING);
        }
        this.controlledClk.tickMsec(2000L);
        EventHandler appEventHandler = app.getContext().getEventHandler();
        for (Map.Entry mapTask : tasks.entrySet()) {
            for (Map.Entry taskAttempt : ((Task)mapTask.getValue()).getAttempts().entrySet()) {
                this.updateTaskProgress(appEventHandler, (TaskAttempt)taskAttempt.getValue(), 0.5f);
            }
        }
        Task speculatedTask = null;
        int numTasksToFinish = 4;
        this.controlledClk.tickMsec(1000L);
        for (Map.Entry task : tasks.entrySet()) {
            for (Map.Entry taskAttempt : ((Task)task.getValue()).getAttempts().entrySet()) {
                TaskAttemptId taId = (TaskAttemptId)taskAttempt.getKey();
                if (numTasksToFinish > 0 && taId.getId() == 0) {
                    TestSpeculativeExecutionWithMRApp.markTACompleted(appEventHandler, (TaskAttempt)taskAttempt.getValue());
                    --numTasksToFinish;
                    this.waitForTAState((TaskAttempt)taskAttempt.getValue(), TaskAttemptState.SUCCEEDED, this.controlledClk);
                    continue;
                }
                speculatedTask = (Task)task.getValue();
                this.updateTaskProgress(appEventHandler, (TaskAttempt)taskAttempt.getValue(), 0.75f);
            }
        }
        this.controlledClk.tickMsec(15000L);
        for (Map.Entry task : tasks.entrySet()) {
            for (Map.Entry taskAttempt : ((Task)task.getValue()).getAttempts().entrySet()) {
                if (((TaskAttempt)taskAttempt.getValue()).getState() == TaskAttemptState.SUCCEEDED || ((TaskAttempt)taskAttempt.getValue()).getState() == TaskAttemptState.KILLED) continue;
                this.updateTaskProgress(appEventHandler, (TaskAttempt)taskAttempt.getValue(), 0.75f);
            }
        }
        Task speculatedTaskConst = speculatedTask;
        this.waitForSpeculation(speculatedTaskConst, this.controlledClk);
        TaskAttempt[] ta = TestSpeculativeExecutionWithMRApp.makeFirstAttemptWin(appEventHandler, speculatedTask);
        this.waitForTAState(ta[0], TaskAttemptState.SUCCEEDED, this.controlledClk);
        this.waitForAppStop(app, this.controlledClk);
    }

    private static TaskAttempt[] makeFirstAttemptWin(EventHandler appEventHandler, Task speculatedTask) {
        Collection attempts = speculatedTask.getAttempts().values();
        TaskAttempt[] ta = new TaskAttempt[attempts.size()];
        attempts.toArray(ta);
        TestSpeculativeExecutionWithMRApp.markTACompleted(appEventHandler, ta[0]);
        return ta;
    }

    private static void markTACompleted(EventHandler appEventHandler, TaskAttempt attempt) {
        appEventHandler.handle((Event)new TaskAttemptEvent(attempt.getID(), TaskAttemptEventType.TA_DONE));
        appEventHandler.handle((Event)new TaskAttemptEvent(attempt.getID(), TaskAttemptEventType.TA_CONTAINER_COMPLETED));
    }

    private TaskAttemptStatusUpdateEvent.TaskAttemptStatus createTaskAttemptStatus(TaskAttemptId id, float progress, TaskAttemptState state) {
        TaskAttemptStatusUpdateEvent.TaskAttemptStatus status = new TaskAttemptStatusUpdateEvent.TaskAttemptStatus();
        status.id = id;
        status.progress = progress;
        status.taskState = state;
        return status;
    }

    private Configuration createConfiguration() {
        Configuration conf = new Configuration();
        conf.setClass("yarn.app.mapreduce.am.job.task.estimator.class", this.estimatorClass, TaskRuntimeEstimator.class);
        if (SimpleExponentialTaskRuntimeEstimator.class.equals(this.estimatorClass)) {
            conf.setInt("yarn.app.mapreduce.am.job.task.estimator.simple.exponential.smooth.skip-initials", 1);
            conf.setLong("yarn.app.mapreduce.am.job.task.estimator.simple.exponential.smooth.lambda-ms", 10000L);
        }
        conf.setLong("mapreduce.job.speculative.retry-after-no-speculate", 3000L);
        return conf;
    }

    private void waitForAppStop(final MRApp app, final ControlledClock cClock) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                if (app.getServiceState() != Service.STATE.STOPPED) {
                    cClock.tickMsec(250L);
                    return false;
                }
                return true;
            }
        }, (int)250, (int)60000);
    }

    private void waitForSpeculation(final Task speculatedTask, final ControlledClock cClock) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                if (speculatedTask.getAttempts().size() != 2) {
                    cClock.tickMsec(250L);
                    return false;
                }
                return true;
            }
        }, (int)250, (int)60000);
    }

    public void waitForTAState(final TaskAttempt attempt, final TaskAttemptState finalState, final ControlledClock cClock) throws Exception {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                if (attempt.getReport().getTaskAttemptState() != finalState) {
                    cClock.tickMsec(250L);
                    return false;
                }
                return true;
            }
        }, (int)250, (int)10000);
    }

    private void updateTaskProgress(EventHandler appEventHandler, TaskAttempt attempt, float newProgress) {
        TaskAttemptStatusUpdateEvent.TaskAttemptStatus status = this.createTaskAttemptStatus(attempt.getID(), newProgress, TaskAttemptState.RUNNING);
        TaskAttemptStatusUpdateEvent event = new TaskAttemptStatusUpdateEvent(attempt.getID(), new AtomicReference<TaskAttemptStatusUpdateEvent.TaskAttemptStatus>(status));
        appEventHandler.handle((Event)event);
    }
}

