/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.slive.BadFileException;
import org.apache.hadoop.fs.slive.ConfigExtractor;
import org.apache.hadoop.fs.slive.DataVerifier;
import org.apache.hadoop.fs.slive.Helper;
import org.apache.hadoop.fs.slive.Operation;
import org.apache.hadoop.fs.slive.OperationOutput;
import org.apache.hadoop.fs.slive.Range;
import org.apache.hadoop.fs.slive.Timer;

class ReadOp
extends Operation {
    private static final Log LOG = LogFactory.getLog(ReadOp.class);

    ReadOp(ConfigExtractor cfg, Random rnd) {
        super(ReadOp.class.getSimpleName(), cfg, rnd);
    }

    protected Path getReadFile() {
        Path fn = this.getFinder().getFile();
        return fn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<OperationOutput> run(FileSystem fs) {
        List<OperationOutput> out = super.run(fs);
        FilterInputStream is = null;
        try {
            Path fn = this.getReadFile();
            Range<Long> readSizeRange = this.getConfig().getReadSize();
            long readSize = 0L;
            String readStrAm = "";
            if (this.getConfig().shouldReadFullFile()) {
                readSize = Long.MAX_VALUE;
                readStrAm = "full file";
            } else {
                readSize = Range.betweenPositive(this.getRandom(), readSizeRange);
                readStrAm = Helper.toByteInfo(readSize);
            }
            long timeTaken = 0L;
            long chunkSame = 0L;
            long chunkDiff = 0L;
            long bytesRead = 0L;
            long startTime = 0L;
            DataVerifier vf = new DataVerifier();
            LOG.info((Object)("Attempting to read file at " + fn + " of size (" + readStrAm + ")"));
            startTime = Timer.now();
            is = fs.open(fn);
            timeTaken += Timer.elapsed(startTime);
            DataVerifier.VerifyOutput vo = vf.verifyFile(readSize, (DataInputStream)is);
            timeTaken += vo.getReadTime();
            chunkSame += vo.getChunksSame();
            chunkDiff += vo.getChunksDifferent();
            bytesRead += vo.getBytesRead();
            startTime = Timer.now();
            is.close();
            is = null;
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "milliseconds_taken", timeTaken += Timer.elapsed(startTime)));
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "bytes_read", bytesRead));
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "successes", 1L));
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "chunks_verified", chunkSame));
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "chunks_unverified", chunkDiff));
            LOG.info((Object)("Read " + Helper.toByteInfo(bytesRead) + " of " + fn + " with " + chunkSame + " chunks being same as expected and " + chunkDiff + " chunks being different than expected in " + timeTaken + " milliseconds"));
        }
        catch (FileNotFoundException e) {
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "files_not_found", 1L));
            LOG.warn((Object)"Error with reading", (Throwable)e);
        }
        catch (BadFileException e) {
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "bad_files", 1L));
            LOG.warn((Object)"Error reading bad file", (Throwable)e);
        }
        catch (IOException e) {
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "failures", 1L));
            LOG.warn((Object)"Error reading", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)"Error closing read stream", (Throwable)e);
                }
            }
        }
        return out;
    }
}

