/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.slive.ConfigOption;
import org.apache.hadoop.fs.slive.Constants;
import org.apache.hadoop.fs.slive.Formatter;
import org.apache.hadoop.fs.slive.Helper;
import org.apache.hadoop.fs.slive.OperationData;
import org.apache.hadoop.fs.slive.Range;
import org.apache.hadoop.util.StringUtils;

class ConfigExtractor {
    private static final Log LOG = LogFactory.getLog(ConfigExtractor.class);
    private Configuration config;

    ConfigExtractor(Configuration cfg) {
        this.config = cfg;
    }

    Configuration getConfig() {
        return this.config;
    }

    Path getDataPath() {
        Path base = this.getBaseDirectory();
        if (base == null) {
            return null;
        }
        return new Path(base, "data");
    }

    Path getOutputPath() {
        Path base = this.getBaseDirectory();
        if (base == null) {
            return null;
        }
        return new Path(base, "output");
    }

    Path getBaseDirectory(String primary) {
        String path = primary;
        if (path == null) {
            path = this.config.get(ConfigOption.BASE_DIR.getCfgOption());
        }
        if (path == null) {
            path = ConfigOption.BASE_DIR.getDefault();
        }
        if (path == null) {
            return null;
        }
        return new Path(path);
    }

    Path getBaseDirectory() {
        return this.getBaseDirectory(null);
    }

    boolean shouldExitOnFirstError() {
        return this.shouldExitOnFirstError(null);
    }

    boolean shouldExitOnFirstError(String primary) {
        String val = primary;
        if (val == null) {
            val = this.config.get(ConfigOption.EXIT_ON_ERROR.getCfgOption());
        }
        if (val == null) {
            return ConfigOption.EXIT_ON_ERROR.getDefault();
        }
        return Boolean.parseBoolean(val);
    }

    boolean shouldWaitOnTruncate() {
        return this.shouldWaitOnTruncate(null);
    }

    boolean shouldWaitOnTruncate(String primary) {
        String val = primary;
        if (val == null) {
            val = this.config.get(ConfigOption.EXIT_ON_ERROR.getCfgOption());
        }
        if (val == null) {
            return ConfigOption.EXIT_ON_ERROR.getDefault();
        }
        return Boolean.parseBoolean(val);
    }

    Integer getReducerAmount() {
        return this.getInteger(null, ConfigOption.REDUCES);
    }

    Integer getMapAmount() {
        return this.getMapAmount(null);
    }

    Integer getMapAmount(String primary) {
        return this.getInteger(primary, ConfigOption.MAPS);
    }

    Integer getDuration() {
        return this.getDuration(null);
    }

    Integer getDurationMilliseconds() {
        Integer seconds = this.getDuration();
        if (seconds == null || seconds == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int milliseconds = seconds * 1000;
        if (milliseconds < 0) {
            milliseconds = 0;
        }
        return milliseconds;
    }

    Integer getDuration(String primary) {
        return this.getInteger(primary, ConfigOption.DURATION);
    }

    Integer getOpCount() {
        return this.getOpCount(null);
    }

    Integer getOpCount(String primary) {
        return this.getInteger(primary, ConfigOption.OPS);
    }

    Integer getDirSize() {
        return this.getDirSize(null);
    }

    Integer getDirSize(String primary) {
        return this.getInteger(primary, ConfigOption.DIR_SIZE);
    }

    private Integer getInteger(String primary, ConfigOption<Integer> opt) {
        String value = primary;
        if (value == null) {
            value = this.config.get(opt.getCfgOption());
        }
        if (value == null) {
            return opt.getDefault();
        }
        return Integer.parseInt(value);
    }

    Integer getTotalFiles() {
        return this.getTotalFiles(null);
    }

    Integer getTotalFiles(String primary) {
        return this.getInteger(primary, ConfigOption.FILES);
    }

    Long getRandomSeed(String primary) {
        String seed = primary;
        if (seed == null) {
            seed = this.config.get(ConfigOption.RANDOM_SEED.getCfgOption());
        }
        if (seed == null) {
            return null;
        }
        return Long.parseLong(seed);
    }

    Long getRandomSeed() {
        return this.getRandomSeed(null);
    }

    String getResultFile() {
        return this.getResultFile(null);
    }

    String getQueueName() {
        return this.getQueueName(null);
    }

    String getQueueName(String primary) {
        String q = primary;
        if (q == null) {
            q = this.config.get(ConfigOption.QUEUE_NAME.getCfgOption());
        }
        if (q == null) {
            q = ConfigOption.QUEUE_NAME.getDefault();
        }
        return q;
    }

    String getResultFile(String primary) {
        String fn = primary;
        if (fn == null) {
            fn = this.config.get(ConfigOption.RESULT_FILE.getCfgOption());
        }
        if (fn == null) {
            fn = ConfigOption.RESULT_FILE.getDefault();
        }
        return fn;
    }

    Range<Long> getBlockSize(String primary) {
        return this.getMinMaxBytes(ConfigOption.BLOCK_SIZE, primary);
    }

    Range<Long> getBlockSize() {
        return this.getBlockSize(null);
    }

    private Range<Short> getMinMaxShort(ConfigOption<Short> cfgopt, String primary) {
        Short def;
        String[] pieces;
        String sval = primary;
        if (sval == null) {
            sval = this.config.get(cfgopt.getCfgOption());
        }
        Range<Short> range = null;
        if (sval != null && (pieces = Helper.getTrimmedStrings(sval)).length == 2) {
            short maxVal;
            String min = pieces[0];
            String max = pieces[1];
            short minVal = Short.parseShort(min);
            if (minVal > (maxVal = Short.parseShort(max))) {
                short tmp = minVal;
                minVal = maxVal;
                maxVal = tmp;
            }
            range = new Range<Short>(minVal, maxVal);
        }
        if (range == null && (def = cfgopt.getDefault()) != null) {
            range = new Range<Short>(def, def);
        }
        return range;
    }

    private Range<Long> getMinMaxLong(ConfigOption<Long> cfgopt, String primary) {
        Long def;
        String[] pieces;
        String sval = primary;
        if (sval == null) {
            sval = this.config.get(cfgopt.getCfgOption());
        }
        Range<Long> range = null;
        if (sval != null && (pieces = Helper.getTrimmedStrings(sval)).length == 2) {
            long maxVal;
            String min = pieces[0];
            String max = pieces[1];
            long minVal = Long.parseLong(min);
            if (minVal > (maxVal = Long.parseLong(max))) {
                long tmp = minVal;
                minVal = maxVal;
                maxVal = tmp;
            }
            range = new Range<Long>(minVal, maxVal);
        }
        if (range == null && (def = cfgopt.getDefault()) != null) {
            range = new Range<Long>(def, def);
        }
        return range;
    }

    private Range<Long> getMinMaxBytes(ConfigOption<Long> cfgopt, String primary) {
        Long def;
        String[] pieces;
        String sval = primary;
        if (sval == null) {
            sval = this.config.get(cfgopt.getCfgOption());
        }
        Range<Long> range = null;
        if (sval != null && (pieces = Helper.getTrimmedStrings(sval)).length == 2) {
            long tMax;
            String min = pieces[0];
            String max = pieces[1];
            long tMin = StringUtils.TraditionalBinaryPrefix.string2long((String)min);
            if (tMin > (tMax = StringUtils.TraditionalBinaryPrefix.string2long((String)max))) {
                long tmp = tMin;
                tMin = tMax;
                tMax = tmp;
            }
            range = new Range<Long>(tMin, tMax);
        }
        if (range == null && (def = cfgopt.getDefault()) != null) {
            range = new Range<Long>(def, def);
        }
        return range;
    }

    Range<Short> getReplication(String primary) {
        return this.getMinMaxShort(ConfigOption.REPLICATION_AM, primary);
    }

    Range<Short> getReplication() {
        return this.getReplication(null);
    }

    Map<Constants.OperationType, OperationData> getOperations() {
        HashMap<Constants.OperationType, OperationData> operations = new HashMap<Constants.OperationType, OperationData>();
        for (Constants.OperationType type : Constants.OperationType.values()) {
            String opname = type.lowerName();
            String keyname = String.format("slive.op.%s", opname);
            String kval = this.config.get(keyname);
            if (kval == null) continue;
            operations.put(type, new OperationData(kval));
        }
        return operations;
    }

    Range<Long> getAppendSize(String primary) {
        return this.getMinMaxBytes(ConfigOption.APPEND_SIZE, primary);
    }

    Range<Long> getAppendSize() {
        return this.getAppendSize(null);
    }

    Range<Long> getTruncateSize(String primary) {
        return this.getMinMaxBytes(ConfigOption.TRUNCATE_SIZE, primary);
    }

    Range<Long> getTruncateSize() {
        return this.getTruncateSize(null);
    }

    Range<Long> getSleepRange(String primary) {
        return this.getMinMaxLong(ConfigOption.SLEEP_TIME, primary);
    }

    Range<Long> getSleepRange() {
        return this.getSleepRange(null);
    }

    Range<Long> getWriteSize(String primary) {
        return this.getMinMaxBytes(ConfigOption.WRITE_SIZE, primary);
    }

    Range<Long> getWriteSize() {
        return this.getWriteSize(null);
    }

    boolean shouldWriteUseBlockSize() {
        Range<Long> writeRange = this.getWriteSize();
        return writeRange == null || writeRange.getLower() == writeRange.getUpper() && writeRange.getUpper() == Long.MAX_VALUE;
    }

    boolean shouldAppendUseBlockSize() {
        Range<Long> appendRange = this.getAppendSize();
        return appendRange == null || appendRange.getLower() == appendRange.getUpper() && appendRange.getUpper() == Long.MAX_VALUE;
    }

    boolean shouldTruncateUseBlockSize() {
        Range<Long> truncateRange = this.getTruncateSize();
        return truncateRange == null || truncateRange.getLower() == truncateRange.getUpper() && truncateRange.getUpper() == Long.MAX_VALUE;
    }

    boolean shouldReadFullFile() {
        Range<Long> readRange = this.getReadSize();
        return readRange == null || readRange.getLower() == readRange.getUpper() && readRange.getUpper() == Long.MAX_VALUE;
    }

    Range<Long> getReadSize(String primary) {
        return this.getMinMaxBytes(ConfigOption.READ_SIZE, primary);
    }

    Long getByteCheckSum() {
        String val = this.config.get("io.bytes.per.checksum");
        if (val == null) {
            return null;
        }
        return Long.parseLong(val);
    }

    Range<Long> getReadSize() {
        return this.getReadSize(null);
    }

    static void dumpOptions(ConfigExtractor cfg) {
        if (cfg == null) {
            return;
        }
        LOG.info((Object)("Base directory = " + cfg.getBaseDirectory()));
        LOG.info((Object)("Data directory = " + cfg.getDataPath()));
        LOG.info((Object)("Output directory = " + cfg.getOutputPath()));
        LOG.info((Object)("Result file = " + cfg.getResultFile()));
        LOG.info((Object)("Grid queue = " + cfg.getQueueName()));
        LOG.info((Object)("Should exit on first error = " + cfg.shouldExitOnFirstError()));
        String duration = "Duration = ";
        duration = cfg.getDurationMilliseconds() == Integer.MAX_VALUE ? duration + "unlimited" : duration + cfg.getDurationMilliseconds() + " milliseconds";
        LOG.info((Object)duration);
        LOG.info((Object)("Map amount = " + cfg.getMapAmount()));
        LOG.info((Object)("Reducer amount = " + cfg.getReducerAmount()));
        LOG.info((Object)("Operation amount = " + cfg.getOpCount()));
        LOG.info((Object)("Total file limit = " + cfg.getTotalFiles()));
        LOG.info((Object)("Total dir file limit = " + cfg.getDirSize()));
        String read = "Read size = ";
        read = cfg.shouldReadFullFile() ? read + "entire file" : read + cfg.getReadSize() + " bytes";
        LOG.info((Object)read);
        String write = "Write size = ";
        write = cfg.shouldWriteUseBlockSize() ? write + "blocksize" : write + cfg.getWriteSize() + " bytes";
        LOG.info((Object)write);
        String append = "Append size = ";
        append = cfg.shouldAppendUseBlockSize() ? append + "blocksize" : append + cfg.getAppendSize() + " bytes";
        LOG.info((Object)append);
        String bsize = "Block size = ";
        bsize = bsize + cfg.getBlockSize() + " bytes";
        LOG.info((Object)bsize);
        if (cfg.getRandomSeed() != null) {
            LOG.info((Object)("Random seed = " + cfg.getRandomSeed()));
        }
        if (cfg.getSleepRange() != null) {
            LOG.info((Object)("Sleep range = " + cfg.getSleepRange() + " milliseconds"));
        }
        LOG.info((Object)("Replication amount = " + cfg.getReplication()));
        LOG.info((Object)"Operations are:");
        NumberFormat percFormatter = Formatter.getPercentFormatter();
        Map<Constants.OperationType, OperationData> operations = cfg.getOperations();
        for (Constants.OperationType type : operations.keySet()) {
            String name = type.name();
            LOG.info((Object)name);
            OperationData opInfo = operations.get((Object)type);
            LOG.info((Object)(" " + opInfo.getDistribution().name()));
            if (opInfo.getPercent() != null) {
                LOG.info((Object)(" " + percFormatter.format(opInfo.getPercent())));
                continue;
            }
            LOG.info((Object)" ???");
        }
    }
}

