/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import com.google.common.collect.Lists;
import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.BlockingService;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ipc.AsyncRpcClient;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientFactory;
import org.apache.hadoop.hbase.ipc.RpcClientImpl;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestSecureRPC {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final File KEYTAB_FILE = new File(TEST_UTIL.getDataTestDir("keytab").toUri().getPath());
    static final BlockingService SERVICE = TestRpcServiceProtos.TestProtobufRpcProto.newReflectiveBlockingService(new TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface(){

        @Override
        public TestProtos.EmptyResponseProto ping(RpcController controller, TestProtos.EmptyRequestProto request) throws ServiceException {
            return null;
        }

        @Override
        public TestProtos.EmptyResponseProto error(RpcController controller, TestProtos.EmptyRequestProto request) throws ServiceException {
            return null;
        }

        @Override
        public TestProtos.EchoResponseProto echo(RpcController controller, TestProtos.EchoRequestProto request) throws ServiceException {
            if (controller instanceof PayloadCarryingRpcController) {
                PayloadCarryingRpcController pcrc = (PayloadCarryingRpcController)controller;
                CellScanner cellScanner = pcrc.cellScanner();
                ArrayList<Cell> list = null;
                if (cellScanner != null) {
                    list = new ArrayList<Cell>();
                    try {
                        while (cellScanner.advance()) {
                            list.add(cellScanner.current());
                        }
                    }
                    catch (IOException e) {
                        throw new ServiceException((Throwable)e);
                    }
                }
                cellScanner = CellUtil.createCellScanner(list);
                ((PayloadCarryingRpcController)controller).setCellScanner(cellScanner);
            }
            return TestProtos.EchoResponseProto.newBuilder().setMessage(request.getMessage()).build();
        }
    });
    private static MiniKdc KDC;
    private static String HOST;
    private static String PRINCIPAL;

    @BeforeClass
    public static void setUp() throws Exception {
        KDC = TEST_UTIL.setupMiniKdc(KEYTAB_FILE);
        PRINCIPAL = "hbase/" + HOST;
        KDC.createPrincipal(KEYTAB_FILE, new String[]{PRINCIPAL});
        HBaseKerberosUtils.setPrincipalForTesting(PRINCIPAL + "@" + KDC.getRealm());
    }

    @AfterClass
    public static void tearDown() throws IOException {
        if (KDC != null) {
            KDC.stop();
        }
        TEST_UTIL.cleanupTestDir();
    }

    @Test
    public void testRpc() throws Exception {
        this.testRpcCallWithEnabledKerberosSaslAuth(RpcClientImpl.class);
    }

    @Test
    public void testRpcWithInsecureFallback() throws Exception {
        this.testRpcFallbackToSimpleAuth(RpcClientImpl.class);
    }

    @Test
    public void testAsyncRpc() throws Exception {
        this.testRpcCallWithEnabledKerberosSaslAuth(AsyncRpcClient.class);
    }

    @Test
    public void testAsyncRpcWithInsecureFallback() throws Exception {
        this.testRpcFallbackToSimpleAuth(AsyncRpcClient.class);
    }

    private void testRpcCallWithEnabledKerberosSaslAuth(Class<? extends RpcClient> rpcImplClass) throws Exception {
        String krbKeytab = HBaseKerberosUtils.getKeytabFileForTesting();
        String krbPrincipal = HBaseKerberosUtils.getPrincipalForTesting();
        UserGroupInformation ugi = this.loginKerberosPrincipal(krbKeytab, krbPrincipal);
        UserGroupInformation ugi2 = UserGroupInformation.getCurrentUser();
        Assert.assertSame((Object)ugi, (Object)ugi2);
        Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS, (Object)ugi.getAuthenticationMethod());
        Assert.assertEquals((Object)krbPrincipal, (Object)ugi.getUserName());
        Configuration clientConf = HBaseKerberosUtils.getSecuredConfiguration();
        this.callRpcService(rpcImplClass, User.create((UserGroupInformation)ugi2), clientConf, false);
    }

    private UserGroupInformation loginKerberosPrincipal(String krbKeytab, String krbPrincipal) throws Exception {
        Configuration cnf = new Configuration();
        cnf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)cnf);
        UserGroupInformation.loginUserFromKeytab((String)krbPrincipal, (String)krbKeytab);
        return UserGroupInformation.getLoginUser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callRpcService(Class<? extends RpcClient> rpcImplClass, User clientUser, Configuration clientConf, boolean allowInsecureFallback) throws Exception {
        Configuration clientConfCopy = new Configuration(clientConf);
        clientConfCopy.set("hbase.rpc.client.impl", rpcImplClass.getName());
        Configuration conf = HBaseKerberosUtils.getSecuredConfiguration();
        conf.setBoolean("hbase.ipc.server.fallback-to-simple-auth-allowed", allowInsecureFallback);
        SecurityInfo securityInfoMock = (SecurityInfo)Mockito.mock(SecurityInfo.class);
        Mockito.when((Object)securityInfoMock.getServerPrincipal()).thenReturn((Object)"hbase.regionserver.kerberos.principal");
        SecurityInfo.addInfo((String)"TestProtobufRpcProto", (SecurityInfo)securityInfoMock);
        InetSocketAddress isa = new InetSocketAddress(HOST, 0);
        RpcServer rpcServer = new RpcServer(null, "AbstractTestSecureIPC", (List)Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(SERVICE, null)}), isa, conf, (RpcScheduler)new FifoRpcScheduler(conf, 1));
        rpcServer.start();
        try (RpcClient rpcClient = RpcClientFactory.createClient((Configuration)clientConf, (String)HConstants.DEFAULT_CLUSTER_ID.toString());){
            InetSocketAddress address = rpcServer.getListenerAddress();
            if (address == null) {
                throw new IOException("Listener channel is closed");
            }
            BlockingRpcChannel channel = rpcClient.createBlockingRpcChannel(ServerName.valueOf((String)address.getHostName(), (int)address.getPort(), (long)System.currentTimeMillis()), clientUser, 5000);
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = TestRpcServiceProtos.TestProtobufRpcProto.newBlockingStub(channel);
            ArrayList<String> results = new ArrayList<String>();
            TestThread th1 = new TestThread(stub, results);
            th1.start();
            th1.join();
        }
        finally {
            rpcServer.stop();
        }
    }

    public void testRpcFallbackToSimpleAuth(Class<? extends RpcClient> rpcImplClass) throws Exception {
        String krbKeytab = HBaseKerberosUtils.getKeytabFileForTesting();
        String krbPrincipal = HBaseKerberosUtils.getPrincipalForTesting();
        UserGroupInformation ugi = this.loginKerberosPrincipal(krbKeytab, krbPrincipal);
        Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS, (Object)ugi.getAuthenticationMethod());
        Assert.assertEquals((Object)krbPrincipal, (Object)ugi.getUserName());
        String clientUsername = "testuser";
        UserGroupInformation clientUgi = UserGroupInformation.createUserForTesting((String)clientUsername, (String[])new String[]{clientUsername});
        Assert.assertNotSame((Object)ugi, (Object)clientUgi);
        Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.SIMPLE, (Object)clientUgi.getAuthenticationMethod());
        Assert.assertEquals((Object)clientUsername, (Object)clientUgi.getUserName());
        Configuration clientConf = new Configuration();
        clientConf.set("hbase.security.authentication", "simple");
        this.callRpcService(rpcImplClass, User.create((UserGroupInformation)clientUgi), clientConf, true);
    }

    static {
        HOST = "localhost";
    }

    public static class TestThread
    extends Thread {
        private final TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub;
        private final List<String> results;

        public TestThread(TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub, List<String> results) {
            this.stub = stub;
            this.results = results;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String result;
            try {
                result = this.stub.echo(null, TestProtos.EchoRequestProto.newBuilder().setMessage(String.valueOf(ThreadLocalRandom.current().nextInt())).build()).getMessage();
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
            if (this.results != null) {
                List<String> list = this.results;
                synchronized (list) {
                    this.results.add(result);
                }
            }
        }
    }
}

