/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRegionServerReportForDuty {
    private static final Log LOG = LogFactory.getLog(TestRegionServerReportForDuty.class);
    private static final long SLEEP_INTERVAL = 500L;
    private HBaseTestingUtility testUtil;
    private LocalHBaseCluster cluster;
    private JVMClusterUtil.RegionServerThread rs;
    private JVMClusterUtil.RegionServerThread rs2;
    private JVMClusterUtil.MasterThread master;
    private JVMClusterUtil.MasterThread backupMaster;

    @Before
    public void setUp() throws Exception {
        this.testUtil = new HBaseTestingUtility();
        this.testUtil.startMiniDFSCluster(1);
        this.testUtil.startMiniZKCluster(1, new int[0]);
        this.testUtil.createRootDir();
        this.cluster = new LocalHBaseCluster(this.testUtil.getConfiguration(), 0, 0);
    }

    @After
    public void tearDown() throws Exception {
        this.cluster.shutdown();
        this.cluster.join();
        this.testUtil.shutdownMiniZKCluster();
        this.testUtil.shutdownMiniDFSCluster();
    }

    @Test(timeout=180000L)
    public void testReportForDutyWithMasterChange() throws Exception {
        this.cluster.getConfiguration().setInt("hbase.master.port", HBaseTestingUtility.randomFreePort());
        this.cluster.getConfiguration().setInt("hbase.master.wait.on.regionservers.mintostart", 1);
        this.cluster.getConfiguration().setInt("hbase.master.wait.on.regionservers.maxtostart", 1);
        this.master = this.cluster.addMaster();
        this.rs = this.cluster.addRegionServer();
        LOG.debug((Object)("Starting master: " + this.master.getMaster().getServerName()));
        this.master.start();
        this.rs.start();
        this.waitForClusterOnline(this.master);
        this.cluster.getConfiguration().set("hbase.regionserver.impl", MyRegionServer.class.getName());
        this.rs2 = this.cluster.addRegionServer();
        LOG.debug((Object)("Starting 2nd region server: " + this.rs2.getRegionServer().getServerName()));
        this.rs2.start();
        this.waitForSecondRsStarted();
        this.master.getMaster().stop("Stopping master");
        this.cluster.getConfiguration().setInt("hbase.master.port", HBaseTestingUtility.randomFreePort());
        this.cluster.getConfiguration().setInt("hbase.master.wait.on.regionservers.mintostart", 2);
        this.cluster.getConfiguration().setInt("hbase.master.wait.on.regionservers.maxtostart", 2);
        this.backupMaster = this.cluster.addMaster();
        LOG.debug((Object)("Starting new master: " + this.backupMaster.getMaster().getServerName()));
        this.backupMaster.start();
        this.waitForClusterOnline(this.backupMaster);
        Assert.assertTrue((boolean)this.backupMaster.getMaster().isActiveMaster());
        Assert.assertTrue((boolean)this.backupMaster.getMaster().isInitialized());
        Assert.assertEquals((long)this.backupMaster.getMaster().getServerManager().getOnlineServersList().size(), (long)2L);
    }

    private void waitForClusterOnline(JVMClusterUtil.MasterThread master) throws InterruptedException {
        while (!master.getMaster().isInitialized()) {
            Thread.sleep(500L);
            LOG.debug((Object)"Waiting for master to come online ...");
        }
        this.rs.waitForServerOnline();
    }

    private void waitForSecondRsStarted() throws InterruptedException {
        while (!((MyRegionServer)this.rs2.getRegionServer()).getRpcStubCreatedFlag()) {
            Thread.sleep(500L);
            LOG.debug((Object)"Waiting 2nd RS to be started ...");
        }
    }

    public static class MyRegionServer
    extends MiniHBaseCluster.MiniHBaseClusterRegionServer {
        private ServerName sn;
        private boolean rpcStubCreatedFlag = false;
        private boolean masterChanged = false;

        public MyRegionServer(Configuration conf, CoordinatedStateManager cp) throws IOException, KeeperException, InterruptedException {
            super(conf, cp);
        }

        protected synchronized ServerName createRegionServerStatusStub(boolean refresh) {
            this.sn = super.createRegionServerStatusStub(refresh);
            this.rpcStubCreatedFlag = true;
            while (!this.masterChanged) {
                ServerName newSn = super.getMasterAddressTracker().getMasterAddress(true);
                if (newSn != null && !newSn.equals((Object)this.sn)) {
                    this.masterChanged = true;
                    break;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    return null;
                }
                LOG.debug((Object)"Waiting for master switch over ... ");
            }
            return this.sn;
        }

        public boolean getRpcStubCreatedFlag() {
            return this.rpcStubCreatedFlag;
        }
    }
}

