/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestSizeFailures {
    private static final Log LOG = LogFactory.getLog(TestSizeFailures.class);
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    protected static int SLAVES = 1;
    private static TableName TABLENAME;
    private static final int NUM_ROWS = 1000000;
    private static final int NUM_COLS = 10;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.table.sanity.checks", true);
        TEST_UTIL.startMiniCluster(SLAVES);
        TABLENAME = TableName.valueOf((String)"testSizeFailures");
        ArrayList<byte[]> qualifiers = new ArrayList<byte[]>();
        for (int i = 1; i <= 10; ++i) {
            qualifiers.add(Bytes.toBytes((String)Integer.toString(i)));
        }
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY);
        HTableDescriptor desc = new HTableDescriptor(TABLENAME);
        desc.addFamily(hcd);
        byte[][] splits = new byte[9][2];
        for (int i = 1; i < 10; ++i) {
            int split = 48 + i;
            splits[i - 1][0] = (byte)(split >>> 8);
            splits[i - 1][0] = (byte)split;
        }
        TEST_UTIL.getHBaseAdmin().createTable(desc, splits);
        Connection conn = TEST_UTIL.getConnection();
        try (Table table = conn.getTable(TABLENAME);){
            LinkedList<Put> puts = new LinkedList<Put>();
            for (int i = 0; i < 1000000; ++i) {
                Put p = new Put(Bytes.toBytes((String)Integer.toString(i)));
                for (int j = 0; j < 10; ++j) {
                    byte[] value = new byte[50];
                    Bytes.random((byte[])value);
                    p.addColumn(FAMILY, Bytes.toBytes((String)Integer.toString(j)), value);
                }
                puts.add(p);
                if (puts.size() != 1000) continue;
                table.batch(puts, new Object[1000]);
                puts.clear();
            }
            if (puts.size() > 0) {
                table.batch(puts, new Object[puts.size()]);
            }
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testScannerSeesAllRecords() throws Exception {
        Connection conn = TEST_UTIL.getConnection();
        try (Table table = conn.getTable(TABLENAME);){
            Scan s = new Scan();
            s.addFamily(FAMILY);
            s.setMaxResultSize(-1L);
            s.setBatch(-1);
            s.setCaching(500);
            Map.Entry<Long, Long> entry = this.sumTable(table.getScanner(s));
            long rowsObserved = entry.getKey();
            long entriesObserved = entry.getValue();
            Assert.assertEquals((long)1000000L, (long)rowsObserved);
            Assert.assertEquals((long)10000000L, (long)entriesObserved);
        }
    }

    @Test
    public void testSmallScannerSeesAllRecords() throws Exception {
        Connection conn = TEST_UTIL.getConnection();
        try (Table table = conn.getTable(TABLENAME);){
            Scan s = new Scan();
            s.setSmall(true);
            s.addFamily(FAMILY);
            s.setMaxResultSize(-1L);
            s.setBatch(-1);
            s.setCaching(500);
            Map.Entry<Long, Long> entry = this.sumTable(table.getScanner(s));
            long rowsObserved = entry.getKey();
            long entriesObserved = entry.getValue();
            Assert.assertEquals((long)1000000L, (long)rowsObserved);
            Assert.assertEquals((long)10000000L, (long)entriesObserved);
        }
    }

    private Map.Entry<Long, Long> sumTable(ResultScanner scanner) {
        long rowsObserved = 0L;
        long entriesObserved = 0L;
        for (Result result : scanner) {
            ++rowsObserved;
            while (result.advance()) {
                ++entriesObserved;
            }
        }
        return Maps.immutableEntry((Object)rowsObserved, (Object)entriesObserved);
    }
}

