/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.SecretKey;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.tez.common.CallableWithNdc;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.http.HttpConnectionParams;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.TaskFailureType;
import org.apache.tez.runtime.api.events.InputReadErrorEvent;
import org.apache.tez.runtime.library.common.CompositeInputAttemptIdentifier;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.TezRuntimeUtils;
import org.apache.tez.runtime.library.common.shuffle.FetchResult;
import org.apache.tez.runtime.library.common.shuffle.FetchedInput;
import org.apache.tez.runtime.library.common.shuffle.FetchedInputAllocator;
import org.apache.tez.runtime.library.common.shuffle.Fetcher;
import org.apache.tez.runtime.library.common.shuffle.FetcherCallback;
import org.apache.tez.runtime.library.common.shuffle.HostPort;
import org.apache.tez.runtime.library.common.shuffle.InputHost;
import org.apache.tez.runtime.library.common.shuffle.ShuffleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleManager
implements FetcherCallback {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleManager.class);
    private static final Logger LOG_FETCH = LoggerFactory.getLogger((String)(LOG.getName() + ".fetch"));
    private static final ShuffleUtils.FetchStatsLogger fetchStatsLogger = new ShuffleUtils.FetchStatsLogger(LOG_FETCH, LOG);
    private final InputContext inputContext;
    private final int numInputs;
    private final DecimalFormat mbpsFormat = new DecimalFormat("0.00");
    private final FetchedInputAllocator inputManager;
    @VisibleForTesting
    final ListeningExecutorService fetcherExecutor;
    private final ListeningExecutorService schedulerExecutor;
    private final RunShuffleCallable schedulerCallable;
    private final BlockingQueue<FetchedInput> completedInputs;
    private final AtomicBoolean inputReadyNotificationSent = new AtomicBoolean(false);
    @VisibleForTesting
    final BitSet completedInputSet;
    private final ConcurrentMap<HostPort, InputHost> knownSrcHosts;
    private final BlockingQueue<InputHost> pendingHosts;
    private final Set<InputAttemptIdentifier> obsoletedInputs;
    private Set<Fetcher> runningFetchers;
    private final AtomicInteger numCompletedInputs = new AtomicInteger(0);
    private final AtomicInteger numFetchedSpills = new AtomicInteger(0);
    private final long startTime;
    private long lastProgressTime;
    private long totalBytesShuffledTillNow;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition wakeLoop = this.lock.newCondition();
    private final int numFetchers;
    private final boolean asyncHttp;
    private final JobTokenSecretManager jobTokenSecretMgr;
    private final CompressionCodec codec;
    private final boolean localDiskFetchEnabled;
    private final boolean sharedFetchEnabled;
    private final boolean verifyDiskChecksum;
    private final boolean compositeFetch;
    private final int ifileBufferSize;
    private final boolean ifileReadAhead;
    private final int ifileReadAheadLength;
    private final String srcNameTrimmed;
    private final int maxTaskOutputAtOnce;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private final TezCounter shuffledInputsCounter;
    private final TezCounter failedShufflesCounter;
    private final TezCounter bytesShuffledCounter;
    private final TezCounter decompressedDataSizeCounter;
    private final TezCounter bytesShuffledToDiskCounter;
    private final TezCounter bytesShuffledToMemCounter;
    private final TezCounter bytesShuffledDirectDiskCounter;
    private volatile Throwable shuffleError;
    private final HttpConnectionParams httpConnectionParams;
    private final LocalDirAllocator localDirAllocator;
    private final RawLocalFileSystem localFs;
    private final Path[] localDisks;
    private final String localhostName;
    private final int shufflePort;
    private final TezCounter shufflePhaseTime;
    private final TezCounter firstEventReceived;
    private final TezCounter lastEventReceived;
    @VisibleForTesting
    final Map<Integer, ShuffleEventInfo> shuffleInfoEventsMap;
    private final AtomicInteger nextProgressLineEventCount = new AtomicInteger(0);

    public ShuffleManager(InputContext inputContext, Configuration conf, int numInputs, int bufferSize, boolean ifileReadAheadEnabled, int ifileReadAheadLength, CompressionCodec codec, FetchedInputAllocator inputAllocator) throws IOException {
        this.inputContext = inputContext;
        this.numInputs = numInputs;
        this.shuffledInputsCounter = inputContext.getCounters().findCounter((Enum)TaskCounter.NUM_SHUFFLED_INPUTS);
        this.failedShufflesCounter = inputContext.getCounters().findCounter((Enum)TaskCounter.NUM_FAILED_SHUFFLE_INPUTS);
        this.bytesShuffledCounter = inputContext.getCounters().findCounter((Enum)TaskCounter.SHUFFLE_BYTES);
        this.decompressedDataSizeCounter = inputContext.getCounters().findCounter((Enum)TaskCounter.SHUFFLE_BYTES_DECOMPRESSED);
        this.bytesShuffledToDiskCounter = inputContext.getCounters().findCounter((Enum)TaskCounter.SHUFFLE_BYTES_TO_DISK);
        this.bytesShuffledToMemCounter = inputContext.getCounters().findCounter((Enum)TaskCounter.SHUFFLE_BYTES_TO_MEM);
        this.bytesShuffledDirectDiskCounter = inputContext.getCounters().findCounter((Enum)TaskCounter.SHUFFLE_BYTES_DISK_DIRECT);
        this.ifileBufferSize = bufferSize;
        this.ifileReadAhead = ifileReadAheadEnabled;
        this.ifileReadAheadLength = ifileReadAheadLength;
        this.codec = codec;
        this.inputManager = inputAllocator;
        this.localDiskFetchEnabled = conf.getBoolean("tez.runtime.optimize.local.fetch", true);
        this.sharedFetchEnabled = conf.getBoolean("tez.runtime.optimize.shared.fetch", false);
        this.verifyDiskChecksum = conf.getBoolean("tez.runtime.shuffle.fetch.verify-disk-checksum", true);
        this.shufflePhaseTime = inputContext.getCounters().findCounter((Enum)TaskCounter.SHUFFLE_PHASE_TIME);
        this.firstEventReceived = inputContext.getCounters().findCounter((Enum)TaskCounter.FIRST_EVENT_RECEIVED);
        this.lastEventReceived = inputContext.getCounters().findCounter((Enum)TaskCounter.LAST_EVENT_RECEIVED);
        this.compositeFetch = ShuffleUtils.isTezShuffleHandler(conf);
        this.srcNameTrimmed = TezUtilsInternal.cleanVertexName((String)inputContext.getSourceVertexName());
        this.completedInputSet = new BitSet(numInputs);
        this.completedInputs = new LinkedBlockingDeque<FetchedInput>();
        this.knownSrcHosts = new ConcurrentHashMap<HostPort, InputHost>();
        this.pendingHosts = new LinkedBlockingQueue<InputHost>();
        this.obsoletedInputs = Collections.newSetFromMap(new ConcurrentHashMap());
        this.runningFetchers = Collections.newSetFromMap(new ConcurrentHashMap());
        int maxConfiguredFetchers = conf.getInt("tez.runtime.shuffle.parallel.copies", 20);
        this.numFetchers = Math.min(maxConfiguredFetchers, numInputs);
        ExecutorService fetcherRawExecutor = conf.getBoolean("tez.runtime.shuffle.fetcher.use-shared-pool", false) ? inputContext.createTezFrameworkExecutorService(this.numFetchers, "Fetcher_B {" + this.srcNameTrimmed + "} #%d") : Executors.newFixedThreadPool(this.numFetchers, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Fetcher_B {" + this.srcNameTrimmed + "} #%d").build());
        this.fetcherExecutor = MoreExecutors.listeningDecorator((ExecutorService)fetcherRawExecutor);
        ExecutorService schedulerRawExecutor = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ShuffleRunner {" + this.srcNameTrimmed + "}").build());
        this.schedulerExecutor = MoreExecutors.listeningDecorator((ExecutorService)schedulerRawExecutor);
        this.schedulerCallable = new RunShuffleCallable(conf);
        this.lastProgressTime = this.startTime = System.currentTimeMillis();
        String auxiliaryService = conf.get("tez.am.shuffle.auxiliary-service.id", "mapreduce_shuffle");
        SecretKey shuffleSecret = ShuffleUtils.getJobTokenSecretFromTokenBytes(inputContext.getServiceConsumerMetaData(auxiliaryService));
        this.jobTokenSecretMgr = new JobTokenSecretManager(shuffleSecret);
        this.asyncHttp = conf.getBoolean("tez.runtime.shuffle.use.async.http", false);
        this.httpConnectionParams = ShuffleUtils.getHttpConnectionParams(conf);
        this.localFs = (RawLocalFileSystem)FileSystem.getLocal((Configuration)conf).getRaw();
        this.localDirAllocator = new LocalDirAllocator("tez.runtime.framework.local.dirs");
        this.localDisks = (Path[])Iterables.toArray((Iterable)this.localDirAllocator.getAllLocalPathsToRead(".", conf), Path.class);
        this.localhostName = inputContext.getExecutionContext().getHostName();
        ByteBuffer shuffleMetaData = inputContext.getServiceProviderMetaData(auxiliaryService);
        this.shufflePort = ShuffleUtils.deserializeShuffleProviderMetaData(shuffleMetaData);
        this.maxTaskOutputAtOnce = Math.max(1, Math.min(75, conf.getInt("tez.runtime.shuffle.fetch.max.task.output.at.once", 20)));
        Arrays.sort(this.localDisks);
        this.shuffleInfoEventsMap = new ConcurrentHashMap<Integer, ShuffleEventInfo>();
        LOG.info(this.srcNameTrimmed + ": numInputs=" + numInputs + ", compressionCodec=" + (codec == null ? "NoCompressionCodec" : codec.getClass().getName()) + ", numFetchers=" + this.numFetchers + ", ifileBufferSize=" + this.ifileBufferSize + ", ifileReadAheadEnabled=" + this.ifileReadAhead + ", ifileReadAheadLength=" + ifileReadAheadLength + ", localDiskFetchEnabled=" + this.localDiskFetchEnabled + ", sharedFetchEnabled=" + this.sharedFetchEnabled + ", " + this.httpConnectionParams.toString() + ", maxTaskOutputAtOnce=" + this.maxTaskOutputAtOnce);
    }

    public void run() throws IOException {
        Preconditions.checkState((this.inputManager != null ? 1 : 0) != 0, (Object)"InputManager must be configured");
        ListenableFuture runShuffleFuture = this.schedulerExecutor.submit((Callable)((Object)this.schedulerCallable));
        Futures.addCallback((ListenableFuture)runShuffleFuture, (FutureCallback)new SchedulerFutureCallback());
        this.schedulerExecutor.shutdown();
    }

    private boolean validateInputAttemptForPipelinedShuffle(InputAttemptIdentifier input) {
        ShuffleEventInfo eventInfo;
        if (input.canRetrieveInputInChunks() && (eventInfo = this.shuffleInfoEventsMap.get(input.getInputIdentifier())) != null && input.getAttemptNumber() != eventInfo.attemptNum && (eventInfo.scheduledForDownload || !eventInfo.eventsProcessed.isEmpty())) {
            IOException exception = new IOException("Previous event already got scheduled for " + input + ". Previous attempt's data could have been already merged to memory/disk outputs.  Killing (self) this task early. currentAttemptNum=" + eventInfo.attemptNum + ", eventsProcessed=" + eventInfo.eventsProcessed + ", scheduledForDownload=" + eventInfo.scheduledForDownload + ", newAttemptNum=" + input.getAttemptNumber());
            String message = "Killing self as previous attempt data could have been consumed";
            this.killSelf(exception, message);
            return false;
        }
        return true;
    }

    void killSelf(Exception exception, String message) {
        LOG.error(message, (Throwable)exception);
        this.inputContext.killSelf((Throwable)exception, message);
    }

    @VisibleForTesting
    Fetcher constructFetcherForHost(InputHost inputHost, Configuration conf) {
        Path lockDisk = null;
        if (this.sharedFetchEnabled) {
            int h = Math.abs(Objects.hashCode((Object[])new Object[]{this.srcNameTrimmed, inputHost.getHost()}));
            lockDisk = new Path(this.localDisks[h % this.localDisks.length], "locks");
        }
        Fetcher.FetcherBuilder fetcherBuilder = new Fetcher.FetcherBuilder(this, this.httpConnectionParams, this.inputManager, this.inputContext.getApplicationId(), this.inputContext.getDagIdentifier(), this.jobTokenSecretMgr, this.srcNameTrimmed, conf, this.localFs, this.localDirAllocator, lockDisk, this.localDiskFetchEnabled, this.sharedFetchEnabled, this.localhostName, this.shufflePort, this.asyncHttp, this.verifyDiskChecksum, this.compositeFetch);
        if (this.codec != null) {
            fetcherBuilder.setCompressionParameters(this.codec);
        }
        fetcherBuilder.setIFileParams(this.ifileReadAhead, this.ifileReadAheadLength);
        InputHost.PartitionToInputs pendingInputsOfOnePartitionRange = inputHost.clearAndGetOnePartitionRange();
        int includedMaps = 0;
        Iterator<InputAttemptIdentifier> inputIter = pendingInputsOfOnePartitionRange.getInputs().iterator();
        while (inputIter.hasNext()) {
            int maxClearBit;
            CompositeInputAttemptIdentifier compositeInput;
            int nextClearBit;
            InputAttemptIdentifier input = inputIter.next();
            if (!this.validateInputAttemptForPipelinedShuffle(input)) continue;
            boolean alreadyCompleted = input instanceof CompositeInputAttemptIdentifier ? (nextClearBit = this.completedInputSet.nextClearBit((compositeInput = (CompositeInputAttemptIdentifier)input).getInputIdentifier())) > (maxClearBit = compositeInput.getInputIdentifier() + compositeInput.getInputIdentifierCount()) : this.completedInputSet.get(input.getInputIdentifier());
            if (alreadyCompleted || this.obsoletedInputs.contains(input)) {
                inputIter.remove();
                continue;
            }
            if (includedMaps >= this.maxTaskOutputAtOnce) {
                inputIter.remove();
                inputHost.addKnownInput(pendingInputsOfOnePartitionRange.getPartition(), pendingInputsOfOnePartitionRange.getPartitionCount(), input);
                continue;
            }
            ++includedMaps;
        }
        if (inputHost.getNumPendingPartitions() > 0) {
            this.pendingHosts.add(inputHost);
        }
        for (InputAttemptIdentifier input : pendingInputsOfOnePartitionRange.getInputs()) {
            ShuffleEventInfo eventInfo = this.shuffleInfoEventsMap.get(input.getInputIdentifier());
            if (eventInfo == null) continue;
            eventInfo.scheduledForDownload = true;
        }
        fetcherBuilder.assignWork(inputHost.getHost(), inputHost.getPort(), pendingInputsOfOnePartitionRange.getPartition(), pendingInputsOfOnePartitionRange.getPartitionCount(), pendingInputsOfOnePartitionRange.getInputs());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created Fetcher for host: " + inputHost.getHost() + ", info: " + inputHost.getAdditionalInfo() + ", with inputs: " + pendingInputsOfOnePartitionRange);
        }
        return fetcherBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKnownInput(String hostName, int port, CompositeInputAttemptIdentifier srcAttemptIdentifier, int srcPhysicalIndex) {
        InputHost old;
        HostPort identifier = new HostPort(hostName, port);
        InputHost host = (InputHost)this.knownSrcHosts.get(identifier);
        if (host == null && (old = this.knownSrcHosts.putIfAbsent(identifier, host = new InputHost(identifier))) != null) {
            host = old;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.srcNameTrimmed + ": Adding input: " + srcAttemptIdentifier + ", to host: " + host);
        }
        if (!this.validateInputAttemptForPipelinedShuffle(srcAttemptIdentifier)) {
            return;
        }
        int inputIdentifier = srcAttemptIdentifier.getInputIdentifier();
        for (int i = 0; i < srcAttemptIdentifier.getInputIdentifierCount(); ++i) {
            if (this.shuffleInfoEventsMap.get(inputIdentifier + i) != null) continue;
            this.shuffleInfoEventsMap.put(inputIdentifier + i, new ShuffleEventInfo(srcAttemptIdentifier.expand(i)));
        }
        host.addKnownInput(srcPhysicalIndex, srcAttemptIdentifier.getInputIdentifierCount(), srcAttemptIdentifier);
        this.lock.lock();
        try {
            boolean added = this.pendingHosts.offer(host);
            if (!added) {
                String errorMessage = "Unable to add host: " + host.getIdentifier() + " to pending queue";
                LOG.error(errorMessage);
                throw new TezUncheckedException(errorMessage);
            }
            this.wakeLoop.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompletedInputWithNoData(InputAttemptIdentifier srcAttemptIdentifier) {
        int inputIdentifier = srcAttemptIdentifier.getInputIdentifier();
        if (LOG.isDebugEnabled()) {
            LOG.debug("No input data exists for SrcTask: " + inputIdentifier + ". Marking as complete.");
        }
        this.lock.lock();
        try {
            if (!this.completedInputSet.get(inputIdentifier)) {
                NullFetchedInput fetchedInput = new NullFetchedInput(srcAttemptIdentifier);
                if (!srcAttemptIdentifier.canRetrieveInputInChunks()) {
                    this.registerCompletedInput(fetchedInput);
                } else {
                    this.registerCompletedInputForPipelinedShuffle(srcAttemptIdentifier, fetchedInput);
                }
            }
            this.wakeLoop.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected synchronized void updateEventReceivedTime() {
        long relativeTime = System.currentTimeMillis() - this.startTime;
        if (this.firstEventReceived.getValue() == 0L) {
            this.firstEventReceived.setValue(relativeTime);
            this.lastEventReceived.setValue(relativeTime);
            return;
        }
        this.lastEventReceived.setValue(relativeTime);
    }

    void obsoleteKnownInput(InputAttemptIdentifier srcAttemptIdentifier) {
        this.obsoletedInputs.add(srcAttemptIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetchSucceeded(String host, InputAttemptIdentifier srcAttemptIdentifier, FetchedInput fetchedInput, long fetchedBytes, long decompressedLength, long copyDuration) throws IOException {
        int inputIdentifier = srcAttemptIdentifier.getInputIdentifier();
        this.lock.lock();
        try {
            this.lastProgressTime = System.currentTimeMillis();
            this.inputContext.notifyProgress();
            if (!this.completedInputSet.get(inputIdentifier)) {
                fetchedInput.commit();
                fetchStatsLogger.logIndividualFetchComplete(copyDuration, fetchedBytes, decompressedLength, fetchedInput.getType().toString(), srcAttemptIdentifier);
                this.shuffledInputsCounter.increment(1L);
                this.bytesShuffledCounter.increment(fetchedBytes);
                if (fetchedInput.getType() == FetchedInput.Type.MEMORY) {
                    this.bytesShuffledToMemCounter.increment(fetchedBytes);
                } else if (fetchedInput.getType() == FetchedInput.Type.DISK) {
                    this.bytesShuffledToDiskCounter.increment(fetchedBytes);
                } else if (fetchedInput.getType() == FetchedInput.Type.DISK_DIRECT) {
                    this.bytesShuffledDirectDiskCounter.increment(fetchedBytes);
                }
                this.decompressedDataSizeCounter.increment(decompressedLength);
                if (!srcAttemptIdentifier.canRetrieveInputInChunks()) {
                    this.registerCompletedInput(fetchedInput);
                } else {
                    this.registerCompletedInputForPipelinedShuffle(srcAttemptIdentifier, fetchedInput);
                }
                this.totalBytesShuffledTillNow += fetchedBytes;
                this.logProgress();
                this.wakeLoop.signal();
            } else {
                fetchedInput.abort();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void registerCompletedInput(FetchedInput fetchedInput) {
        this.lock.lock();
        try {
            this.maybeInformInputReady(fetchedInput);
            this.adjustCompletedInputs(fetchedInput);
            this.numFetchedSpills.getAndIncrement();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void maybeInformInputReady(FetchedInput fetchedInput) {
        this.lock.lock();
        try {
            if (!(fetchedInput instanceof NullFetchedInput)) {
                this.completedInputs.add(fetchedInput);
            }
            if (!this.inputReadyNotificationSent.getAndSet(true)) {
                this.inputContext.inputIsReady();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void adjustCompletedInputs(FetchedInput fetchedInput) {
        this.lock.lock();
        try {
            this.completedInputSet.set(fetchedInput.getInputAttemptIdentifier().getInputIdentifier());
            int numComplete = this.numCompletedInputs.incrementAndGet();
            if (numComplete == this.numInputs) {
                if (fetchedInput instanceof NullFetchedInput) {
                    this.completedInputs.add(fetchedInput);
                }
                LOG.info("All inputs fetched for input vertex : " + this.inputContext.getSourceVertexName());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCompletedInputForPipelinedShuffle(InputAttemptIdentifier srcAttemptIdentifier, FetchedInput fetchedInput) {
        if (!this.validateInputAttemptForPipelinedShuffle(srcAttemptIdentifier)) {
            return;
        }
        int inputIdentifier = srcAttemptIdentifier.getInputIdentifier();
        ShuffleEventInfo eventInfo = this.shuffleInfoEventsMap.get(inputIdentifier);
        if (eventInfo == null && fetchedInput instanceof NullFetchedInput) {
            eventInfo = new ShuffleEventInfo(srcAttemptIdentifier);
            this.shuffleInfoEventsMap.put(inputIdentifier, eventInfo);
        }
        assert (eventInfo != null);
        eventInfo.spillProcessed(srcAttemptIdentifier.getSpillEventId());
        this.numFetchedSpills.getAndIncrement();
        if (srcAttemptIdentifier.getFetchTypeInfo() == InputAttemptIdentifier.SPILL_INFO.FINAL_UPDATE) {
            eventInfo.setFinalEventId(srcAttemptIdentifier.getSpillEventId());
        }
        this.lock.lock();
        try {
            this.maybeInformInputReady(fetchedInput);
            if (eventInfo.isDone()) {
                this.adjustCompletedInputs(fetchedInput);
                this.shuffleInfoEventsMap.remove(srcAttemptIdentifier.getInputIdentifier());
            }
        }
        finally {
            this.lock.unlock();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("eventInfo " + eventInfo.toString());
        }
    }

    private void reportFatalError(Throwable exception, String message) {
        LOG.error(message);
        this.inputContext.reportFailure(TaskFailureType.NON_FATAL, exception, message);
    }

    @Override
    public void fetchFailed(String host, InputAttemptIdentifier srcAttemptIdentifier, boolean connectFailed) {
        LOG.info(this.srcNameTrimmed + ": Fetch failed for src: " + srcAttemptIdentifier + "InputIdentifier: " + srcAttemptIdentifier + ", connectFailed: " + connectFailed);
        this.failedShufflesCounter.increment(1L);
        this.inputContext.notifyProgress();
        if (srcAttemptIdentifier == null) {
            this.reportFatalError(null, "Received fetchFailure for an unknown src (null)");
        } else {
            InputReadErrorEvent readError = InputReadErrorEvent.create((String)("Fetch failure while fetching from " + TezRuntimeUtils.getTaskAttemptIdentifier(this.inputContext.getSourceVertexName(), srcAttemptIdentifier.getInputIdentifier(), srcAttemptIdentifier.getAttemptNumber())), (int)srcAttemptIdentifier.getInputIdentifier(), (int)srcAttemptIdentifier.getAttemptNumber());
            ArrayList failedEvents = Lists.newArrayListWithCapacity((int)1);
            failedEvents.add(readError);
            this.inputContext.sendEvents((List)failedEvents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            LOG.info(this.srcNameTrimmed + ": Thread interrupted. Need to cleanup the local dirs");
        }
        if (!this.isShutdown.getAndSet(true)) {
            LOG.info("Shutting down pending fetchers on source" + this.srcNameTrimmed + ": " + this.runningFetchers.size());
            this.lock.lock();
            try {
                this.wakeLoop.signal();
                for (Fetcher fetcher : this.runningFetchers) {
                    try {
                        fetcher.shutdown();
                    }
                    catch (Exception e) {
                        LOG.warn("Error while stopping fetcher during shutdown. Ignoring and continuing. Message={}", (Object)e.getMessage());
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
            if (this.schedulerExecutor != null && !this.schedulerExecutor.isShutdown()) {
                this.schedulerExecutor.shutdownNow();
            }
            if (this.fetcherExecutor != null && !this.fetcherExecutor.isShutdown()) {
                this.fetcherExecutor.shutdownNow();
            }
        }
    }

    public boolean allInputsFetched() {
        this.lock.lock();
        try {
            boolean bl = this.numCompletedInputs.get() == this.numInputs;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public FetchedInput getNextInput() throws InterruptedException {
        this.lock.lock();
        try {
            if (this.completedInputs.peek() == null && this.allInputsFetched()) {
                FetchedInput fetchedInput = null;
                return fetchedInput;
            }
        }
        finally {
            this.lock.unlock();
        }
        FetchedInput fetchedInput = this.completedInputs.take();
        if (fetchedInput instanceof NullFetchedInput) {
            fetchedInput = null;
        }
        return fetchedInput;
    }

    public int getNumInputs() {
        return this.numInputs;
    }

    public float getNumCompletedInputsFloat() {
        return this.numCompletedInputs.floatValue();
    }

    private void logProgress() {
        int inputsDone = this.numCompletedInputs.get();
        if (inputsDone > this.nextProgressLineEventCount.get() || inputsDone == this.numInputs) {
            this.nextProgressLineEventCount.addAndGet(50);
            double mbs = (double)this.totalBytesShuffledTillNow / 1048576.0;
            long secsSinceStart = (System.currentTimeMillis() - this.startTime) / 1000L + 1L;
            double transferRate = mbs / (double)secsSinceStart;
            LOG.info("copy(" + inputsDone + " (spillsFetched=" + this.numFetchedSpills.get() + ") of " + this.numInputs + ". Transfer rate (CumulativeDataFetched/TimeSinceInputStarted)) " + this.mbpsFormat.format(transferRate) + " MB/s)");
        }
    }

    private class FetchFutureCallback
    implements FutureCallback<FetchResult> {
        private final Fetcher fetcher;

        public FetchFutureCallback(Fetcher fetcher) {
            this.fetcher = fetcher;
        }

        private void doBookKeepingForFetcherComplete() {
            ShuffleManager.this.lock.lock();
            try {
                ShuffleManager.this.runningFetchers.remove((Object)this.fetcher);
                ShuffleManager.this.wakeLoop.signal();
            }
            finally {
                ShuffleManager.this.lock.unlock();
            }
        }

        public void onSuccess(FetchResult result) {
            this.fetcher.shutdown();
            if (ShuffleManager.this.isShutdown.get()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(ShuffleManager.this.srcNameTrimmed + ": Already shutdown. Ignoring event from fetcher");
                }
            } else {
                Iterable<InputAttemptIdentifier> pendingInputs = result.getPendingInputs();
                if (pendingInputs != null && pendingInputs.iterator().hasNext()) {
                    HostPort identifier = new HostPort(result.getHost(), result.getPort());
                    InputHost inputHost = (InputHost)ShuffleManager.this.knownSrcHosts.get(identifier);
                    assert (inputHost != null);
                    for (InputAttemptIdentifier input : pendingInputs) {
                        inputHost.addKnownInput(result.getPartition(), result.getPartitionCount(), input);
                    }
                    inputHost.setAdditionalInfo(result.getAdditionalInfo());
                    ShuffleManager.this.pendingHosts.add(inputHost);
                }
                this.doBookKeepingForFetcherComplete();
            }
        }

        public void onFailure(Throwable t) {
            this.fetcher.shutdown();
            if (ShuffleManager.this.isShutdown.get()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(ShuffleManager.this.srcNameTrimmed + ": Already shutdown. Ignoring error from fetcher: " + t);
                }
            } else {
                LOG.error(ShuffleManager.this.srcNameTrimmed + ": Fetcher failed with error: ", t);
                ShuffleManager.this.shuffleError = t;
                ShuffleManager.this.inputContext.reportFailure(TaskFailureType.NON_FATAL, t, "Fetch failed");
                this.doBookKeepingForFetcherComplete();
            }
        }
    }

    private class SchedulerFutureCallback
    implements FutureCallback<Void> {
        private SchedulerFutureCallback() {
        }

        public void onSuccess(Void result) {
            LOG.info(ShuffleManager.this.srcNameTrimmed + ": Scheduler thread completed");
        }

        public void onFailure(Throwable t) {
            if (ShuffleManager.this.isShutdown.get()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(ShuffleManager.this.srcNameTrimmed + ": Already shutdown. Ignoring error: " + t);
                }
            } else {
                LOG.error(ShuffleManager.this.srcNameTrimmed + ": Scheduler failed with error: ", t);
                ShuffleManager.this.inputContext.reportFailure(TaskFailureType.NON_FATAL, t, "Shuffle Scheduler Failed");
            }
        }
    }

    @VisibleForTesting
    static class NullFetchedInput
    extends FetchedInput {
        public NullFetchedInput(InputAttemptIdentifier inputAttemptIdentifier) {
            super(inputAttemptIdentifier, null);
        }

        @Override
        public FetchedInput.Type getType() {
            return FetchedInput.Type.MEMORY;
        }

        @Override
        public long getSize() {
            return -1L;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException("Not supported for NullFetchedInput");
        }

        @Override
        public InputStream getInputStream() throws IOException {
            throw new UnsupportedOperationException("Not supported for NullFetchedInput");
        }

        @Override
        public void commit() throws IOException {
            throw new UnsupportedOperationException("Not supported for NullFetchedInput");
        }

        @Override
        public void abort() throws IOException {
            throw new UnsupportedOperationException("Not supported for NullFetchedInput");
        }

        @Override
        public void free() {
            throw new UnsupportedOperationException("Not supported for NullFetchedInput");
        }
    }

    static class ShuffleEventInfo {
        BitSet eventsProcessed;
        int finalEventId = -1;
        int attemptNum;
        String id;
        boolean scheduledForDownload;

        ShuffleEventInfo(InputAttemptIdentifier input) {
            this.id = input.getInputIdentifier() + "_" + input.getAttemptNumber();
            this.eventsProcessed = new BitSet();
            this.attemptNum = input.getAttemptNumber();
        }

        void spillProcessed(int spillId) {
            if (this.finalEventId != -1) {
                Preconditions.checkState((this.eventsProcessed.cardinality() <= this.finalEventId + 1 ? 1 : 0) != 0, (Object)("Wrong state. eventsProcessed cardinality=" + this.eventsProcessed.cardinality() + " finalEventId=" + this.finalEventId + ", spillId=" + spillId + ", " + this.toString()));
            }
            this.eventsProcessed.set(spillId);
        }

        void setFinalEventId(int spillId) {
            this.finalEventId = spillId;
        }

        boolean isDone() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("finalEventId=" + this.finalEventId + ", eventsProcessed cardinality=" + this.eventsProcessed.cardinality());
            }
            return this.finalEventId != -1 && this.finalEventId + 1 == this.eventsProcessed.cardinality();
        }

        public String toString() {
            return "[eventsProcessed=" + this.eventsProcessed + ", finalEventId=" + this.finalEventId + ", id=" + this.id + ", attemptNum=" + this.attemptNum + ", scheduledForDownload=" + this.scheduledForDownload + "]";
        }
    }

    private class RunShuffleCallable
    extends CallableWithNdc<Void> {
        private final Configuration conf;

        public RunShuffleCallable(Configuration conf) {
            this.conf = conf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void callInternal() throws Exception {
            block8: while (!ShuffleManager.this.isShutdown.get() && ShuffleManager.this.numCompletedInputs.get() < ShuffleManager.this.numInputs) {
                ShuffleManager.this.lock.lock();
                try {
                    while ((ShuffleManager.this.runningFetchers.size() >= ShuffleManager.this.numFetchers || ShuffleManager.this.pendingHosts.isEmpty()) && ShuffleManager.this.numCompletedInputs.get() < ShuffleManager.this.numInputs) {
                        ShuffleManager.this.inputContext.notifyProgress();
                        boolean ret = ShuffleManager.this.wakeLoop.await(1000L, TimeUnit.MILLISECONDS);
                        if (!ShuffleManager.this.isShutdown.get()) continue;
                        break;
                    }
                }
                finally {
                    ShuffleManager.this.lock.unlock();
                }
                if (ShuffleManager.this.shuffleError != null) break;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(ShuffleManager.this.srcNameTrimmed + ": NumCompletedInputs: " + ShuffleManager.this.numCompletedInputs);
                }
                if (ShuffleManager.this.numCompletedInputs.get() >= ShuffleManager.this.numInputs || ShuffleManager.this.isShutdown.get()) continue;
                ShuffleManager.this.lock.lock();
                try {
                    int maxFetchersToRun = ShuffleManager.this.numFetchers - ShuffleManager.this.runningFetchers.size();
                    int count = 0;
                    while (ShuffleManager.this.pendingHosts.peek() != null && !ShuffleManager.this.isShutdown.get()) {
                        InputHost inputHost = null;
                        try {
                            inputHost = (InputHost)ShuffleManager.this.pendingHosts.take();
                        }
                        catch (InterruptedException e) {
                            if (ShuffleManager.this.isShutdown.get()) {
                                LOG.info(ShuffleManager.this.srcNameTrimmed + ": Interrupted and hasBeenShutdown, Breaking out of ShuffleScheduler Loop");
                                Thread.currentThread().interrupt();
                                continue block8;
                            }
                            throw e;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(ShuffleManager.this.srcNameTrimmed + ": Processing pending host: " + inputHost.toDetailedString());
                        }
                        if (inputHost.getNumPendingPartitions() > 0 && !ShuffleManager.this.isShutdown.get()) {
                            Fetcher fetcher = ShuffleManager.this.constructFetcherForHost(inputHost, this.conf);
                            ShuffleManager.this.runningFetchers.add(fetcher);
                            if (ShuffleManager.this.isShutdown.get()) {
                                LOG.info(ShuffleManager.this.srcNameTrimmed + ": hasBeenShutdown,Breaking out of ShuffleScheduler Loop");
                                continue block8;
                            }
                            ListenableFuture future = ShuffleManager.this.fetcherExecutor.submit((Callable)((Object)fetcher));
                            Futures.addCallback((ListenableFuture)future, (FutureCallback)new FetchFutureCallback(fetcher));
                            if (++count < maxFetchersToRun) continue;
                            continue block8;
                        }
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug(ShuffleManager.this.srcNameTrimmed + ": Skipping host: " + inputHost.getIdentifier() + " since it has no inputs to process");
                    }
                }
                finally {
                    ShuffleManager.this.lock.unlock();
                }
            }
            ShuffleManager.this.shufflePhaseTime.setValue(System.currentTimeMillis() - ShuffleManager.this.startTime);
            LOG.info(ShuffleManager.this.srcNameTrimmed + ": Shutting down FetchScheduler, Was Interrupted: " + Thread.currentThread().isInterrupted());
            if (!ShuffleManager.this.fetcherExecutor.isShutdown()) {
                ShuffleManager.this.fetcherExecutor.shutdownNow();
            }
            return null;
        }
    }
}

