/*
 * Decompiled with CFR 0.152.
 */
package junit.swingui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

class ProgressBar
extends JPanel {
    public boolean fError = false;
    public int fTotal = 0;
    public int fProgress = 0;
    public int fProgressX = 0;

    public ProgressBar() {
        this.setBorder(BorderFactory.createBevelBorder(1));
    }

    private Color getStatusColor() {
        if (this.fError) {
            return Color.red;
        }
        return Color.green;
    }

    public void paintBackground(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void paintComponent(Graphics graphics) {
        this.paintBackground(graphics);
        this.paintStatus(graphics);
    }

    public void paintStatus(Graphics graphics) {
        graphics.setColor(this.getStatusColor());
        Rectangle rectangle = new Rectangle(0, 0, this.fProgressX, this.getBounds().height);
        graphics.fillRect(1, 1, rectangle.width - 1, rectangle.height - 2);
    }

    private void paintStep(int n, int n2) {
        this.repaint(n, 1, n2 - n, this.getBounds().height - 2);
    }

    public void reset() {
        this.fProgressX = 1;
        this.fProgress = 0;
        this.fError = false;
        this.repaint();
    }

    public int scale(int n) {
        if (this.fTotal > 0) {
            return Math.max(1, n * (this.getBounds().width - 1) / this.fTotal);
        }
        return n;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.fProgressX = this.scale(this.fProgress);
    }

    public void start(int n) {
        this.fTotal = n;
        this.reset();
    }

    public void step(boolean bl) {
        ++this.fProgress;
        int n = this.fProgressX;
        this.fProgressX = this.scale(this.fProgress);
        if (!this.fError && !bl) {
            this.fError = true;
            n = 1;
        }
        this.paintStep(n, this.fProgressX);
    }
}

