/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestResult;

public abstract class TestCase
extends Assert
implements Test {
    private final String fName;

    public TestCase(String string) {
        this.fName = string;
    }

    public int countTestCases() {
        return 1;
    }

    protected TestResult createResult() {
        return new TestResult();
    }

    public String name() {
        return this.fName;
    }

    public TestResult run() {
        TestResult testResult = this.createResult();
        this.run(testResult);
        return testResult;
    }

    public void run(TestResult testResult) {
        testResult.run(this);
    }

    public void runBare() throws Throwable {
        this.setUp();
        try {
            this.runTest();
        }
        finally {
            Object var2_1 = null;
            this.tearDown();
        }
    }

    protected void runTest() throws Throwable {
        Method method = null;
        try {
            method = this.getClass().getMethod(this.fName, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Assert.fail("Method \"" + this.fName + "\" not found");
        }
        if (method != null && !Modifier.isPublic(method.getModifiers())) {
            Assert.fail("Method \"" + this.fName + "\" should be public");
        }
        try {
            method.invoke((Object)this, (Object[])new Class[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.fillInStackTrace();
            throw invocationTargetException.getTargetException();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.fillInStackTrace();
            throw illegalAccessException;
        }
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public String toString() {
        return String.valueOf(this.name()) + "(" + this.getClass().getName() + ")";
    }
}

