/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
public class FailedServers {
    private final LinkedList<Pair<Long, String>> failedServers = new LinkedList();
    private final int recheckServersTimeout;

    public FailedServers(Configuration conf) {
        this.recheckServersTimeout = conf.getInt("hbase.ipc.client.failed.servers.expiry", 2000);
    }

    public synchronized void addToFailedServers(InetSocketAddress address) {
        long expiry = EnvironmentEdgeManager.currentTime() + (long)this.recheckServersTimeout;
        this.failedServers.addFirst((Pair<Long, String>)new Pair((Object)expiry, (Object)address.toString()));
    }

    public synchronized boolean isFailedServer(InetSocketAddress address) {
        if (this.failedServers.isEmpty()) {
            return false;
        }
        String lookup = address.toString();
        long now = EnvironmentEdgeManager.currentTime();
        Iterator it = this.failedServers.iterator();
        while (it.hasNext()) {
            Pair cur = (Pair)it.next();
            if ((Long)cur.getFirst() < now) {
                it.remove();
                continue;
            }
            if (!lookup.equals(cur.getSecond())) continue;
            return true;
        }
        return false;
    }
}

