/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.accumulo.core.util.shell.Token;
import org.apache.commons.cli.CommandLine;

public class UserCommand
extends Shell.Command {
    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, IOException {
        String user = cl.getArgs()[0];
        String p = shellState.readMaskedLine("Enter password for user " + user + ": ", Character.valueOf('*'));
        if (p == null) {
            shellState.getReader().printNewline();
            return 0;
        }
        byte[] pass = p.getBytes();
        shellState.updateUser(user, new PasswordToken(pass));
        return 0;
    }

    @Override
    public String description() {
        return "switches to the specified user";
    }

    @Override
    public void registerCompletion(Token root, Map<Shell.Command.CompletionSet, Set<String>> special) {
        this.registerCompletionForUsers(root, special);
    }

    @Override
    public String usage() {
        return this.getName() + " <username>";
    }

    @Override
    public int numArgs() {
        return 1;
    }
}

