/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mock;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.admin.ActiveCompaction;
import org.apache.accumulo.core.client.admin.ActiveScan;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.client.mock.MockAccumulo;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;

public class MockInstanceOperations
implements InstanceOperations {
    MockAccumulo acu;

    public MockInstanceOperations(MockAccumulo acu) {
        this.acu = acu;
    }

    @Override
    public void setProperty(String property, String value) throws AccumuloException, AccumuloSecurityException {
        this.acu.setProperty(property, value);
    }

    @Override
    public void removeProperty(String property) throws AccumuloException, AccumuloSecurityException {
        this.acu.removeProperty(property);
    }

    @Override
    public Map<String, String> getSystemConfiguration() throws AccumuloException, AccumuloSecurityException {
        return this.acu.systemProperties;
    }

    @Override
    public Map<String, String> getSiteConfiguration() throws AccumuloException, AccumuloSecurityException {
        return this.acu.systemProperties;
    }

    @Override
    public List<String> getTabletServers() {
        return new ArrayList<String>();
    }

    @Override
    public List<ActiveScan> getActiveScans(String tserver) throws AccumuloException, AccumuloSecurityException {
        return new ArrayList<ActiveScan>();
    }

    @Override
    public boolean testClassLoad(String className, String asTypeName) throws AccumuloException, AccumuloSecurityException {
        try {
            AccumuloVFSClassLoader.loadClass((String)className, Class.forName(asTypeName));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public List<ActiveCompaction> getActiveCompactions(String tserver) throws AccumuloException, AccumuloSecurityException {
        return new ArrayList<ActiveCompaction>();
    }

    @Override
    public void ping(String tserver) throws AccumuloException {
    }
}

